/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2EventAdapter;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.codec.http2.HttpConversionUtil$ExtensionHeaderNames;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapter$1;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapter$ImmediateSendDetector;
import io.netty.util.internal.ObjectUtil;

public class InboundHttp2ToHttpAdapter
extends Http2EventAdapter {
    private static final InboundHttp2ToHttpAdapter$ImmediateSendDetector DEFAULT_SEND_DETECTOR = new InboundHttp2ToHttpAdapter$1();
    private final int maxContentLength;
    private final InboundHttp2ToHttpAdapter$ImmediateSendDetector sendDetector;
    private final Http2Connection.PropertyKey messageKey;
    private final boolean propagateSettings;
    protected final Http2Connection connection;
    protected final boolean validateHttpHeaders;

    protected InboundHttp2ToHttpAdapter(Http2Connection http2Connection, int n2, boolean bl2, boolean bl3) {
        ObjectUtil.checkNotNull(http2Connection, "connection");
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxContentLength: " + n2 + " (expected: > 0)");
        }
        this.connection = http2Connection;
        this.maxContentLength = n2;
        this.validateHttpHeaders = bl2;
        this.propagateSettings = bl3;
        this.sendDetector = DEFAULT_SEND_DETECTOR;
        this.messageKey = http2Connection.newKey();
    }

    protected final void removeMessage(Http2Stream http2Stream, boolean bl2) {
        FullHttpMessage fullHttpMessage = (FullHttpMessage)http2Stream.removeProperty(this.messageKey);
        if (bl2 && fullHttpMessage != null) {
            fullHttpMessage.release();
        }
    }

    protected final FullHttpMessage getMessage(Http2Stream http2Stream) {
        return (FullHttpMessage)http2Stream.getProperty(this.messageKey);
    }

    protected final void putMessage(Http2Stream http2Stream, FullHttpMessage fullHttpMessage) {
        FullHttpMessage fullHttpMessage2 = http2Stream.setProperty(this.messageKey, fullHttpMessage);
        if (fullHttpMessage2 != fullHttpMessage && fullHttpMessage2 != null) {
            fullHttpMessage2.release();
        }
    }

    @Override
    public void onStreamRemoved(Http2Stream http2Stream) {
        this.removeMessage(http2Stream, true);
    }

    protected void fireChannelRead(ChannelHandlerContext channelHandlerContext, FullHttpMessage fullHttpMessage, boolean bl2, Http2Stream http2Stream) {
        this.removeMessage(http2Stream, bl2);
        HttpUtil.setContentLength(fullHttpMessage, fullHttpMessage.content().readableBytes());
        channelHandlerContext.fireChannelRead(fullHttpMessage);
    }

    protected FullHttpMessage newMessage(Http2Stream http2Stream, Http2Headers http2Headers, boolean bl2, ByteBufAllocator byteBufAllocator) {
        return this.connection.isServer() ? HttpConversionUtil.toFullHttpRequest(http2Stream.id(), http2Headers, byteBufAllocator, bl2) : HttpConversionUtil.toFullHttpResponse(http2Stream.id(), http2Headers, byteBufAllocator, bl2);
    }

    protected FullHttpMessage processHeadersBegin(ChannelHandlerContext channelHandlerContext, Http2Stream http2Stream, Http2Headers http2Headers, boolean bl2, boolean bl3, boolean bl4) {
        FullHttpMessage fullHttpMessage = this.getMessage(http2Stream);
        boolean bl5 = true;
        if (fullHttpMessage == null) {
            fullHttpMessage = this.newMessage(http2Stream, http2Headers, this.validateHttpHeaders, channelHandlerContext.alloc());
        } else if (bl3) {
            bl5 = false;
            HttpConversionUtil.addHttp2ToHttpHeaders(http2Stream.id(), http2Headers, fullHttpMessage, bl4);
        } else {
            bl5 = false;
            fullHttpMessage = null;
        }
        if (this.sendDetector.mustSendImmediately(fullHttpMessage)) {
            FullHttpMessage fullHttpMessage2 = bl2 ? null : this.sendDetector.copyIfNeeded(fullHttpMessage);
            this.fireChannelRead(channelHandlerContext, fullHttpMessage, bl5, http2Stream);
            return fullHttpMessage2;
        }
        return fullHttpMessage;
    }

    private void processHeadersEnd(ChannelHandlerContext channelHandlerContext, Http2Stream http2Stream, FullHttpMessage fullHttpMessage, boolean bl2) {
        if (bl2) {
            this.fireChannelRead(channelHandlerContext, fullHttpMessage, this.getMessage(http2Stream) != fullHttpMessage, http2Stream);
        } else {
            this.putMessage(http2Stream, fullHttpMessage);
        }
    }

    @Override
    public int onDataRead(ChannelHandlerContext channelHandlerContext, int n2, ByteBuf byteBuf, int n3, boolean bl2) {
        Http2Stream http2Stream = this.connection.stream(n2);
        FullHttpMessage fullHttpMessage = this.getMessage(http2Stream);
        if (fullHttpMessage == null) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Data Frame received for unknown stream id %d", n2);
        }
        ByteBuf byteBuf2 = fullHttpMessage.content();
        int n4 = byteBuf.readableBytes();
        if (byteBuf2.readableBytes() > this.maxContentLength - n4) {
            throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, "Content length exceeded max of %d for stream id %d", this.maxContentLength, n2);
        }
        byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), n4);
        if (bl2) {
            this.fireChannelRead(channelHandlerContext, fullHttpMessage, false, http2Stream);
        }
        return n4 + n3;
    }

    @Override
    public void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n2, Http2Headers http2Headers, int n3, boolean bl2) {
        Http2Stream http2Stream = this.connection.stream(n2);
        FullHttpMessage fullHttpMessage = this.processHeadersBegin(channelHandlerContext, http2Stream, http2Headers, bl2, true, true);
        if (fullHttpMessage != null) {
            this.processHeadersEnd(channelHandlerContext, http2Stream, fullHttpMessage, bl2);
        }
    }

    @Override
    public void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n2, Http2Headers http2Headers, int n3, short s2, boolean bl2, int n4, boolean bl3) {
        Http2Stream http2Stream = this.connection.stream(n2);
        FullHttpMessage fullHttpMessage = this.processHeadersBegin(channelHandlerContext, http2Stream, http2Headers, bl3, true, true);
        if (fullHttpMessage != null) {
            if (n3 != 0) {
                fullHttpMessage.headers().setInt(HttpConversionUtil$ExtensionHeaderNames.STREAM_DEPENDENCY_ID.text(), n3);
            }
            fullHttpMessage.headers().setShort(HttpConversionUtil$ExtensionHeaderNames.STREAM_WEIGHT.text(), s2);
            this.processHeadersEnd(channelHandlerContext, http2Stream, fullHttpMessage, bl3);
        }
    }

    @Override
    public void onRstStreamRead(ChannelHandlerContext channelHandlerContext, int n2, long l2) {
        Http2Stream http2Stream = this.connection.stream(n2);
        FullHttpMessage fullHttpMessage = this.getMessage(http2Stream);
        if (fullHttpMessage != null) {
            this.onRstStreamRead(http2Stream, fullHttpMessage);
        }
        channelHandlerContext.fireExceptionCaught(Http2Exception.streamError(n2, Http2Error.valueOf(l2), "HTTP/2 to HTTP layer caught stream reset", new Object[0]));
    }

    @Override
    public void onPushPromiseRead(ChannelHandlerContext channelHandlerContext, int n2, int n3, Http2Headers http2Headers, int n4) {
        FullHttpMessage fullHttpMessage;
        Http2Stream http2Stream = this.connection.stream(n3);
        if (http2Headers.status() == null) {
            http2Headers.status(HttpResponseStatus.OK.codeAsText());
        }
        if ((fullHttpMessage = this.processHeadersBegin(channelHandlerContext, http2Stream, http2Headers, false, false, false)) == null) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Push Promise Frame received for pre-existing stream id %d", n3);
        }
        fullHttpMessage.headers().setInt(HttpConversionUtil$ExtensionHeaderNames.STREAM_PROMISE_ID.text(), n2);
        fullHttpMessage.headers().setShort(HttpConversionUtil$ExtensionHeaderNames.STREAM_WEIGHT.text(), (short)16);
        this.processHeadersEnd(channelHandlerContext, http2Stream, fullHttpMessage, false);
    }

    @Override
    public void onSettingsRead(ChannelHandlerContext channelHandlerContext, Http2Settings http2Settings) {
        if (this.propagateSettings) {
            channelHandlerContext.fireChannelRead(http2Settings);
        }
    }

    protected void onRstStreamRead(Http2Stream http2Stream, FullHttpMessage fullHttpMessage) {
        this.removeMessage(http2Stream, true);
    }
}

