/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.EmptyHttp2Headers;
import io.netty.handler.codec.http2.Http2CodecUtil$SimpleChannelPromiseAggregator;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.codec.http2.HttpConversionUtil$ExtensionHeaderNames;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import java.util.Map;

public class HttpToHttp2ConnectionHandler
extends Http2ConnectionHandler {
    private final boolean validateHeaders;
    private int currentStreamId;

    protected HttpToHttp2ConnectionHandler(Http2ConnectionDecoder http2ConnectionDecoder, Http2ConnectionEncoder http2ConnectionEncoder, Http2Settings http2Settings, boolean bl2) {
        super(http2ConnectionDecoder, http2ConnectionEncoder, http2Settings);
        this.validateHeaders = bl2;
    }

    private int getStreamId(HttpHeaders httpHeaders) {
        return httpHeaders.getInt(HttpConversionUtil$ExtensionHeaderNames.STREAM_ID.text(), this.connection().local().incrementAndGetNextStreamId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (!(object instanceof HttpMessage) && !(object instanceof HttpContent)) {
            channelHandlerContext.write(object, channelPromise);
            return;
        }
        boolean bl2 = true;
        Http2CodecUtil$SimpleChannelPromiseAggregator http2CodecUtil$SimpleChannelPromiseAggregator = new Http2CodecUtil$SimpleChannelPromiseAggregator(channelPromise, channelHandlerContext.channel(), channelHandlerContext.executor());
        try {
            Iterable<Map.Entry<String, String>> iterable;
            Http2ConnectionEncoder http2ConnectionEncoder = this.encoder();
            boolean bl3 = false;
            if (object instanceof HttpMessage) {
                HttpMessage httpMessage = (HttpMessage)object;
                this.currentStreamId = this.getStreamId(httpMessage.headers());
                iterable = HttpConversionUtil.toHttp2Headers(httpMessage, this.validateHeaders);
                bl3 = object instanceof FullHttpMessage && !((FullHttpMessage)object).content().isReadable();
                HttpToHttp2ConnectionHandler.writeHeaders(channelHandlerContext, http2ConnectionEncoder, this.currentStreamId, httpMessage.headers(), (Http2Headers)iterable, bl3, http2CodecUtil$SimpleChannelPromiseAggregator);
            }
            if (!bl3 && object instanceof HttpContent) {
                ReferenceCounted referenceCounted;
                boolean bl4 = false;
                iterable = EmptyHttpHeaders.INSTANCE;
                Http2Headers http2Headers = EmptyHttp2Headers.INSTANCE;
                if (object instanceof LastHttpContent) {
                    bl4 = true;
                    referenceCounted = (LastHttpContent)object;
                    iterable = referenceCounted.trailingHeaders();
                    http2Headers = HttpConversionUtil.toHttp2Headers((HttpHeaders)iterable, this.validateHeaders);
                }
                referenceCounted = ((HttpContent)object).content();
                bl3 = bl4 && ((HttpHeaders)iterable).isEmpty();
                bl2 = false;
                http2ConnectionEncoder.writeData(channelHandlerContext, this.currentStreamId, (ByteBuf)referenceCounted, 0, bl3, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
                if (!((HttpHeaders)iterable).isEmpty()) {
                    HttpToHttp2ConnectionHandler.writeHeaders(channelHandlerContext, http2ConnectionEncoder, this.currentStreamId, iterable, http2Headers, true, http2CodecUtil$SimpleChannelPromiseAggregator);
                }
            }
        }
        catch (Throwable throwable) {
            this.onError(channelHandlerContext, true, throwable);
            http2CodecUtil$SimpleChannelPromiseAggregator.setFailure(throwable);
        }
        finally {
            if (bl2) {
                ReferenceCountUtil.release(object);
            }
            http2CodecUtil$SimpleChannelPromiseAggregator.doneAllocatingPromises();
        }
    }

    private static void writeHeaders(ChannelHandlerContext channelHandlerContext, Http2ConnectionEncoder http2ConnectionEncoder, int n2, HttpHeaders httpHeaders, Http2Headers http2Headers, boolean bl2, Http2CodecUtil$SimpleChannelPromiseAggregator http2CodecUtil$SimpleChannelPromiseAggregator) {
        int n3 = httpHeaders.getInt(HttpConversionUtil$ExtensionHeaderNames.STREAM_DEPENDENCY_ID.text(), 0);
        short s2 = httpHeaders.getShort(HttpConversionUtil$ExtensionHeaderNames.STREAM_WEIGHT.text(), (short)16);
        http2ConnectionEncoder.writeHeaders(channelHandlerContext, n2, http2Headers, n3, s2, false, 0, bl2, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
    }
}

