/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http2.CharSequenceMap;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers$PseudoHeaderName;
import io.netty.handler.codec.http2.HttpConversionUtil$ExtensionHeaderNames;
import io.netty.util.AsciiString;
import java.util.Map;

final class HttpConversionUtil$Http2ToHttpHeaderTranslator {
    private static final CharSequenceMap<AsciiString> REQUEST_HEADER_TRANSLATIONS = new CharSequenceMap();
    private static final CharSequenceMap<AsciiString> RESPONSE_HEADER_TRANSLATIONS = new CharSequenceMap();
    private final int streamId;
    private final HttpHeaders output;
    private final CharSequenceMap<AsciiString> translations;

    HttpConversionUtil$Http2ToHttpHeaderTranslator(int n2, HttpHeaders httpHeaders, boolean bl2) {
        this.streamId = n2;
        this.output = httpHeaders;
        this.translations = bl2 ? REQUEST_HEADER_TRANSLATIONS : RESPONSE_HEADER_TRANSLATIONS;
    }

    public void translate(Map.Entry<CharSequence, CharSequence> entry) {
        CharSequence charSequence = entry.getKey();
        CharSequence charSequence2 = entry.getValue();
        AsciiString asciiString = (AsciiString)this.translations.get(charSequence);
        if (asciiString != null) {
            this.output.add((CharSequence)asciiString, (Object)AsciiString.of(charSequence2));
        } else if (!Http2Headers$PseudoHeaderName.isPseudoHeader(charSequence)) {
            if (charSequence.length() == 0 || charSequence.charAt(0) == ':') {
                throw Http2Exception.streamError(this.streamId, Http2Error.PROTOCOL_ERROR, "Invalid HTTP/2 header '%s' encountered in translation to HTTP/1.x", charSequence);
            }
            if (HttpHeaderNames.COOKIE.equals(charSequence)) {
                String string = this.output.get(HttpHeaderNames.COOKIE);
                this.output.set((CharSequence)HttpHeaderNames.COOKIE, (Object)(string != null ? string + "; " + charSequence2 : charSequence2));
            } else {
                this.output.add(charSequence, (Object)charSequence2);
            }
        }
    }

    static {
        RESPONSE_HEADER_TRANSLATIONS.add(Http2Headers$PseudoHeaderName.AUTHORITY.value(), HttpHeaderNames.HOST);
        RESPONSE_HEADER_TRANSLATIONS.add(Http2Headers$PseudoHeaderName.SCHEME.value(), HttpConversionUtil$ExtensionHeaderNames.SCHEME.text());
        REQUEST_HEADER_TRANSLATIONS.add(RESPONSE_HEADER_TRANSLATIONS);
        RESPONSE_HEADER_TRANSLATIONS.add(Http2Headers$PseudoHeaderName.PATH.value(), HttpConversionUtil$ExtensionHeaderNames.PATH.text());
    }
}

