/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http2.Http2MultiplexCodec;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap$1;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap$2;
import io.netty.util.AbstractConstant;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.channels.ClosedChannelException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Http2StreamChannelBootstrap {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Http2StreamChannelBootstrap.class);
    private final Map<ChannelOption<?>, Object> options = new LinkedHashMap();
    private final Map<AttributeKey<?>, Object> attrs = new LinkedHashMap();
    private final Channel channel;
    private volatile ChannelHandler handler;

    public Http2StreamChannelBootstrap(Channel channel) {
        this.channel = ObjectUtil.checkNotNull(channel, "channel");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Http2StreamChannelBootstrap option(ChannelOption<T> channelOption, T t2) {
        if (channelOption == null) {
            throw new NullPointerException("option");
        }
        if (t2 == null) {
            Map<ChannelOption<?>, Object> map = this.options;
            synchronized (map) {
                this.options.remove(channelOption);
            }
        }
        Map<ChannelOption<?>, Object> map = this.options;
        synchronized (map) {
            this.options.put(channelOption, t2);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Http2StreamChannelBootstrap attr(AttributeKey<T> attributeKey, T t2) {
        if (attributeKey == null) {
            throw new NullPointerException("key");
        }
        if (t2 == null) {
            Map<AttributeKey<?>, Object> map = this.attrs;
            synchronized (map) {
                this.attrs.remove(attributeKey);
            }
        }
        Map<AttributeKey<?>, Object> map = this.attrs;
        synchronized (map) {
            this.attrs.put(attributeKey, t2);
        }
        return this;
    }

    public Http2StreamChannelBootstrap handler(ChannelHandler channelHandler) {
        this.handler = ObjectUtil.checkNotNull(channelHandler, "handler");
        return this;
    }

    public Future<Http2StreamChannel> open() {
        return this.open(this.channel.eventLoop().newPromise());
    }

    public Future<Http2StreamChannel> open(Promise<Http2StreamChannel> promise) {
        ChannelHandlerContext channelHandlerContext = this.channel.pipeline().context(Http2MultiplexCodec.class);
        if (channelHandlerContext == null) {
            if (this.channel.isActive()) {
                promise.setFailure(new IllegalStateException(StringUtil.simpleClassName(Http2MultiplexCodec.class) + " must be in the ChannelPipeline of Channel " + this.channel));
            } else {
                promise.setFailure(new ClosedChannelException());
            }
        } else {
            EventExecutor eventExecutor = channelHandlerContext.executor();
            if (eventExecutor.inEventLoop()) {
                this.open0(channelHandlerContext, promise);
            } else {
                eventExecutor.execute(new Http2StreamChannelBootstrap$1(this, channelHandlerContext, promise));
            }
        }
        return promise;
    }

    public void open0(ChannelHandlerContext channelHandlerContext, Promise<Http2StreamChannel> promise) {
        assert (channelHandlerContext.executor().inEventLoop());
        Http2StreamChannel http2StreamChannel = ((Http2MultiplexCodec)channelHandlerContext.handler()).newOutboundStream();
        try {
            this.init(http2StreamChannel);
        }
        catch (Exception exception) {
            http2StreamChannel.unsafe().closeForcibly();
            promise.setFailure(exception);
            return;
        }
        ChannelFuture channelFuture = channelHandlerContext.channel().eventLoop().register(http2StreamChannel);
        channelFuture.addListener(new Http2StreamChannelBootstrap$2(this, promise, http2StreamChannel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Channel channel) {
        ChannelPipeline channelPipeline = channel.pipeline();
        ChannelHandler channelHandler = this.handler;
        if (channelHandler != null) {
            channelPipeline.addLast(channelHandler);
        }
        Map<AbstractConstant, Object> map = this.options;
        synchronized (map) {
            Http2StreamChannelBootstrap.setChannelOptions(channel, this.options, logger);
        }
        map = this.attrs;
        synchronized (map) {
            for (Map.Entry<AttributeKey<?>, Object> entry : this.attrs.entrySet()) {
                channel.attr(entry.getKey()).set(entry.getValue());
            }
        }
    }

    private static void setChannelOptions(Channel channel, Map<ChannelOption<?>, Object> map, InternalLogger internalLogger) {
        for (Map.Entry<ChannelOption<?>, Object> entry : map.entrySet()) {
            Http2StreamChannelBootstrap.setChannelOption(channel, entry.getKey(), entry.getValue(), internalLogger);
        }
    }

    private static void setChannelOption(Channel channel, ChannelOption<?> channelOption, Object object, InternalLogger internalLogger) {
        try {
            if (!channel.config().setOption(channelOption, object)) {
                internalLogger.warn("Unknown channel option '{}' for channel '{}'", (Object)channelOption, (Object)channel);
            }
        }
        catch (Throwable throwable) {
            internalLogger.warn("Failed to set channel option '{}' with value '{}' for channel '{}'", channelOption, object, channel, throwable);
        }
    }
}

