/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.util.collection.CharObjectHashMap;
import io.netty.util.internal.ObjectUtil;

public final class Http2Settings
extends CharObjectHashMap<Long> {
    private static final int DEFAULT_CAPACITY = 13;
    private static final Long FALSE = 0L;
    private static final Long TRUE = 1L;

    public Http2Settings() {
        this(13);
    }

    public Http2Settings(int n2, float f2) {
        super(n2, f2);
    }

    public Http2Settings(int n2) {
        super(n2);
    }

    @Override
    public Long put(char c2, Long l2) {
        Http2Settings.verifyStandardSetting(c2, l2);
        return super.put(c2, l2);
    }

    public Long headerTableSize() {
        return (Long)this.get('\u0001');
    }

    public Http2Settings headerTableSize(long l2) {
        this.put('\u0001', l2);
        return this;
    }

    public Boolean pushEnabled() {
        Long l2 = (Long)this.get('\u0002');
        if (l2 == null) {
            return null;
        }
        return TRUE.equals(l2);
    }

    public Http2Settings pushEnabled(boolean bl2) {
        this.put('\u0002', bl2 ? TRUE : FALSE);
        return this;
    }

    public Long maxConcurrentStreams() {
        return (Long)this.get('\u0003');
    }

    public Http2Settings maxConcurrentStreams(long l2) {
        this.put('\u0003', l2);
        return this;
    }

    public Integer initialWindowSize() {
        return this.getIntValue('\u0004');
    }

    public Http2Settings initialWindowSize(int n2) {
        this.put('\u0004', Long.valueOf(n2));
        return this;
    }

    public Integer maxFrameSize() {
        return this.getIntValue('\u0005');
    }

    public Http2Settings maxFrameSize(int n2) {
        this.put('\u0005', Long.valueOf(n2));
        return this;
    }

    public Long maxHeaderListSize() {
        return (Long)this.get('\u0006');
    }

    public Http2Settings maxHeaderListSize(long l2) {
        this.put('\u0006', l2);
        return this;
    }

    public Http2Settings copyFrom(Http2Settings http2Settings) {
        this.clear();
        this.putAll(http2Settings);
        return this;
    }

    public Integer getIntValue(char c2) {
        Long l2 = (Long)this.get(c2);
        if (l2 == null) {
            return null;
        }
        return l2.intValue();
    }

    private static void verifyStandardSetting(int n2, Long l2) {
        ObjectUtil.checkNotNull(l2, "value");
        switch (n2) {
            case 1: {
                if (l2 >= 0L && l2 <= 0xFFFFFFFFL) break;
                throw new IllegalArgumentException("Setting HEADER_TABLE_SIZE is invalid: " + l2);
            }
            case 2: {
                if (l2 == 0L || l2 == 1L) break;
                throw new IllegalArgumentException("Setting ENABLE_PUSH is invalid: " + l2);
            }
            case 3: {
                if (l2 >= 0L && l2 <= 0xFFFFFFFFL) break;
                throw new IllegalArgumentException("Setting MAX_CONCURRENT_STREAMS is invalid: " + l2);
            }
            case 4: {
                if (l2 >= 0L && l2 <= Integer.MAX_VALUE) break;
                throw new IllegalArgumentException("Setting INITIAL_WINDOW_SIZE is invalid: " + l2);
            }
            case 5: {
                if (Http2CodecUtil.isMaxFrameSizeValid(l2.intValue())) break;
                throw new IllegalArgumentException("Setting MAX_FRAME_SIZE is invalid: " + l2);
            }
            case 6: {
                if (l2 >= 0L && l2 <= 0xFFFFFFFFL) break;
                throw new IllegalArgumentException("Setting MAX_HEADER_LIST_SIZE is invalid: " + l2);
            }
        }
    }

    @Override
    protected String keyToString(char c2) {
        switch (c2) {
            case '\u0001': {
                return "HEADER_TABLE_SIZE";
            }
            case '\u0002': {
                return "ENABLE_PUSH";
            }
            case '\u0003': {
                return "MAX_CONCURRENT_STREAMS";
            }
            case '\u0004': {
                return "INITIAL_WINDOW_SIZE";
            }
            case '\u0005': {
                return "MAX_FRAME_SIZE";
            }
            case '\u0006': {
                return "MAX_HEADER_LIST_SIZE";
            }
        }
        return super.keyToString(c2);
    }

    public static Http2Settings defaultSettings() {
        return new Http2Settings().maxHeaderListSize(8192L);
    }
}

