/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2FrameLogger$Direction;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2FrameWriter$Configuration;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.util.internal.ObjectUtil;

public class Http2OutboundFrameLogger
implements Http2FrameWriter {
    private final Http2FrameWriter writer;
    private final Http2FrameLogger logger;

    public Http2OutboundFrameLogger(Http2FrameWriter http2FrameWriter, Http2FrameLogger http2FrameLogger) {
        this.writer = ObjectUtil.checkNotNull(http2FrameWriter, "writer");
        this.logger = ObjectUtil.checkNotNull(http2FrameLogger, "logger");
    }

    @Override
    public ChannelFuture writeData(ChannelHandlerContext channelHandlerContext, int n2, ByteBuf byteBuf, int n3, boolean bl2, ChannelPromise channelPromise) {
        this.logger.logData(Http2FrameLogger$Direction.OUTBOUND, channelHandlerContext, n2, byteBuf, n3, bl2);
        return this.writer.writeData(channelHandlerContext, n2, byteBuf, n3, bl2, channelPromise);
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext channelHandlerContext, int n2, Http2Headers http2Headers, int n3, boolean bl2, ChannelPromise channelPromise) {
        this.logger.logHeaders(Http2FrameLogger$Direction.OUTBOUND, channelHandlerContext, n2, http2Headers, n3, bl2);
        return this.writer.writeHeaders(channelHandlerContext, n2, http2Headers, n3, bl2, channelPromise);
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext channelHandlerContext, int n2, Http2Headers http2Headers, int n3, short s2, boolean bl2, int n4, boolean bl3, ChannelPromise channelPromise) {
        this.logger.logHeaders(Http2FrameLogger$Direction.OUTBOUND, channelHandlerContext, n2, http2Headers, n3, s2, bl2, n4, bl3);
        return this.writer.writeHeaders(channelHandlerContext, n2, http2Headers, n3, s2, bl2, n4, bl3, channelPromise);
    }

    @Override
    public ChannelFuture writePriority(ChannelHandlerContext channelHandlerContext, int n2, int n3, short s2, boolean bl2, ChannelPromise channelPromise) {
        this.logger.logPriority(Http2FrameLogger$Direction.OUTBOUND, channelHandlerContext, n2, n3, s2, bl2);
        return this.writer.writePriority(channelHandlerContext, n2, n3, s2, bl2, channelPromise);
    }

    @Override
    public ChannelFuture writeRstStream(ChannelHandlerContext channelHandlerContext, int n2, long l2, ChannelPromise channelPromise) {
        this.logger.logRstStream(Http2FrameLogger$Direction.OUTBOUND, channelHandlerContext, n2, l2);
        return this.writer.writeRstStream(channelHandlerContext, n2, l2, channelPromise);
    }

    @Override
    public ChannelFuture writeSettings(ChannelHandlerContext channelHandlerContext, Http2Settings http2Settings, ChannelPromise channelPromise) {
        this.logger.logSettings(Http2FrameLogger$Direction.OUTBOUND, channelHandlerContext, http2Settings);
        return this.writer.writeSettings(channelHandlerContext, http2Settings, channelPromise);
    }

    @Override
    public ChannelFuture writeSettingsAck(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        this.logger.logSettingsAck(Http2FrameLogger$Direction.OUTBOUND, channelHandlerContext);
        return this.writer.writeSettingsAck(channelHandlerContext, channelPromise);
    }

    @Override
    public ChannelFuture writePing(ChannelHandlerContext channelHandlerContext, boolean bl2, long l2, ChannelPromise channelPromise) {
        if (bl2) {
            this.logger.logPingAck(Http2FrameLogger$Direction.OUTBOUND, channelHandlerContext, l2);
        } else {
            this.logger.logPing(Http2FrameLogger$Direction.OUTBOUND, channelHandlerContext, l2);
        }
        return this.writer.writePing(channelHandlerContext, bl2, l2, channelPromise);
    }

    @Override
    public ChannelFuture writePushPromise(ChannelHandlerContext channelHandlerContext, int n2, int n3, Http2Headers http2Headers, int n4, ChannelPromise channelPromise) {
        this.logger.logPushPromise(Http2FrameLogger$Direction.OUTBOUND, channelHandlerContext, n2, n3, http2Headers, n4);
        return this.writer.writePushPromise(channelHandlerContext, n2, n3, http2Headers, n4, channelPromise);
    }

    @Override
    public ChannelFuture writeGoAway(ChannelHandlerContext channelHandlerContext, int n2, long l2, ByteBuf byteBuf, ChannelPromise channelPromise) {
        this.logger.logGoAway(Http2FrameLogger$Direction.OUTBOUND, channelHandlerContext, n2, l2, byteBuf);
        return this.writer.writeGoAway(channelHandlerContext, n2, l2, byteBuf, channelPromise);
    }

    @Override
    public ChannelFuture writeWindowUpdate(ChannelHandlerContext channelHandlerContext, int n2, int n3, ChannelPromise channelPromise) {
        this.logger.logWindowsUpdate(Http2FrameLogger$Direction.OUTBOUND, channelHandlerContext, n2, n3);
        return this.writer.writeWindowUpdate(channelHandlerContext, n2, n3, channelPromise);
    }

    @Override
    public ChannelFuture writeFrame(ChannelHandlerContext channelHandlerContext, byte by2, int n2, Http2Flags http2Flags, ByteBuf byteBuf, ChannelPromise channelPromise) {
        this.logger.logUnknownFrame(Http2FrameLogger$Direction.OUTBOUND, channelHandlerContext, by2, n2, http2Flags, byteBuf);
        return this.writer.writeFrame(channelHandlerContext, by2, n2, http2Flags, byteBuf, channelPromise);
    }

    @Override
    public void close() {
        this.writer.close();
    }

    @Override
    public Http2FrameWriter$Configuration configuration() {
        return this.writer.configuration();
    }
}

