/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandler$Sharable;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.handler.codec.http2.AbstractHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2HeadersEncoder$SensitivityDetector;
import io.netty.handler.codec.http2.Http2MultiplexCodec;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.util.internal.ObjectUtil;

public class Http2MultiplexCodecBuilder
extends AbstractHttp2ConnectionHandlerBuilder<Http2MultiplexCodec, Http2MultiplexCodecBuilder> {
    final ChannelHandler childHandler;

    Http2MultiplexCodecBuilder(boolean bl2, ChannelHandler channelHandler) {
        this.server(bl2);
        this.childHandler = Http2MultiplexCodecBuilder.checkSharable(ObjectUtil.checkNotNull(channelHandler, "childHandler"));
    }

    private static ChannelHandler checkSharable(ChannelHandler channelHandler) {
        if (channelHandler instanceof ChannelHandlerAdapter && !((ChannelHandlerAdapter)channelHandler).isSharable() && !channelHandler.getClass().isAnnotationPresent(ChannelHandler$Sharable.class)) {
            throw new IllegalArgumentException("The handler must be Sharable");
        }
        return channelHandler;
    }

    public static Http2MultiplexCodecBuilder forClient(ChannelHandler channelHandler) {
        return new Http2MultiplexCodecBuilder(false, channelHandler);
    }

    public static Http2MultiplexCodecBuilder forServer(ChannelHandler channelHandler) {
        return new Http2MultiplexCodecBuilder(true, channelHandler);
    }

    @Override
    public Http2Settings initialSettings() {
        return super.initialSettings();
    }

    @Override
    public Http2MultiplexCodecBuilder initialSettings(Http2Settings http2Settings) {
        return (Http2MultiplexCodecBuilder)super.initialSettings(http2Settings);
    }

    @Override
    public long gracefulShutdownTimeoutMillis() {
        return super.gracefulShutdownTimeoutMillis();
    }

    @Override
    public Http2MultiplexCodecBuilder gracefulShutdownTimeoutMillis(long l2) {
        return (Http2MultiplexCodecBuilder)super.gracefulShutdownTimeoutMillis(l2);
    }

    @Override
    public boolean isServer() {
        return super.isServer();
    }

    @Override
    public int maxReservedStreams() {
        return super.maxReservedStreams();
    }

    @Override
    public Http2MultiplexCodecBuilder maxReservedStreams(int n2) {
        return (Http2MultiplexCodecBuilder)super.maxReservedStreams(n2);
    }

    @Override
    public boolean isValidateHeaders() {
        return super.isValidateHeaders();
    }

    @Override
    public Http2MultiplexCodecBuilder validateHeaders(boolean bl2) {
        return (Http2MultiplexCodecBuilder)super.validateHeaders(bl2);
    }

    @Override
    public Http2FrameLogger frameLogger() {
        return super.frameLogger();
    }

    @Override
    public Http2MultiplexCodecBuilder frameLogger(Http2FrameLogger http2FrameLogger) {
        return (Http2MultiplexCodecBuilder)super.frameLogger(http2FrameLogger);
    }

    @Override
    public boolean encoderEnforceMaxConcurrentStreams() {
        return super.encoderEnforceMaxConcurrentStreams();
    }

    @Override
    public Http2MultiplexCodecBuilder encoderEnforceMaxConcurrentStreams(boolean bl2) {
        return (Http2MultiplexCodecBuilder)super.encoderEnforceMaxConcurrentStreams(bl2);
    }

    @Override
    public Http2HeadersEncoder$SensitivityDetector headerSensitivityDetector() {
        return super.headerSensitivityDetector();
    }

    @Override
    public Http2MultiplexCodecBuilder headerSensitivityDetector(Http2HeadersEncoder$SensitivityDetector http2HeadersEncoder$SensitivityDetector) {
        return (Http2MultiplexCodecBuilder)super.headerSensitivityDetector(http2HeadersEncoder$SensitivityDetector);
    }

    @Override
    public Http2MultiplexCodecBuilder encoderIgnoreMaxHeaderListSize(boolean bl2) {
        return (Http2MultiplexCodecBuilder)super.encoderIgnoreMaxHeaderListSize(bl2);
    }

    @Override
    public Http2MultiplexCodecBuilder initialHuffmanDecodeCapacity(int n2) {
        return (Http2MultiplexCodecBuilder)super.initialHuffmanDecodeCapacity(n2);
    }

    @Override
    public Http2MultiplexCodec build() {
        return (Http2MultiplexCodec)super.build();
    }

    @Override
    protected Http2MultiplexCodec build(Http2ConnectionDecoder http2ConnectionDecoder, Http2ConnectionEncoder http2ConnectionEncoder, Http2Settings http2Settings) {
        return new Http2MultiplexCodec(http2ConnectionEncoder, http2ConnectionDecoder, http2Settings, this.childHandler);
    }
}

