/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelMetadata;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Frame;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameCodec$DefaultHttp2FrameStream;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2FrameStreamException;
import io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.netty.handler.codec.http2.Http2MultiplexCodec$1;
import io.netty.handler.codec.http2.Http2MultiplexCodec$2;
import io.netty.handler.codec.http2.Http2MultiplexCodec$DefaultHttp2StreamChannel;
import io.netty.handler.codec.http2.Http2MultiplexCodec$Http2MultiplexCodecStream;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2SettingsFrame;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamFrame;
import io.netty.util.internal.ThrowableUtil;
import java.nio.channels.ClosedChannelException;

public class Http2MultiplexCodec
extends Http2FrameCodec {
    private static final ChannelFutureListener CHILD_CHANNEL_REGISTRATION_LISTENER = new Http2MultiplexCodec$1();
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);
    private static final ClosedChannelException CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), DefaultHttp2StreamChannel$Http2ChannelUnsafe.class, "write(...)");
    private static final int MIN_HTTP2_FRAME_SIZE = 9;
    private final ChannelHandler inboundStreamHandler;
    private int initialOutboundStreamWindow = 65535;
    private boolean parentReadInProgress;
    private int idCount;
    private Http2MultiplexCodec$DefaultHttp2StreamChannel head;
    private Http2MultiplexCodec$DefaultHttp2StreamChannel tail;
    volatile ChannelHandlerContext ctx;

    Http2MultiplexCodec(Http2ConnectionEncoder http2ConnectionEncoder, Http2ConnectionDecoder http2ConnectionDecoder, Http2Settings http2Settings, ChannelHandler channelHandler) {
        super(http2ConnectionEncoder, http2ConnectionDecoder, http2Settings);
        this.inboundStreamHandler = channelHandler;
    }

    private static void registerDone(ChannelFuture channelFuture) {
        if (!channelFuture.isSuccess()) {
            Channel channel = channelFuture.channel();
            if (channel.isRegistered()) {
                channel.close();
            } else {
                channel.unsafe().closeForcibly();
            }
        }
    }

    @Override
    public final void handlerAdded0(ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext.executor() != channelHandlerContext.channel().eventLoop()) {
            throw new IllegalStateException("EventExecutor must be EventLoop of Channel");
        }
        this.ctx = channelHandlerContext;
    }

    @Override
    public final void handlerRemoved0(ChannelHandlerContext channelHandlerContext) {
        super.handlerRemoved0(channelHandlerContext);
        Http2MultiplexCodec$DefaultHttp2StreamChannel http2MultiplexCodec$DefaultHttp2StreamChannel = this.head;
        while (http2MultiplexCodec$DefaultHttp2StreamChannel != null) {
            Http2MultiplexCodec$DefaultHttp2StreamChannel http2MultiplexCodec$DefaultHttp2StreamChannel2 = http2MultiplexCodec$DefaultHttp2StreamChannel;
            http2MultiplexCodec$DefaultHttp2StreamChannel = http2MultiplexCodec$DefaultHttp2StreamChannel2.next;
            http2MultiplexCodec$DefaultHttp2StreamChannel2.next = null;
        }
        this.tail = null;
        this.head = null;
    }

    @Override
    Http2MultiplexCodec$Http2MultiplexCodecStream newStream() {
        return new Http2MultiplexCodec$Http2MultiplexCodecStream();
    }

    @Override
    final void onHttp2Frame(ChannelHandlerContext channelHandlerContext, Http2Frame http2Frame) {
        if (http2Frame instanceof Http2StreamFrame) {
            Http2StreamFrame http2StreamFrame = (Http2StreamFrame)http2Frame;
            this.onHttp2StreamFrame(((Http2MultiplexCodec$Http2MultiplexCodecStream)http2StreamFrame.stream()).channel, http2StreamFrame);
        } else if (http2Frame instanceof Http2GoAwayFrame) {
            this.onHttp2GoAwayFrame(channelHandlerContext, (Http2GoAwayFrame)http2Frame);
            channelHandlerContext.fireChannelRead(http2Frame);
        } else if (http2Frame instanceof Http2SettingsFrame) {
            Http2Settings http2Settings = ((Http2SettingsFrame)http2Frame).settings();
            if (http2Settings.initialWindowSize() != null) {
                this.initialOutboundStreamWindow = http2Settings.initialWindowSize();
            }
            channelHandlerContext.fireChannelRead(http2Frame);
        } else {
            channelHandlerContext.fireChannelRead(http2Frame);
        }
    }

    @Override
    final void onHttp2StreamStateChanged(ChannelHandlerContext channelHandlerContext, Http2FrameStream http2FrameStream) {
        Http2MultiplexCodec$Http2MultiplexCodecStream http2MultiplexCodec$Http2MultiplexCodecStream = (Http2MultiplexCodec$Http2MultiplexCodecStream)http2FrameStream;
        switch (http2FrameStream.state()) {
            case HALF_CLOSED_REMOTE: 
            case OPEN: {
                if (http2MultiplexCodec$Http2MultiplexCodecStream.channel != null) break;
                ChannelFuture channelFuture = channelHandlerContext.channel().eventLoop().register(new Http2MultiplexCodec$DefaultHttp2StreamChannel(this, http2MultiplexCodec$Http2MultiplexCodecStream, false));
                if (channelFuture.isDone()) {
                    Http2MultiplexCodec.registerDone(channelFuture);
                    break;
                }
                channelFuture.addListener(CHILD_CHANNEL_REGISTRATION_LISTENER);
                break;
            }
            case CLOSED: {
                Http2MultiplexCodec$DefaultHttp2StreamChannel http2MultiplexCodec$DefaultHttp2StreamChannel = http2MultiplexCodec$Http2MultiplexCodecStream.channel;
                if (http2MultiplexCodec$DefaultHttp2StreamChannel == null) break;
                http2MultiplexCodec$DefaultHttp2StreamChannel.streamClosed();
                break;
            }
        }
    }

    @Override
    final void onHttp2StreamWritabilityChanged(ChannelHandlerContext channelHandlerContext, Http2FrameStream http2FrameStream, boolean bl2) {
        ((Http2MultiplexCodec$Http2MultiplexCodecStream)http2FrameStream).channel.writabilityChanged(bl2);
    }

    final Http2StreamChannel newOutboundStream() {
        return new Http2MultiplexCodec$DefaultHttp2StreamChannel(this, this.newStream(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void onHttp2FrameStreamException(ChannelHandlerContext channelHandlerContext, Http2FrameStreamException http2FrameStreamException) {
        Http2FrameStream http2FrameStream = http2FrameStreamException.stream();
        Http2MultiplexCodec$DefaultHttp2StreamChannel http2MultiplexCodec$DefaultHttp2StreamChannel = ((Http2MultiplexCodec$Http2MultiplexCodecStream)http2FrameStream).channel;
        try {
            http2MultiplexCodec$DefaultHttp2StreamChannel.pipeline().fireExceptionCaught(http2FrameStreamException.getCause());
        }
        finally {
            http2MultiplexCodec$DefaultHttp2StreamChannel.unsafe().closeForcibly();
        }
    }

    private void onHttp2StreamFrame(Http2MultiplexCodec$DefaultHttp2StreamChannel http2MultiplexCodec$DefaultHttp2StreamChannel, Http2StreamFrame http2StreamFrame) {
        switch (http2MultiplexCodec$DefaultHttp2StreamChannel.fireChildRead(http2StreamFrame)) {
            case READ_PROCESSED_BUT_STOP_READING: {
                http2MultiplexCodec$DefaultHttp2StreamChannel.fireChildReadComplete();
                break;
            }
            case READ_PROCESSED_OK_TO_PROCESS_MORE: {
                this.addChildChannelToReadPendingQueue(http2MultiplexCodec$DefaultHttp2StreamChannel);
                break;
            }
            case READ_IGNORED_CHANNEL_INACTIVE: 
            case READ_QUEUED: {
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    final void addChildChannelToReadPendingQueue(Http2MultiplexCodec$DefaultHttp2StreamChannel http2MultiplexCodec$DefaultHttp2StreamChannel) {
        if (!http2MultiplexCodec$DefaultHttp2StreamChannel.fireChannelReadPending) {
            assert (http2MultiplexCodec$DefaultHttp2StreamChannel.next == null);
            if (this.tail == null) {
                assert (this.head == null);
                this.tail = this.head = http2MultiplexCodec$DefaultHttp2StreamChannel;
            } else {
                this.tail.next = http2MultiplexCodec$DefaultHttp2StreamChannel;
                this.tail = http2MultiplexCodec$DefaultHttp2StreamChannel;
            }
            http2MultiplexCodec$DefaultHttp2StreamChannel.fireChannelReadPending = true;
        }
    }

    private void onHttp2GoAwayFrame(ChannelHandlerContext channelHandlerContext, Http2GoAwayFrame http2GoAwayFrame) {
        try {
            this.forEachActiveStream(new Http2MultiplexCodec$2(this, http2GoAwayFrame));
        }
        catch (Http2Exception http2Exception) {
            channelHandlerContext.fireExceptionCaught(http2Exception);
            channelHandlerContext.close();
        }
    }

    @Override
    public final void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        this.parentReadInProgress = false;
        this.onChannelReadComplete(channelHandlerContext);
        this.channelReadComplete0(channelHandlerContext);
    }

    @Override
    public final void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        this.parentReadInProgress = true;
        super.channelRead(channelHandlerContext, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onChannelReadComplete(ChannelHandlerContext channelHandlerContext) {
        try {
            Http2MultiplexCodec$DefaultHttp2StreamChannel http2MultiplexCodec$DefaultHttp2StreamChannel = this.head;
            while (http2MultiplexCodec$DefaultHttp2StreamChannel != null) {
                Http2MultiplexCodec$DefaultHttp2StreamChannel http2MultiplexCodec$DefaultHttp2StreamChannel2 = http2MultiplexCodec$DefaultHttp2StreamChannel;
                if (http2MultiplexCodec$DefaultHttp2StreamChannel2.fireChannelReadPending) {
                    http2MultiplexCodec$DefaultHttp2StreamChannel2.fireChannelReadPending = false;
                    http2MultiplexCodec$DefaultHttp2StreamChannel2.fireChildReadComplete();
                }
                http2MultiplexCodec$DefaultHttp2StreamChannel2.next = null;
                http2MultiplexCodec$DefaultHttp2StreamChannel = http2MultiplexCodec$DefaultHttp2StreamChannel.next;
            }
        }
        finally {
            this.head = null;
            this.tail = null;
            this.flush0(channelHandlerContext);
        }
    }

    void flush0(ChannelHandlerContext channelHandlerContext) {
        this.flush(channelHandlerContext);
    }

    boolean onBytesConsumed(ChannelHandlerContext channelHandlerContext, Http2FrameStream http2FrameStream, int n2) {
        return this.consumeBytes(http2FrameStream.id(), n2);
    }

    private boolean initialWritability(Http2FrameCodec$DefaultHttp2FrameStream http2FrameCodec$DefaultHttp2FrameStream) {
        return !Http2CodecUtil.isStreamIdValid(http2FrameCodec$DefaultHttp2FrameStream.id()) || this.isWritable(http2FrameCodec$DefaultHttp2FrameStream);
    }

    static /* synthetic */ void access$000(ChannelFuture channelFuture) {
        Http2MultiplexCodec.registerDone(channelFuture);
    }

    static /* synthetic */ boolean access$200(Http2MultiplexCodec http2MultiplexCodec, Http2FrameCodec$DefaultHttp2FrameStream defaultHttp2FrameStream) {
        return http2MultiplexCodec.initialWritability(defaultHttp2FrameStream);
    }

    static /* synthetic */ int access$304(Http2MultiplexCodec http2MultiplexCodec) {
        return ++http2MultiplexCodec.idCount;
    }

    static /* synthetic */ ChannelMetadata access$400() {
        return METADATA;
    }

    static /* synthetic */ ChannelHandler access$700(Http2MultiplexCodec http2MultiplexCodec) {
        return http2MultiplexCodec.inboundStreamHandler;
    }

    static /* synthetic */ boolean access$1500(Http2MultiplexCodec http2MultiplexCodec) {
        return http2MultiplexCodec.parentReadInProgress;
    }

    static /* synthetic */ ClosedChannelException access$1700() {
        return CLOSED_CHANNEL_EXCEPTION;
    }

    static /* synthetic */ int access$2400(Http2MultiplexCodec http2MultiplexCodec) {
        return http2MultiplexCodec.initialOutboundStreamWindow;
    }
}

