/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.Channel$Unsafe;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.RecvByteBufAllocator$ExtendedHandle;
import io.netty.handler.codec.http2.Http2Frame;
import io.netty.handler.codec.http2.Http2FrameCodec$DefaultHttp2FrameStream;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2MultiplexCodec;
import io.netty.handler.codec.http2.Http2MultiplexCodec$DefaultHttp2StreamChannel$1;
import io.netty.handler.codec.http2.Http2MultiplexCodec$DefaultHttp2StreamChannel$Http2ChannelUnsafe;
import io.netty.handler.codec.http2.Http2MultiplexCodec$DefaultHttp2StreamChannel$Http2StreamChannelConfig;
import io.netty.handler.codec.http2.Http2MultiplexCodec$Http2MultiplexCodecStream;
import io.netty.handler.codec.http2.Http2MultiplexCodec$ReadState;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelId;
import io.netty.util.DefaultAttributeMap;
import io.netty.util.ReferenceCountUtil;
import java.net.SocketAddress;
import java.util.ArrayDeque;
import java.util.Queue;

final class Http2MultiplexCodec$DefaultHttp2StreamChannel
extends DefaultAttributeMap
implements Http2StreamChannel {
    private final Http2MultiplexCodec$DefaultHttp2StreamChannel$Http2StreamChannelConfig config = new Http2MultiplexCodec$DefaultHttp2StreamChannel$Http2StreamChannelConfig(this, this);
    private final Http2MultiplexCodec$DefaultHttp2StreamChannel$Http2ChannelUnsafe unsafe = new Http2MultiplexCodec$DefaultHttp2StreamChannel$Http2ChannelUnsafe(this, null);
    private final ChannelId channelId;
    private final ChannelPipeline pipeline;
    private final Http2FrameCodec$DefaultHttp2FrameStream stream;
    private final ChannelPromise closePromise;
    private final boolean outbound;
    private volatile boolean registered;
    private volatile boolean writable;
    private boolean outboundClosed;
    private boolean closePending;
    private boolean readInProgress;
    private Queue<Object> inboundBuffer;
    private boolean firstFrameWritten;
    private boolean streamClosedWithoutError;
    private boolean inFireChannelReadComplete;
    boolean fireChannelReadPending;
    Http2MultiplexCodec$DefaultHttp2StreamChannel next;
    static final /* synthetic */ boolean $assertionsDisabled;
    final /* synthetic */ Http2MultiplexCodec this$0;

    Http2MultiplexCodec$DefaultHttp2StreamChannel(Http2MultiplexCodec http2MultiplexCodec, Http2FrameCodec$DefaultHttp2FrameStream http2FrameCodec$DefaultHttp2FrameStream, boolean bl2) {
        this.this$0 = http2MultiplexCodec;
        this.stream = http2FrameCodec$DefaultHttp2FrameStream;
        this.outbound = bl2;
        this.writable = Http2MultiplexCodec.access$200(http2MultiplexCodec, http2FrameCodec$DefaultHttp2FrameStream);
        ((Http2MultiplexCodec$Http2MultiplexCodecStream)http2FrameCodec$DefaultHttp2FrameStream).channel = this;
        this.pipeline = new Http2MultiplexCodec$DefaultHttp2StreamChannel$1(this, this, http2MultiplexCodec);
        this.closePromise = this.pipeline.newPromise();
        this.channelId = new Http2StreamChannelId(this.parent().id(), Http2MultiplexCodec.access$304(http2MultiplexCodec));
    }

    @Override
    public Http2FrameStream stream() {
        return this.stream;
    }

    void streamClosed() {
        this.streamClosedWithoutError = true;
        if (this.readInProgress) {
            this.unsafe().closeForcibly();
        } else {
            this.closePending = true;
        }
    }

    @Override
    public ChannelMetadata metadata() {
        return Http2MultiplexCodec.access$400();
    }

    @Override
    public ChannelConfig config() {
        return this.config;
    }

    @Override
    public boolean isOpen() {
        return !this.closePromise.isDone();
    }

    @Override
    public boolean isActive() {
        return this.isOpen();
    }

    @Override
    public boolean isWritable() {
        return this.writable;
    }

    @Override
    public ChannelId id() {
        return this.channelId;
    }

    @Override
    public EventLoop eventLoop() {
        return this.parent().eventLoop();
    }

    @Override
    public Channel parent() {
        return this.this$0.ctx.channel();
    }

    @Override
    public boolean isRegistered() {
        return this.registered;
    }

    @Override
    public SocketAddress localAddress() {
        return this.parent().localAddress();
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.parent().remoteAddress();
    }

    @Override
    public ChannelFuture closeFuture() {
        return this.closePromise;
    }

    @Override
    public long bytesBeforeUnwritable() {
        return this.config().getWriteBufferHighWaterMark();
    }

    @Override
    public long bytesBeforeWritable() {
        return 0L;
    }

    @Override
    public Channel$Unsafe unsafe() {
        return this.unsafe;
    }

    @Override
    public ChannelPipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.config().getAllocator();
    }

    @Override
    public Channel read() {
        this.pipeline().read();
        return this;
    }

    @Override
    public Channel flush() {
        this.pipeline().flush();
        return this;
    }

    @Override
    public ChannelFuture bind(SocketAddress socketAddress) {
        return this.pipeline().bind(socketAddress);
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress) {
        return this.pipeline().connect(socketAddress);
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        return this.pipeline().connect(socketAddress, socketAddress2);
    }

    @Override
    public ChannelFuture disconnect() {
        return this.pipeline().disconnect();
    }

    @Override
    public ChannelFuture close() {
        return this.pipeline().close();
    }

    @Override
    public ChannelFuture deregister() {
        return this.pipeline().deregister();
    }

    @Override
    public ChannelFuture bind(SocketAddress socketAddress, ChannelPromise channelPromise) {
        return this.pipeline().bind(socketAddress, channelPromise);
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress, ChannelPromise channelPromise) {
        return this.pipeline().connect(socketAddress, channelPromise);
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        return this.pipeline().connect(socketAddress, socketAddress2, channelPromise);
    }

    @Override
    public ChannelFuture disconnect(ChannelPromise channelPromise) {
        return this.pipeline().disconnect(channelPromise);
    }

    @Override
    public ChannelFuture close(ChannelPromise channelPromise) {
        return this.pipeline().close(channelPromise);
    }

    @Override
    public ChannelFuture deregister(ChannelPromise channelPromise) {
        return this.pipeline().deregister(channelPromise);
    }

    @Override
    public ChannelFuture write(Object object) {
        return this.pipeline().write(object);
    }

    @Override
    public ChannelFuture write(Object object, ChannelPromise channelPromise) {
        return this.pipeline().write(object, channelPromise);
    }

    @Override
    public ChannelFuture writeAndFlush(Object object, ChannelPromise channelPromise) {
        return this.pipeline().writeAndFlush(object, channelPromise);
    }

    @Override
    public ChannelFuture writeAndFlush(Object object) {
        return this.pipeline().writeAndFlush(object);
    }

    @Override
    public ChannelPromise newPromise() {
        return this.pipeline().newPromise();
    }

    @Override
    public ChannelProgressivePromise newProgressivePromise() {
        return this.pipeline().newProgressivePromise();
    }

    @Override
    public ChannelFuture newSucceededFuture() {
        return this.pipeline().newSucceededFuture();
    }

    @Override
    public ChannelFuture newFailedFuture(Throwable throwable) {
        return this.pipeline().newFailedFuture(throwable);
    }

    @Override
    public ChannelPromise voidPromise() {
        return this.pipeline().voidPromise();
    }

    public int hashCode() {
        return this.id().hashCode();
    }

    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public int compareTo(Channel channel) {
        if (this == channel) {
            return 0;
        }
        return this.id().compareTo(channel.id());
    }

    public String toString() {
        return this.parent().toString() + "(H2 - " + this.stream + ')';
    }

    void writabilityChanged(boolean bl2) {
        if (!$assertionsDisabled && !this.eventLoop().inEventLoop()) {
            throw new AssertionError();
        }
        if (bl2 != this.writable && this.isActive()) {
            this.writable = bl2;
            this.pipeline().fireChannelWritabilityChanged();
        }
    }

    Http2MultiplexCodec$ReadState fireChildRead(Http2Frame http2Frame) {
        if (!$assertionsDisabled && !this.eventLoop().inEventLoop()) {
            throw new AssertionError();
        }
        if (!this.isActive()) {
            ReferenceCountUtil.release(http2Frame);
            return Http2MultiplexCodec$ReadState.READ_IGNORED_CHANNEL_INACTIVE;
        }
        if (this.readInProgress && (this.inboundBuffer == null || this.inboundBuffer.isEmpty())) {
            RecvByteBufAllocator$ExtendedHandle recvByteBufAllocator$ExtendedHandle = this.unsafe.recvBufAllocHandle();
            this.unsafe.doRead0(http2Frame, recvByteBufAllocator$ExtendedHandle);
            return recvByteBufAllocator$ExtendedHandle.continueReading() ? Http2MultiplexCodec$ReadState.READ_PROCESSED_OK_TO_PROCESS_MORE : Http2MultiplexCodec$ReadState.READ_PROCESSED_BUT_STOP_READING;
        }
        if (this.inboundBuffer == null) {
            this.inboundBuffer = new ArrayDeque<Object>(4);
        }
        this.inboundBuffer.add(http2Frame);
        return Http2MultiplexCodec$ReadState.READ_QUEUED;
    }

    void fireChildReadComplete() {
        if (!$assertionsDisabled && !this.eventLoop().inEventLoop()) {
            throw new AssertionError();
        }
        try {
            if (this.readInProgress) {
                this.inFireChannelReadComplete = true;
                this.readInProgress = false;
                this.unsafe().recvBufAllocHandle().readComplete();
                this.pipeline().fireChannelReadComplete();
            }
        }
        finally {
            this.inFireChannelReadComplete = false;
        }
    }

    static /* synthetic */ boolean access$500(Http2MultiplexCodec$DefaultHttp2StreamChannel http2MultiplexCodec$DefaultHttp2StreamChannel) {
        return http2MultiplexCodec$DefaultHttp2StreamChannel.registered;
    }

    static /* synthetic */ boolean access$502(Http2MultiplexCodec$DefaultHttp2StreamChannel http2MultiplexCodec$DefaultHttp2StreamChannel, boolean bl2) {
        http2MultiplexCodec$DefaultHttp2StreamChannel.registered = bl2;
        return http2MultiplexCodec$DefaultHttp2StreamChannel.registered;
    }

    static /* synthetic */ boolean access$600(Http2MultiplexCodec$DefaultHttp2StreamChannel http2MultiplexCodec$DefaultHttp2StreamChannel) {
        return http2MultiplexCodec$DefaultHttp2StreamChannel.outbound;
    }

    static /* synthetic */ ChannelPromise access$800(Http2MultiplexCodec$DefaultHttp2StreamChannel http2MultiplexCodec$DefaultHttp2StreamChannel) {
        return http2MultiplexCodec$DefaultHttp2StreamChannel.closePromise;
    }

    static /* synthetic */ boolean access$902(Http2MultiplexCodec$DefaultHttp2StreamChannel http2MultiplexCodec$DefaultHttp2StreamChannel, boolean bl2) {
        http2MultiplexCodec$DefaultHttp2StreamChannel.closePending = bl2;
        return http2MultiplexCodec$DefaultHttp2StreamChannel.closePending;
    }

    static /* synthetic */ boolean access$1000(Http2MultiplexCodec$DefaultHttp2StreamChannel http2MultiplexCodec$DefaultHttp2StreamChannel) {
        return http2MultiplexCodec$DefaultHttp2StreamChannel.streamClosedWithoutError;
    }

    static /* synthetic */ Queue access$1100(Http2MultiplexCodec$DefaultHttp2StreamChannel http2MultiplexCodec$DefaultHttp2StreamChannel) {
        return http2MultiplexCodec$DefaultHttp2StreamChannel.inboundBuffer;
    }

    static /* synthetic */ boolean access$1202(Http2MultiplexCodec$DefaultHttp2StreamChannel http2MultiplexCodec$DefaultHttp2StreamChannel, boolean bl2) {
        http2MultiplexCodec$DefaultHttp2StreamChannel.outboundClosed = bl2;
        return http2MultiplexCodec$DefaultHttp2StreamChannel.outboundClosed;
    }

    static /* synthetic */ boolean access$1300(Http2MultiplexCodec$DefaultHttp2StreamChannel http2MultiplexCodec$DefaultHttp2StreamChannel) {
        return http2MultiplexCodec$DefaultHttp2StreamChannel.readInProgress;
    }

    static /* synthetic */ boolean access$1302(Http2MultiplexCodec$DefaultHttp2StreamChannel http2MultiplexCodec$DefaultHttp2StreamChannel, boolean bl2) {
        http2MultiplexCodec$DefaultHttp2StreamChannel.readInProgress = bl2;
        return http2MultiplexCodec$DefaultHttp2StreamChannel.readInProgress;
    }

    static /* synthetic */ boolean access$900(Http2MultiplexCodec$DefaultHttp2StreamChannel http2MultiplexCodec$DefaultHttp2StreamChannel) {
        return http2MultiplexCodec$DefaultHttp2StreamChannel.closePending;
    }

    static /* synthetic */ Http2MultiplexCodec$DefaultHttp2StreamChannel$Http2ChannelUnsafe access$1400(Http2MultiplexCodec$DefaultHttp2StreamChannel http2MultiplexCodec$DefaultHttp2StreamChannel) {
        return http2MultiplexCodec$DefaultHttp2StreamChannel.unsafe;
    }

    static /* synthetic */ Http2FrameCodec$DefaultHttp2FrameStream access$1600(Http2MultiplexCodec$DefaultHttp2StreamChannel http2MultiplexCodec$DefaultHttp2StreamChannel) {
        return http2MultiplexCodec$DefaultHttp2StreamChannel.stream;
    }

    static /* synthetic */ boolean access$1200(Http2MultiplexCodec$DefaultHttp2StreamChannel http2MultiplexCodec$DefaultHttp2StreamChannel) {
        return http2MultiplexCodec$DefaultHttp2StreamChannel.outboundClosed;
    }

    static /* synthetic */ boolean access$1800(Http2MultiplexCodec$DefaultHttp2StreamChannel http2MultiplexCodec$DefaultHttp2StreamChannel) {
        return http2MultiplexCodec$DefaultHttp2StreamChannel.firstFrameWritten;
    }

    static /* synthetic */ boolean access$1802(Http2MultiplexCodec$DefaultHttp2StreamChannel http2MultiplexCodec$DefaultHttp2StreamChannel, boolean bl2) {
        http2MultiplexCodec$DefaultHttp2StreamChannel.firstFrameWritten = bl2;
        return http2MultiplexCodec$DefaultHttp2StreamChannel.firstFrameWritten;
    }

    static /* synthetic */ Http2MultiplexCodec$DefaultHttp2StreamChannel$Http2StreamChannelConfig access$2100(Http2MultiplexCodec$DefaultHttp2StreamChannel http2MultiplexCodec$DefaultHttp2StreamChannel) {
        return http2MultiplexCodec$DefaultHttp2StreamChannel.config;
    }

    static /* synthetic */ boolean access$2200(Http2MultiplexCodec$DefaultHttp2StreamChannel http2MultiplexCodec$DefaultHttp2StreamChannel) {
        return http2MultiplexCodec$DefaultHttp2StreamChannel.inFireChannelReadComplete;
    }

    static {
        $assertionsDisabled = !Http2MultiplexCodec.class.desiredAssertionStatus();
    }
}

