/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.Channel$Unsafe;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.RecvByteBufAllocator$ExtendedHandle;
import io.netty.channel.RecvByteBufAllocator$Handle;
import io.netty.channel.VoidChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2ResetFrame;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Frame;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2MultiplexCodec;
import io.netty.handler.codec.http2.Http2MultiplexCodec$1;
import io.netty.handler.codec.http2.Http2MultiplexCodec$DefaultHttp2StreamChannel;
import io.netty.handler.codec.http2.Http2MultiplexCodec$DefaultHttp2StreamChannel$Http2ChannelUnsafe$1;
import io.netty.handler.codec.http2.Http2MultiplexCodec$DefaultHttp2StreamChannel$Http2ChannelUnsafe$2;
import io.netty.handler.codec.http2.Http2MultiplexCodec$DefaultHttp2StreamChannel$Http2ChannelUnsafe$3;
import io.netty.handler.codec.http2.Http2StreamFrame;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.StringUtil;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;

final class Http2MultiplexCodec$DefaultHttp2StreamChannel$Http2ChannelUnsafe
implements Channel$Unsafe {
    private final VoidChannelPromise unsafeVoidPromise;
    private RecvByteBufAllocator$ExtendedHandle recvHandle;
    private boolean writeDoneAndNoFlush;
    private boolean closeInitiated;
    final /* synthetic */ Http2MultiplexCodec$DefaultHttp2StreamChannel this$1;

    private Http2MultiplexCodec$DefaultHttp2StreamChannel$Http2ChannelUnsafe(Http2MultiplexCodec$DefaultHttp2StreamChannel http2MultiplexCodec$DefaultHttp2StreamChannel) {
        this.this$1 = http2MultiplexCodec$DefaultHttp2StreamChannel;
        this.unsafeVoidPromise = new VoidChannelPromise(this.this$1, false);
    }

    @Override
    public void connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        if (!channelPromise.setUncancellable()) {
            return;
        }
        channelPromise.setFailure(new UnsupportedOperationException());
    }

    @Override
    public RecvByteBufAllocator$ExtendedHandle recvBufAllocHandle() {
        if (this.recvHandle == null) {
            this.recvHandle = (RecvByteBufAllocator$ExtendedHandle)this.this$1.config().getRecvByteBufAllocator().newHandle();
        }
        return this.recvHandle;
    }

    @Override
    public SocketAddress localAddress() {
        return this.this$1.parent().unsafe().localAddress();
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.this$1.parent().unsafe().remoteAddress();
    }

    @Override
    public void register(EventLoop eventLoop, ChannelPromise channelPromise) {
        if (!channelPromise.setUncancellable()) {
            return;
        }
        if (Http2MultiplexCodec$DefaultHttp2StreamChannel.access$500(this.this$1)) {
            throw new UnsupportedOperationException("Re-register is not supported");
        }
        Http2MultiplexCodec$DefaultHttp2StreamChannel.access$502(this.this$1, true);
        if (!Http2MultiplexCodec$DefaultHttp2StreamChannel.access$600(this.this$1)) {
            this.this$1.pipeline().addLast(Http2MultiplexCodec.access$700(this.this$1.this$0));
        }
        channelPromise.setSuccess();
        this.this$1.pipeline().fireChannelRegistered();
        if (this.this$1.isActive()) {
            this.this$1.pipeline().fireChannelActive();
        }
    }

    @Override
    public void bind(SocketAddress socketAddress, ChannelPromise channelPromise) {
        if (!channelPromise.setUncancellable()) {
            return;
        }
        channelPromise.setFailure(new UnsupportedOperationException());
    }

    @Override
    public void disconnect(ChannelPromise channelPromise) {
        this.close(channelPromise);
    }

    @Override
    public void close(ChannelPromise channelPromise) {
        Object object;
        if (!channelPromise.setUncancellable()) {
            return;
        }
        if (this.closeInitiated) {
            if (Http2MultiplexCodec$DefaultHttp2StreamChannel.access$800(this.this$1).isDone()) {
                channelPromise.setSuccess();
            } else if (!(channelPromise instanceof VoidChannelPromise)) {
                Http2MultiplexCodec$DefaultHttp2StreamChannel.access$800(this.this$1).addListener(new Http2MultiplexCodec$DefaultHttp2StreamChannel$Http2ChannelUnsafe$1(this, channelPromise));
            }
            return;
        }
        this.closeInitiated = true;
        Http2MultiplexCodec$DefaultHttp2StreamChannel.access$902(this.this$1, false);
        this.this$1.fireChannelReadPending = false;
        if (this.this$1.parent().isActive() && !Http2MultiplexCodec$DefaultHttp2StreamChannel.access$1000(this.this$1) && Http2CodecUtil.isStreamIdValid(this.this$1.stream().id())) {
            object = new DefaultHttp2ResetFrame(Http2Error.CANCEL).stream(this.this$1.stream());
            this.write(object, this.this$1.unsafe().voidPromise());
            this.flush();
        }
        if (Http2MultiplexCodec$DefaultHttp2StreamChannel.access$1100(this.this$1) != null) {
            while ((object = Http2MultiplexCodec$DefaultHttp2StreamChannel.access$1100(this.this$1).poll()) != null) {
                ReferenceCountUtil.release(object);
            }
        }
        Http2MultiplexCodec$DefaultHttp2StreamChannel.access$1202(this.this$1, true);
        Http2MultiplexCodec$DefaultHttp2StreamChannel.access$800(this.this$1).setSuccess();
        channelPromise.setSuccess();
        this.this$1.pipeline().fireChannelInactive();
        if (this.this$1.isRegistered()) {
            this.deregister(this.this$1.unsafe().voidPromise());
        }
    }

    @Override
    public void closeForcibly() {
        this.close(this.this$1.unsafe().voidPromise());
    }

    @Override
    public void deregister(ChannelPromise channelPromise) {
        if (!channelPromise.setUncancellable()) {
            return;
        }
        if (Http2MultiplexCodec$DefaultHttp2StreamChannel.access$500(this.this$1)) {
            Http2MultiplexCodec$DefaultHttp2StreamChannel.access$502(this.this$1, true);
            channelPromise.setSuccess();
            this.this$1.pipeline().fireChannelUnregistered();
        } else {
            channelPromise.setFailure(new IllegalStateException("Not registered"));
        }
    }

    @Override
    public void beginRead() {
        boolean bl2;
        if (Http2MultiplexCodec$DefaultHttp2StreamChannel.access$1300(this.this$1) || !this.this$1.isActive()) {
            return;
        }
        Http2MultiplexCodec$DefaultHttp2StreamChannel.access$1302(this.this$1, true);
        RecvByteBufAllocator$Handle recvByteBufAllocator$Handle = this.this$1.unsafe().recvBufAllocHandle();
        recvByteBufAllocator$Handle.reset(this.this$1.config());
        if (Http2MultiplexCodec$DefaultHttp2StreamChannel.access$1100(this.this$1) == null || Http2MultiplexCodec$DefaultHttp2StreamChannel.access$1100(this.this$1).isEmpty()) {
            if (Http2MultiplexCodec$DefaultHttp2StreamChannel.access$900(this.this$1)) {
                Http2MultiplexCodec$DefaultHttp2StreamChannel.access$1400(this.this$1).closeForcibly();
            }
            return;
        }
        do {
            Object e2;
            if ((e2 = Http2MultiplexCodec$DefaultHttp2StreamChannel.access$1100(this.this$1).poll()) == null) {
                bl2 = false;
                break;
            }
            this.doRead0((Http2Frame)e2, recvByteBufAllocator$Handle);
        } while (bl2 = recvByteBufAllocator$Handle.continueReading());
        if (bl2 && Http2MultiplexCodec.access$1500(this.this$1.this$0)) {
            this.this$1.this$0.addChildChannelToReadPendingQueue(this.this$1);
        } else {
            Http2MultiplexCodec$DefaultHttp2StreamChannel.access$1302(this.this$1, false);
            recvByteBufAllocator$Handle.readComplete();
            this.this$1.pipeline().fireChannelReadComplete();
            this.flush();
            if (Http2MultiplexCodec$DefaultHttp2StreamChannel.access$900(this.this$1)) {
                Http2MultiplexCodec$DefaultHttp2StreamChannel.access$1400(this.this$1).closeForcibly();
            }
        }
    }

    void doRead0(Http2Frame http2Frame, RecvByteBufAllocator$Handle recvByteBufAllocator$Handle) {
        int n2 = 0;
        if (http2Frame instanceof Http2DataFrame) {
            n2 = ((Http2DataFrame)http2Frame).initialFlowControlledBytes();
            recvByteBufAllocator$Handle.lastBytesRead(n2);
        } else {
            recvByteBufAllocator$Handle.lastBytesRead(9);
        }
        recvByteBufAllocator$Handle.incMessagesRead(1);
        this.this$1.pipeline().fireChannelRead(http2Frame);
        if (n2 != 0) {
            try {
                this.writeDoneAndNoFlush |= this.this$1.this$0.onBytesConsumed(this.this$1.this$0.ctx, Http2MultiplexCodec$DefaultHttp2StreamChannel.access$1600(this.this$1), n2);
            }
            catch (Http2Exception http2Exception) {
                this.this$1.pipeline().fireExceptionCaught(http2Exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Object object, ChannelPromise channelPromise) {
        if (!channelPromise.setUncancellable()) {
            ReferenceCountUtil.release(object);
            return;
        }
        if (!this.this$1.isActive() || Http2MultiplexCodec$DefaultHttp2StreamChannel.access$1200(this.this$1) && (object instanceof Http2HeadersFrame || object instanceof Http2DataFrame)) {
            ReferenceCountUtil.release(object);
            channelPromise.setFailure(Http2MultiplexCodec.access$1700());
            return;
        }
        try {
            Object object2;
            if (object instanceof Http2StreamFrame) {
                object2 = this.validateStreamFrame((Http2StreamFrame)object).stream(this.this$1.stream());
                if (!Http2MultiplexCodec$DefaultHttp2StreamChannel.access$1800(this.this$1) && !Http2CodecUtil.isStreamIdValid(this.this$1.stream().id())) {
                    if (!(object2 instanceof Http2HeadersFrame)) {
                        ReferenceCountUtil.release(object2);
                        channelPromise.setFailure(new IllegalArgumentException("The first frame must be a headers frame. Was: " + object2.name()));
                        return;
                    }
                    Http2MultiplexCodec$DefaultHttp2StreamChannel.access$1802(this.this$1, true);
                    ChannelFuture channelFuture = this.write0(object2);
                    if (channelFuture.isDone()) {
                        this.firstWriteComplete(channelFuture, channelPromise);
                    } else {
                        channelFuture.addListener(new Http2MultiplexCodec$DefaultHttp2StreamChannel$Http2ChannelUnsafe$2(this, channelPromise));
                    }
                    return;
                }
            } else {
                String string = object.toString();
                ReferenceCountUtil.release(object);
                channelPromise.setFailure(new IllegalArgumentException("Message must be an " + StringUtil.simpleClassName(Http2StreamFrame.class) + ": " + string));
                return;
            }
            object2 = this.write0(object);
            if (object2.isDone()) {
                this.writeComplete((ChannelFuture)object2, channelPromise);
            } else {
                object2.addListener(new Http2MultiplexCodec$DefaultHttp2StreamChannel$Http2ChannelUnsafe$3(this, channelPromise));
            }
        }
        catch (Throwable throwable) {
            channelPromise.tryFailure(throwable);
        }
        finally {
            this.writeDoneAndNoFlush = true;
        }
    }

    private void firstWriteComplete(ChannelFuture channelFuture, ChannelPromise channelPromise) {
        Throwable throwable = channelFuture.cause();
        if (throwable == null) {
            this.this$1.writabilityChanged(this.this$1.this$0.isWritable(Http2MultiplexCodec$DefaultHttp2StreamChannel.access$1600(this.this$1)));
            channelPromise.setSuccess();
        } else {
            channelPromise.setFailure(this.wrapStreamClosedError(throwable));
            this.closeForcibly();
        }
    }

    private void writeComplete(ChannelFuture channelFuture, ChannelPromise channelPromise) {
        Throwable throwable = channelFuture.cause();
        if (throwable == null) {
            channelPromise.setSuccess();
        } else {
            Throwable throwable2 = this.wrapStreamClosedError(throwable);
            channelPromise.setFailure(throwable2);
            if (throwable2 instanceof ClosedChannelException) {
                if (Http2MultiplexCodec$DefaultHttp2StreamChannel.access$2100(this.this$1).isAutoClose()) {
                    this.closeForcibly();
                } else {
                    Http2MultiplexCodec$DefaultHttp2StreamChannel.access$1202(this.this$1, true);
                }
            }
        }
    }

    private Throwable wrapStreamClosedError(Throwable throwable) {
        if (throwable instanceof Http2Exception && ((Http2Exception)throwable).error() == Http2Error.STREAM_CLOSED) {
            return new ClosedChannelException().initCause(throwable);
        }
        return throwable;
    }

    private Http2StreamFrame validateStreamFrame(Http2StreamFrame http2StreamFrame) {
        if (http2StreamFrame.stream() != null && http2StreamFrame.stream() != Http2MultiplexCodec$DefaultHttp2StreamChannel.access$1600(this.this$1)) {
            String string = http2StreamFrame.toString();
            ReferenceCountUtil.release(http2StreamFrame);
            throw new IllegalArgumentException("Stream " + http2StreamFrame.stream() + " must not be set on the frame: " + string);
        }
        return http2StreamFrame;
    }

    private ChannelFuture write0(Object object) {
        ChannelPromise channelPromise = this.this$1.this$0.ctx.newPromise();
        this.this$1.this$0.write(this.this$1.this$0.ctx, object, channelPromise);
        return channelPromise;
    }

    @Override
    public void flush() {
        if (!this.writeDoneAndNoFlush) {
            return;
        }
        try {
            if (!Http2MultiplexCodec$DefaultHttp2StreamChannel.access$2200(this.this$1)) {
                this.this$1.this$0.flush0(this.this$1.this$0.ctx);
            }
        }
        finally {
            this.writeDoneAndNoFlush = false;
        }
    }

    @Override
    public ChannelPromise voidPromise() {
        return this.unsafeVoidPromise;
    }

    @Override
    public ChannelOutboundBuffer outboundBuffer() {
        return null;
    }

    /* synthetic */ Http2MultiplexCodec$DefaultHttp2StreamChannel$Http2ChannelUnsafe(Http2MultiplexCodec$DefaultHttp2StreamChannel http2MultiplexCodec$DefaultHttp2StreamChannel, Http2MultiplexCodec$1 http2MultiplexCodec$1) {
        this(http2MultiplexCodec$DefaultHttp2StreamChannel);
    }

    static /* synthetic */ void access$1900(Http2MultiplexCodec$DefaultHttp2StreamChannel$Http2ChannelUnsafe http2MultiplexCodec$DefaultHttp2StreamChannel$Http2ChannelUnsafe, ChannelFuture channelFuture, ChannelPromise channelPromise) {
        http2MultiplexCodec$DefaultHttp2StreamChannel$Http2ChannelUnsafe.firstWriteComplete(channelFuture, channelPromise);
    }

    static /* synthetic */ void access$2000(Http2MultiplexCodec$DefaultHttp2StreamChannel$Http2ChannelUnsafe http2MultiplexCodec$DefaultHttp2StreamChannel$Http2ChannelUnsafe, ChannelFuture channelFuture, ChannelPromise channelPromise) {
        http2MultiplexCodec$DefaultHttp2StreamChannel$Http2ChannelUnsafe.writeComplete(channelFuture, channelPromise);
    }
}

