/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.CharSequenceMap;
import io.netty.util.AsciiString;

public enum Http2Headers$PseudoHeaderName {
    METHOD(":method", true),
    SCHEME(":scheme", true),
    AUTHORITY(":authority", true),
    PATH(":path", true),
    STATUS(":status", false);

    private static final char PSEUDO_HEADER_PREFIX = ':';
    private static final byte PSEUDO_HEADER_PREFIX_BYTE = 58;
    private final AsciiString value;
    private final boolean requestOnly;
    private static final CharSequenceMap<Http2Headers$PseudoHeaderName> PSEUDO_HEADERS;

    private Http2Headers$PseudoHeaderName(String string2, boolean bl2) {
        this.value = AsciiString.cached(string2);
        this.requestOnly = bl2;
    }

    public AsciiString value() {
        return this.value;
    }

    public static boolean hasPseudoHeaderFormat(CharSequence charSequence) {
        if (charSequence instanceof AsciiString) {
            AsciiString asciiString = (AsciiString)charSequence;
            return asciiString.length() > 0 && asciiString.byteAt(0) == 58;
        }
        return charSequence.length() > 0 && charSequence.charAt(0) == ':';
    }

    public static boolean isPseudoHeader(CharSequence charSequence) {
        return PSEUDO_HEADERS.contains(charSequence);
    }

    public static Http2Headers$PseudoHeaderName getPseudoHeader(CharSequence charSequence) {
        return (Http2Headers$PseudoHeaderName)((Object)PSEUDO_HEADERS.get(charSequence));
    }

    public boolean isRequestOnly() {
        return this.requestOnly;
    }

    static {
        PSEUDO_HEADERS = new CharSequenceMap();
        for (Http2Headers$PseudoHeaderName http2Headers$PseudoHeaderName : Http2Headers$PseudoHeaderName.values()) {
            PSEUDO_HEADERS.add(http2Headers$PseudoHeaderName.value(), http2Headers$PseudoHeaderName);
        }
    }
}

