/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameLogger$Direction;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.logging.LogLevel;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public class Http2FrameLogger
extends ChannelHandlerAdapter {
    private static final int BUFFER_LENGTH_THRESHOLD = 64;
    private final InternalLogger logger;
    private final InternalLogLevel level;

    public Http2FrameLogger(LogLevel logLevel) {
        this(logLevel.toInternalLevel(), InternalLoggerFactory.getInstance(Http2FrameLogger.class));
    }

    public Http2FrameLogger(LogLevel logLevel, String string) {
        this(logLevel.toInternalLevel(), InternalLoggerFactory.getInstance(string));
    }

    public Http2FrameLogger(LogLevel logLevel, Class<?> clazz) {
        this(logLevel.toInternalLevel(), InternalLoggerFactory.getInstance(clazz));
    }

    private Http2FrameLogger(InternalLogLevel internalLogLevel, InternalLogger internalLogger) {
        this.level = ObjectUtil.checkNotNull(internalLogLevel, "level");
        this.logger = ObjectUtil.checkNotNull(internalLogger, "logger");
    }

    public void logData(Http2FrameLogger$Direction http2FrameLogger$Direction, ChannelHandlerContext channelHandlerContext, int n2, ByteBuf byteBuf, int n3, boolean bl2) {
        this.logger.log(this.level, "{} {} DATA: streamId={} padding={} endStream={} length={} bytes={}", channelHandlerContext.channel(), http2FrameLogger$Direction.name(), n2, n3, bl2, byteBuf.readableBytes(), this.toString(byteBuf));
    }

    public void logHeaders(Http2FrameLogger$Direction http2FrameLogger$Direction, ChannelHandlerContext channelHandlerContext, int n2, Http2Headers http2Headers, int n3, boolean bl2) {
        this.logger.log(this.level, "{} {} HEADERS: streamId={} headers={} padding={} endStream={}", channelHandlerContext.channel(), http2FrameLogger$Direction.name(), n2, http2Headers, n3, bl2);
    }

    public void logHeaders(Http2FrameLogger$Direction http2FrameLogger$Direction, ChannelHandlerContext channelHandlerContext, int n2, Http2Headers http2Headers, int n3, short s2, boolean bl2, int n4, boolean bl3) {
        this.logger.log(this.level, "{} {} HEADERS: streamId={} headers={} streamDependency={} weight={} exclusive={} padding={} endStream={}", channelHandlerContext.channel(), http2FrameLogger$Direction.name(), n2, http2Headers, n3, s2, bl2, n4, bl3);
    }

    public void logPriority(Http2FrameLogger$Direction http2FrameLogger$Direction, ChannelHandlerContext channelHandlerContext, int n2, int n3, short s2, boolean bl2) {
        this.logger.log(this.level, "{} {} PRIORITY: streamId={} streamDependency={} weight={} exclusive={}", channelHandlerContext.channel(), http2FrameLogger$Direction.name(), n2, n3, s2, bl2);
    }

    public void logRstStream(Http2FrameLogger$Direction http2FrameLogger$Direction, ChannelHandlerContext channelHandlerContext, int n2, long l2) {
        this.logger.log(this.level, "{} {} RST_STREAM: streamId={} errorCode={}", channelHandlerContext.channel(), http2FrameLogger$Direction.name(), n2, l2);
    }

    public void logSettingsAck(Http2FrameLogger$Direction http2FrameLogger$Direction, ChannelHandlerContext channelHandlerContext) {
        this.logger.log(this.level, "{} {} SETTINGS: ack=true", (Object)channelHandlerContext.channel(), (Object)http2FrameLogger$Direction.name());
    }

    public void logSettings(Http2FrameLogger$Direction http2FrameLogger$Direction, ChannelHandlerContext channelHandlerContext, Http2Settings http2Settings) {
        this.logger.log(this.level, "{} {} SETTINGS: ack=false settings={}", channelHandlerContext.channel(), http2FrameLogger$Direction.name(), http2Settings);
    }

    public void logPing(Http2FrameLogger$Direction http2FrameLogger$Direction, ChannelHandlerContext channelHandlerContext, long l2) {
        this.logger.log(this.level, "{} {} PING: ack=false bytes={}", channelHandlerContext.channel(), http2FrameLogger$Direction.name(), l2);
    }

    public void logPingAck(Http2FrameLogger$Direction http2FrameLogger$Direction, ChannelHandlerContext channelHandlerContext, long l2) {
        this.logger.log(this.level, "{} {} PING: ack=true bytes={}", channelHandlerContext.channel(), http2FrameLogger$Direction.name(), l2);
    }

    public void logPushPromise(Http2FrameLogger$Direction http2FrameLogger$Direction, ChannelHandlerContext channelHandlerContext, int n2, int n3, Http2Headers http2Headers, int n4) {
        this.logger.log(this.level, "{} {} PUSH_PROMISE: streamId={} promisedStreamId={} headers={} padding={}", channelHandlerContext.channel(), http2FrameLogger$Direction.name(), n2, n3, http2Headers, n4);
    }

    public void logGoAway(Http2FrameLogger$Direction http2FrameLogger$Direction, ChannelHandlerContext channelHandlerContext, int n2, long l2, ByteBuf byteBuf) {
        this.logger.log(this.level, "{} {} GO_AWAY: lastStreamId={} errorCode={} length={} bytes={}", channelHandlerContext.channel(), http2FrameLogger$Direction.name(), n2, l2, byteBuf.readableBytes(), this.toString(byteBuf));
    }

    public void logWindowsUpdate(Http2FrameLogger$Direction http2FrameLogger$Direction, ChannelHandlerContext channelHandlerContext, int n2, int n3) {
        this.logger.log(this.level, "{} {} WINDOW_UPDATE: streamId={} windowSizeIncrement={}", channelHandlerContext.channel(), http2FrameLogger$Direction.name(), n2, n3);
    }

    public void logUnknownFrame(Http2FrameLogger$Direction http2FrameLogger$Direction, ChannelHandlerContext channelHandlerContext, byte by2, int n2, Http2Flags http2Flags, ByteBuf byteBuf) {
        this.logger.log(this.level, "{} {} UNKNOWN: frameType={} streamId={} flags={} length={} bytes={}", channelHandlerContext.channel(), http2FrameLogger$Direction.name(), by2 & 0xFF, n2, http2Flags.value(), byteBuf.readableBytes(), this.toString(byteBuf));
    }

    private String toString(ByteBuf byteBuf) {
        if (!this.logger.isEnabled(this.level)) {
            return "";
        }
        if (this.level == InternalLogLevel.TRACE || byteBuf.readableBytes() <= 64) {
            return ByteBufUtil.hexDump(byteBuf);
        }
        int n2 = Math.min(byteBuf.readableBytes(), 64);
        return ByteBufUtil.hexDump(byteBuf, byteBuf.readerIndex(), n2) + "...";
    }
}

