/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.UnsupportedMessageTypeException;
import io.netty.handler.codec.http.HttpServerUpgradeHandler$UpgradeEvent;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Connection$PropertyKey;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2ConnectionPrefaceAndSettingsFrameWrittenEvent;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Exception$StreamException;
import io.netty.handler.codec.http2.Http2Frame;
import io.netty.handler.codec.http2.Http2FrameCodec$1;
import io.netty.handler.codec.http2.Http2FrameCodec$2;
import io.netty.handler.codec.http2.Http2FrameCodec$ConnectionListener;
import io.netty.handler.codec.http2.Http2FrameCodec$DefaultHttp2FrameStream;
import io.netty.handler.codec.http2.Http2FrameCodec$FrameListener;
import io.netty.handler.codec.http2.Http2FrameCodec$Http2RemoteFlowControllerListener;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2FrameStreamEvent;
import io.netty.handler.codec.http2.Http2FrameStreamException;
import io.netty.handler.codec.http2.Http2FrameStreamVisitor;
import io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2NoMoreStreamIdsException;
import io.netty.handler.codec.http2.Http2PingFrame;
import io.netty.handler.codec.http2.Http2ResetFrame;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2SettingsFrame;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2UnknownFrame;
import io.netty.handler.codec.http2.Http2WindowUpdateFrame;
import io.netty.handler.codec.http2.HttpConversionUtil$ExtensionHeaderNames;
import io.netty.handler.codec.http2.InboundHttpToHttp2Adapter;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public class Http2FrameCodec
extends Http2ConnectionHandler {
    private static final InternalLogger LOG = InternalLoggerFactory.getInstance(Http2FrameCodec.class);
    private final Http2Connection$PropertyKey streamKey;
    private final Http2Connection$PropertyKey upgradeKey;
    private final Integer initialFlowControlWindowSize;
    private ChannelHandlerContext ctx;
    private int numBufferedStreams;
    private Http2FrameCodec$DefaultHttp2FrameStream frameStreamToInitialize;

    Http2FrameCodec(Http2ConnectionEncoder http2ConnectionEncoder, Http2ConnectionDecoder http2ConnectionDecoder, Http2Settings http2Settings) {
        super(http2ConnectionDecoder, http2ConnectionEncoder, http2Settings);
        http2ConnectionDecoder.frameListener(new Http2FrameCodec$FrameListener(this));
        this.connection().addListener(new Http2FrameCodec$ConnectionListener(this));
        this.connection().remote().flowController().listener(new Http2FrameCodec$Http2RemoteFlowControllerListener(this));
        this.streamKey = this.connection().newKey();
        this.upgradeKey = this.connection().newKey();
        this.initialFlowControlWindowSize = http2Settings.initialWindowSize();
    }

    Http2FrameCodec$DefaultHttp2FrameStream newStream() {
        return new Http2FrameCodec$DefaultHttp2FrameStream();
    }

    final void forEachActiveStream(Http2FrameStreamVisitor http2FrameStreamVisitor) {
        assert (this.ctx.executor().inEventLoop());
        this.connection().forEachActiveStream(new Http2FrameCodec$1(this, http2FrameStreamVisitor));
    }

    @Override
    public final void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
        super.handlerAdded(channelHandlerContext);
        this.handlerAdded0(channelHandlerContext);
        Http2Connection http2Connection = this.connection();
        if (http2Connection.isServer()) {
            this.tryExpandConnectionFlowControlWindow(http2Connection);
        }
    }

    private void tryExpandConnectionFlowControlWindow(Http2Connection http2Connection) {
        if (this.initialFlowControlWindowSize != null) {
            Http2Stream http2Stream = http2Connection.connectionStream();
            Http2LocalFlowController http2LocalFlowController = http2Connection.local().flowController();
            int n2 = this.initialFlowControlWindowSize - http2LocalFlowController.initialWindowSize(http2Stream);
            if (n2 > 0) {
                http2LocalFlowController.incrementWindowSize(http2Stream, Math.max(n2 << 1, n2));
                this.flush(this.ctx);
            }
        }
    }

    void handlerAdded0(ChannelHandlerContext channelHandlerContext) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object == Http2ConnectionPrefaceAndSettingsFrameWrittenEvent.INSTANCE) {
            this.tryExpandConnectionFlowControlWindow(this.connection());
        } else if (object instanceof HttpServerUpgradeHandler$UpgradeEvent) {
            HttpServerUpgradeHandler$UpgradeEvent httpServerUpgradeHandler$UpgradeEvent = (HttpServerUpgradeHandler$UpgradeEvent)object;
            try {
                this.onUpgradeEvent(channelHandlerContext, httpServerUpgradeHandler$UpgradeEvent.retain());
                Http2Stream http2Stream = this.connection().stream(1);
                if (http2Stream.getProperty(this.streamKey) == null) {
                    this.onStreamActive0(http2Stream);
                }
                httpServerUpgradeHandler$UpgradeEvent.upgradeRequest().headers().setInt(HttpConversionUtil$ExtensionHeaderNames.STREAM_ID.text(), 1);
                http2Stream.setProperty(this.upgradeKey, true);
                InboundHttpToHttp2Adapter.handle(channelHandlerContext, this.connection(), this.decoder().frameListener(), httpServerUpgradeHandler$UpgradeEvent.upgradeRequest().retain());
            }
            finally {
                httpServerUpgradeHandler$UpgradeEvent.release();
            }
            return;
        }
        super.userEventTriggered(channelHandlerContext, object);
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (object instanceof Http2DataFrame) {
            Http2DataFrame http2DataFrame = (Http2DataFrame)object;
            this.encoder().writeData(channelHandlerContext, http2DataFrame.stream().id(), http2DataFrame.content(), http2DataFrame.padding(), http2DataFrame.isEndStream(), channelPromise);
        } else if (object instanceof Http2HeadersFrame) {
            this.writeHeadersFrame(channelHandlerContext, (Http2HeadersFrame)object, channelPromise);
        } else if (object instanceof Http2WindowUpdateFrame) {
            Http2WindowUpdateFrame http2WindowUpdateFrame = (Http2WindowUpdateFrame)object;
            Http2FrameStream http2FrameStream = http2WindowUpdateFrame.stream();
            try {
                if (http2FrameStream == null) {
                    this.increaseInitialConnectionWindow(http2WindowUpdateFrame.windowSizeIncrement());
                } else {
                    this.consumeBytes(http2FrameStream.id(), http2WindowUpdateFrame.windowSizeIncrement());
                }
                channelPromise.setSuccess();
            }
            catch (Throwable throwable) {
                channelPromise.setFailure(throwable);
            }
        } else if (object instanceof Http2ResetFrame) {
            Http2ResetFrame http2ResetFrame = (Http2ResetFrame)object;
            this.encoder().writeRstStream(channelHandlerContext, http2ResetFrame.stream().id(), http2ResetFrame.errorCode(), channelPromise);
        } else if (object instanceof Http2PingFrame) {
            Http2PingFrame http2PingFrame = (Http2PingFrame)object;
            this.encoder().writePing(channelHandlerContext, http2PingFrame.ack(), http2PingFrame.content(), channelPromise);
        } else if (object instanceof Http2SettingsFrame) {
            this.encoder().writeSettings(channelHandlerContext, ((Http2SettingsFrame)object).settings(), channelPromise);
        } else if (object instanceof Http2GoAwayFrame) {
            this.writeGoAwayFrame(channelHandlerContext, (Http2GoAwayFrame)object, channelPromise);
        } else if (object instanceof Http2UnknownFrame) {
            Http2UnknownFrame http2UnknownFrame = (Http2UnknownFrame)object;
            this.encoder().writeFrame(channelHandlerContext, http2UnknownFrame.frameType(), http2UnknownFrame.stream().id(), http2UnknownFrame.flags(), http2UnknownFrame.content(), channelPromise);
        } else if (!(object instanceof Http2Frame)) {
            channelHandlerContext.write(object, channelPromise);
        } else {
            ReferenceCountUtil.release(object);
            throw new UnsupportedMessageTypeException(object, new Class[0]);
        }
    }

    private void increaseInitialConnectionWindow(int n2) {
        this.connection().local().flowController().incrementWindowSize(this.connection().connectionStream(), n2);
    }

    final boolean consumeBytes(int n2, int n3) {
        Boolean bl2;
        Http2Stream http2Stream = this.connection().stream(n2);
        if (http2Stream != null && n2 == 1 && Boolean.TRUE.equals(bl2 = (Boolean)http2Stream.getProperty(this.upgradeKey))) {
            return false;
        }
        return this.connection().local().flowController().consumeBytes(http2Stream, n3);
    }

    private void writeGoAwayFrame(ChannelHandlerContext channelHandlerContext, Http2GoAwayFrame http2GoAwayFrame, ChannelPromise channelPromise) {
        if (http2GoAwayFrame.lastStreamId() > -1) {
            http2GoAwayFrame.release();
            throw new IllegalArgumentException("Last stream id must not be set on GOAWAY frame");
        }
        int n2 = this.connection().remote().lastStreamCreated();
        long l2 = (long)n2 + (long)http2GoAwayFrame.extraStreamIds() * 2L;
        if (l2 > Integer.MAX_VALUE) {
            l2 = Integer.MAX_VALUE;
        }
        this.goAway(channelHandlerContext, (int)l2, http2GoAwayFrame.errorCode(), http2GoAwayFrame.content(), channelPromise);
    }

    private void writeHeadersFrame(ChannelHandlerContext channelHandlerContext, Http2HeadersFrame http2HeadersFrame, ChannelPromise channelPromise) {
        if (Http2CodecUtil.isStreamIdValid(http2HeadersFrame.stream().id())) {
            this.encoder().writeHeaders(channelHandlerContext, http2HeadersFrame.stream().id(), http2HeadersFrame.headers(), http2HeadersFrame.padding(), http2HeadersFrame.isEndStream(), channelPromise);
        } else {
            Http2FrameCodec$DefaultHttp2FrameStream http2FrameCodec$DefaultHttp2FrameStream = (Http2FrameCodec$DefaultHttp2FrameStream)http2HeadersFrame.stream();
            Http2Connection http2Connection = this.connection();
            int n2 = http2Connection.local().incrementAndGetNextStreamId();
            if (n2 < 0) {
                channelPromise.setFailure(new Http2NoMoreStreamIdsException());
                return;
            }
            Http2FrameCodec$DefaultHttp2FrameStream.access$502(http2FrameCodec$DefaultHttp2FrameStream, n2);
            assert (this.frameStreamToInitialize == null);
            this.frameStreamToInitialize = http2FrameCodec$DefaultHttp2FrameStream;
            ChannelPromise channelPromise2 = channelHandlerContext.newPromise();
            this.encoder().writeHeaders(channelHandlerContext, n2, http2HeadersFrame.headers(), http2HeadersFrame.padding(), http2HeadersFrame.isEndStream(), channelPromise2);
            if (channelPromise2.isDone()) {
                Http2FrameCodec.notifyHeaderWritePromise(channelPromise2, channelPromise);
            } else {
                ++this.numBufferedStreams;
                channelPromise2.addListener(new Http2FrameCodec$2(this, channelPromise));
            }
        }
    }

    private static void notifyHeaderWritePromise(ChannelFuture channelFuture, ChannelPromise channelPromise) {
        Throwable throwable = channelFuture.cause();
        if (throwable == null) {
            channelPromise.setSuccess();
        } else {
            channelPromise.setFailure(throwable);
        }
    }

    private void onStreamActive0(Http2Stream http2Stream) {
        if (this.connection().local().isValidStreamId(http2Stream.id())) {
            return;
        }
        Http2FrameCodec$DefaultHttp2FrameStream http2FrameCodec$DefaultHttp2FrameStream = this.newStream().setStreamAndProperty(this.streamKey, http2Stream);
        this.onHttp2StreamStateChanged(this.ctx, http2FrameCodec$DefaultHttp2FrameStream);
    }

    @Override
    protected void onConnectionError(ChannelHandlerContext channelHandlerContext, boolean bl2, Throwable throwable, Http2Exception http2Exception) {
        if (!bl2) {
            channelHandlerContext.fireExceptionCaught(throwable);
        }
        super.onConnectionError(channelHandlerContext, bl2, throwable, http2Exception);
    }

    @Override
    protected final void onStreamError(ChannelHandlerContext channelHandlerContext, boolean bl2, Throwable throwable, Http2Exception$StreamException http2Exception$StreamException) {
        int n2 = http2Exception$StreamException.streamId();
        Http2Stream http2Stream = this.connection().stream(n2);
        if (http2Stream == null) {
            this.onHttp2UnknownStreamError(channelHandlerContext, throwable, http2Exception$StreamException);
            super.onStreamError(channelHandlerContext, bl2, throwable, http2Exception$StreamException);
            return;
        }
        Http2FrameStream http2FrameStream = (Http2FrameStream)http2Stream.getProperty(this.streamKey);
        if (http2FrameStream == null) {
            LOG.warn("Stream exception thrown without stream object attached.", throwable);
            super.onStreamError(channelHandlerContext, bl2, throwable, http2Exception$StreamException);
            return;
        }
        if (!bl2) {
            this.onHttp2FrameStreamException(channelHandlerContext, new Http2FrameStreamException(http2FrameStream, http2Exception$StreamException.error(), throwable));
        }
    }

    void onHttp2UnknownStreamError(ChannelHandlerContext channelHandlerContext, Throwable throwable, Http2Exception$StreamException http2Exception$StreamException) {
        LOG.warn("Stream exception thrown for unkown stream {}.", (Object)http2Exception$StreamException.streamId(), (Object)throwable);
    }

    @Override
    protected final boolean isGracefulShutdownComplete() {
        return super.isGracefulShutdownComplete() && this.numBufferedStreams == 0;
    }

    void onUpgradeEvent(ChannelHandlerContext channelHandlerContext, HttpServerUpgradeHandler$UpgradeEvent httpServerUpgradeHandler$UpgradeEvent) {
        channelHandlerContext.fireUserEventTriggered(httpServerUpgradeHandler$UpgradeEvent);
    }

    void onHttp2StreamWritabilityChanged(ChannelHandlerContext channelHandlerContext, Http2FrameStream http2FrameStream, boolean bl2) {
        channelHandlerContext.fireUserEventTriggered(Http2FrameStreamEvent.writabilityChanged(http2FrameStream));
    }

    void onHttp2StreamStateChanged(ChannelHandlerContext channelHandlerContext, Http2FrameStream http2FrameStream) {
        channelHandlerContext.fireUserEventTriggered(Http2FrameStreamEvent.stateChanged(http2FrameStream));
    }

    void onHttp2Frame(ChannelHandlerContext channelHandlerContext, Http2Frame http2Frame) {
        channelHandlerContext.fireChannelRead(http2Frame);
    }

    void onHttp2FrameStreamException(ChannelHandlerContext channelHandlerContext, Http2FrameStreamException http2FrameStreamException) {
        channelHandlerContext.fireExceptionCaught(http2FrameStreamException);
    }

    final boolean isWritable(Http2FrameCodec$DefaultHttp2FrameStream http2FrameCodec$DefaultHttp2FrameStream) {
        Http2Stream http2Stream = http2FrameCodec$DefaultHttp2FrameStream.stream;
        return http2Stream != null && this.connection().remote().flowController().isWritable(http2Stream);
    }

    static /* synthetic */ Http2Connection$PropertyKey access$300(Http2FrameCodec http2FrameCodec) {
        return http2FrameCodec.streamKey;
    }

    static /* synthetic */ ChannelHandlerContext access$400(Http2FrameCodec http2FrameCodec) {
        return http2FrameCodec.ctx;
    }

    static /* synthetic */ int access$610(Http2FrameCodec http2FrameCodec) {
        return http2FrameCodec.numBufferedStreams--;
    }

    static /* synthetic */ void access$700(ChannelFuture channelFuture, ChannelPromise channelPromise) {
        Http2FrameCodec.notifyHeaderWritePromise(channelFuture, channelPromise);
    }

    static /* synthetic */ Http2FrameCodec$DefaultHttp2FrameStream access$800(Http2FrameCodec http2FrameCodec) {
        return http2FrameCodec.frameStreamToInitialize;
    }

    static /* synthetic */ Http2FrameCodec$DefaultHttp2FrameStream access$802(Http2FrameCodec http2FrameCodec, Http2FrameCodec$DefaultHttp2FrameStream http2FrameCodec$DefaultHttp2FrameStream) {
        http2FrameCodec.frameStreamToInitialize = http2FrameCodec$DefaultHttp2FrameStream;
        return http2FrameCodec.frameStreamToInitialize;
    }

    static /* synthetic */ void access$900(Http2FrameCodec http2FrameCodec, Http2Stream http2Stream) {
        http2FrameCodec.onStreamActive0(http2Stream);
    }
}

