/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

public final class Http2Flags {
    public static final short END_STREAM = 1;
    public static final short END_HEADERS = 4;
    public static final short ACK = 1;
    public static final short PADDED = 8;
    public static final short PRIORITY = 32;
    private short value;

    public Http2Flags() {
    }

    public Http2Flags(short s2) {
        this.value = s2;
    }

    public short value() {
        return this.value;
    }

    public boolean endOfStream() {
        return this.isFlagSet((short)1);
    }

    public boolean endOfHeaders() {
        return this.isFlagSet((short)4);
    }

    public boolean priorityPresent() {
        return this.isFlagSet((short)32);
    }

    public boolean ack() {
        return this.isFlagSet((short)1);
    }

    public boolean paddingPresent() {
        return this.isFlagSet((short)8);
    }

    public int getNumPriorityBytes() {
        return this.priorityPresent() ? 5 : 0;
    }

    public int getPaddingPresenceFieldLength() {
        return this.paddingPresent() ? 1 : 0;
    }

    public Http2Flags endOfStream(boolean bl2) {
        return this.setFlag(bl2, (short)1);
    }

    public Http2Flags endOfHeaders(boolean bl2) {
        return this.setFlag(bl2, (short)4);
    }

    public Http2Flags priorityPresent(boolean bl2) {
        return this.setFlag(bl2, (short)32);
    }

    public Http2Flags paddingPresent(boolean bl2) {
        return this.setFlag(bl2, (short)8);
    }

    public Http2Flags ack(boolean bl2) {
        return this.setFlag(bl2, (short)1);
    }

    public Http2Flags setFlag(boolean bl2, short s2) {
        this.value = bl2 ? (short)(this.value | s2) : (short)(this.value & ~s2);
        return this;
    }

    public boolean isFlagSet(short s2) {
        return (this.value & s2) != 0;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + this.value;
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.value == ((Http2Flags)object).value;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("value = ").append(this.value).append(" (");
        if (this.ack()) {
            stringBuilder.append("ACK,");
        }
        if (this.endOfHeaders()) {
            stringBuilder.append("END_OF_HEADERS,");
        }
        if (this.endOfStream()) {
            stringBuilder.append("END_OF_STREAM,");
        }
        if (this.priorityPresent()) {
            stringBuilder.append("PRIORITY_PRESENT,");
        }
        if (this.paddingPresent()) {
            stringBuilder.append("PADDING_PRESENT,");
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }
}

