/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception$ClosedStreamCreationException;
import io.netty.handler.codec.http2.Http2Exception$HeaderListSizeException;
import io.netty.handler.codec.http2.Http2Exception$ShutdownHint;
import io.netty.handler.codec.http2.Http2Exception$StreamException;
import io.netty.util.internal.ObjectUtil;

public class Http2Exception
extends Exception {
    private static final long serialVersionUID = -6941186345430164209L;
    private final Http2Error error;
    private final Http2Exception$ShutdownHint shutdownHint;

    public Http2Exception(Http2Error http2Error) {
        this(http2Error, Http2Exception$ShutdownHint.HARD_SHUTDOWN);
    }

    public Http2Exception(Http2Error http2Error, Http2Exception$ShutdownHint http2Exception$ShutdownHint) {
        this.error = ObjectUtil.checkNotNull(http2Error, "error");
        this.shutdownHint = ObjectUtil.checkNotNull(http2Exception$ShutdownHint, "shutdownHint");
    }

    public Http2Exception(Http2Error http2Error, String string) {
        this(http2Error, string, Http2Exception$ShutdownHint.HARD_SHUTDOWN);
    }

    public Http2Exception(Http2Error http2Error, String string, Http2Exception$ShutdownHint http2Exception$ShutdownHint) {
        super(string);
        this.error = ObjectUtil.checkNotNull(http2Error, "error");
        this.shutdownHint = ObjectUtil.checkNotNull(http2Exception$ShutdownHint, "shutdownHint");
    }

    public Http2Exception(Http2Error http2Error, String string, Throwable throwable) {
        this(http2Error, string, throwable, Http2Exception$ShutdownHint.HARD_SHUTDOWN);
    }

    public Http2Exception(Http2Error http2Error, String string, Throwable throwable, Http2Exception$ShutdownHint http2Exception$ShutdownHint) {
        super(string, throwable);
        this.error = ObjectUtil.checkNotNull(http2Error, "error");
        this.shutdownHint = ObjectUtil.checkNotNull(http2Exception$ShutdownHint, "shutdownHint");
    }

    public Http2Error error() {
        return this.error;
    }

    public Http2Exception$ShutdownHint shutdownHint() {
        return this.shutdownHint;
    }

    public static Http2Exception connectionError(Http2Error http2Error, String string, Object ... objectArray) {
        return new Http2Exception(http2Error, String.format(string, objectArray));
    }

    public static Http2Exception connectionError(Http2Error http2Error, Throwable throwable, String string, Object ... objectArray) {
        return new Http2Exception(http2Error, String.format(string, objectArray), throwable);
    }

    public static Http2Exception closedStreamError(Http2Error http2Error, String string, Object ... objectArray) {
        return new Http2Exception$ClosedStreamCreationException(http2Error, String.format(string, objectArray));
    }

    public static Http2Exception streamError(int n2, Http2Error http2Error, String string, Object ... objectArray) {
        return 0 == n2 ? Http2Exception.connectionError(http2Error, string, objectArray) : new Http2Exception$StreamException(n2, http2Error, String.format(string, objectArray));
    }

    public static Http2Exception streamError(int n2, Http2Error http2Error, Throwable throwable, String string, Object ... objectArray) {
        return 0 == n2 ? Http2Exception.connectionError(http2Error, throwable, string, objectArray) : new Http2Exception$StreamException(n2, http2Error, String.format(string, objectArray), throwable);
    }

    public static Http2Exception headerListSizeError(int n2, Http2Error http2Error, boolean bl2, String string, Object ... objectArray) {
        return 0 == n2 ? Http2Exception.connectionError(http2Error, string, objectArray) : new Http2Exception$HeaderListSizeException(n2, http2Error, String.format(string, objectArray), bl2);
    }

    public static boolean isStreamError(Http2Exception http2Exception) {
        return http2Exception instanceof Http2Exception$StreamException;
    }

    public static int streamId(Http2Exception http2Exception) {
        return Http2Exception.isStreamError(http2Exception) ? ((Http2Exception$StreamException)http2Exception).streamId() : 0;
    }
}

