/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2ConnectionHandler$BaseDecoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler$FrameDecoder;
import io.netty.handler.codec.http2.Http2ConnectionPrefaceAndSettingsFrameWrittenEvent;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.util.CharsetUtil;
import java.util.List;

final class Http2ConnectionHandler$PrefaceDecoder
extends Http2ConnectionHandler$BaseDecoder {
    private ByteBuf clientPrefaceString;
    private boolean prefaceSent;
    final /* synthetic */ Http2ConnectionHandler this$0;

    public Http2ConnectionHandler$PrefaceDecoder(Http2ConnectionHandler http2ConnectionHandler, ChannelHandlerContext channelHandlerContext) {
        this.this$0 = http2ConnectionHandler;
        super(http2ConnectionHandler, null);
        this.clientPrefaceString = Http2ConnectionHandler.access$200(Http2ConnectionHandler.access$100(http2ConnectionHandler).connection());
        this.sendPreface(channelHandlerContext);
    }

    @Override
    public boolean prefaceSent() {
        return this.prefaceSent;
    }

    @Override
    public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        try {
            if (channelHandlerContext.channel().isActive() && this.readClientPrefaceString(byteBuf) && this.verifyFirstFrameIsSettings(byteBuf)) {
                Http2ConnectionHandler.access$302(this.this$0, new Http2ConnectionHandler$FrameDecoder(this.this$0, null));
                Http2ConnectionHandler.access$300(this.this$0).decode(channelHandlerContext, byteBuf, list);
            }
        }
        catch (Throwable throwable) {
            this.this$0.onError(channelHandlerContext, false, throwable);
        }
    }

    @Override
    public void channelActive(ChannelHandlerContext channelHandlerContext) {
        this.sendPreface(channelHandlerContext);
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.cleanup();
        super.channelInactive(channelHandlerContext);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        this.cleanup();
    }

    private void cleanup() {
        if (this.clientPrefaceString != null) {
            this.clientPrefaceString.release();
            this.clientPrefaceString = null;
        }
    }

    private boolean readClientPrefaceString(ByteBuf byteBuf) {
        if (this.clientPrefaceString == null) {
            return true;
        }
        int n2 = this.clientPrefaceString.readableBytes();
        int n3 = Math.min(byteBuf.readableBytes(), n2);
        if (n3 == 0 || !ByteBufUtil.equals(byteBuf, byteBuf.readerIndex(), this.clientPrefaceString, this.clientPrefaceString.readerIndex(), n3)) {
            int n4 = 1024;
            int n5 = ByteBufUtil.indexOf(Http2ConnectionHandler.access$500(), byteBuf.slice(byteBuf.readerIndex(), Math.min(byteBuf.readableBytes(), n4)));
            if (n5 != -1) {
                String string = byteBuf.toString(byteBuf.readerIndex(), n5 - byteBuf.readerIndex(), CharsetUtil.US_ASCII);
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Unexpected HTTP/1.x request: %s", string);
            }
            String string = ByteBufUtil.hexDump(byteBuf, byteBuf.readerIndex(), Math.min(byteBuf.readableBytes(), this.clientPrefaceString.readableBytes()));
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "HTTP/2 client preface string missing or corrupt. Hex dump for received bytes: %s", string);
        }
        byteBuf.skipBytes(n3);
        this.clientPrefaceString.skipBytes(n3);
        if (!this.clientPrefaceString.isReadable()) {
            this.clientPrefaceString.release();
            this.clientPrefaceString = null;
            return true;
        }
        return false;
    }

    private boolean verifyFirstFrameIsSettings(ByteBuf byteBuf) {
        if (byteBuf.readableBytes() < 5) {
            return false;
        }
        short s2 = byteBuf.getUnsignedByte(byteBuf.readerIndex() + 3);
        short s3 = byteBuf.getUnsignedByte(byteBuf.readerIndex() + 4);
        if (s2 != 4 || (s3 & 1) != 0) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "First received frame was not SETTINGS. Hex dump for first 5 bytes: %s", ByteBufUtil.hexDump(byteBuf, byteBuf.readerIndex(), 5));
        }
        return true;
    }

    private void sendPreface(ChannelHandlerContext channelHandlerContext) {
        boolean bl2;
        if (this.prefaceSent || !channelHandlerContext.channel().isActive()) {
            return;
        }
        this.prefaceSent = true;
        boolean bl3 = bl2 = !this.this$0.connection().isServer();
        if (bl2) {
            channelHandlerContext.write(Http2CodecUtil.connectionPrefaceBuf()).addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
        }
        Http2ConnectionHandler.access$100(this.this$0).writeSettings(channelHandlerContext, Http2ConnectionHandler.access$600(this.this$0), channelHandlerContext.newPromise()).addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
        if (bl2) {
            this.this$0.userEventTriggered(channelHandlerContext, Http2ConnectionPrefaceAndSettingsFrameWrittenEvent.INSTANCE);
        }
    }
}

