/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.StreamByteDistributor$StreamState;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import java.util.concurrent.TimeUnit;

public final class Http2CodecUtil {
    public static final int CONNECTION_STREAM_ID = 0;
    public static final int HTTP_UPGRADE_STREAM_ID = 1;
    public static final CharSequence HTTP_UPGRADE_SETTINGS_HEADER = AsciiString.cached("HTTP2-Settings");
    public static final CharSequence HTTP_UPGRADE_PROTOCOL_NAME = "h2c";
    public static final CharSequence TLS_UPGRADE_PROTOCOL_NAME = "h2";
    public static final int PING_FRAME_PAYLOAD_LENGTH = 8;
    public static final short MAX_UNSIGNED_BYTE = 255;
    public static final int MAX_PADDING = 256;
    public static final long MAX_UNSIGNED_INT = 0xFFFFFFFFL;
    public static final int FRAME_HEADER_LENGTH = 9;
    public static final int SETTING_ENTRY_LENGTH = 6;
    public static final int PRIORITY_ENTRY_LENGTH = 5;
    public static final int INT_FIELD_LENGTH = 4;
    public static final short MAX_WEIGHT = 256;
    public static final short MIN_WEIGHT = 1;
    private static final ByteBuf CONNECTION_PREFACE = Unpooled.unreleasableBuffer(Unpooled.directBuffer(24).writeBytes("PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n".getBytes(CharsetUtil.UTF_8))).asReadOnly();
    private static final ByteBuf EMPTY_PING = Unpooled.unreleasableBuffer(Unpooled.directBuffer(8).writeZero(8)).asReadOnly();
    private static final int MAX_PADDING_LENGTH_LENGTH = 1;
    public static final int DATA_FRAME_HEADER_LENGTH = 10;
    public static final int HEADERS_FRAME_HEADER_LENGTH = 15;
    public static final int PRIORITY_FRAME_LENGTH = 14;
    public static final int RST_STREAM_FRAME_LENGTH = 13;
    public static final int PUSH_PROMISE_FRAME_HEADER_LENGTH = 14;
    public static final int GO_AWAY_FRAME_HEADER_LENGTH = 17;
    public static final int WINDOW_UPDATE_FRAME_LENGTH = 13;
    public static final int CONTINUATION_FRAME_HEADER_LENGTH = 10;
    public static final char SETTINGS_HEADER_TABLE_SIZE = '\u0001';
    public static final char SETTINGS_ENABLE_PUSH = '\u0002';
    public static final char SETTINGS_MAX_CONCURRENT_STREAMS = '\u0003';
    public static final char SETTINGS_INITIAL_WINDOW_SIZE = '\u0004';
    public static final char SETTINGS_MAX_FRAME_SIZE = '\u0005';
    public static final char SETTINGS_MAX_HEADER_LIST_SIZE = '\u0006';
    public static final int NUM_STANDARD_SETTINGS = 6;
    public static final long MAX_HEADER_TABLE_SIZE = 0xFFFFFFFFL;
    public static final long MAX_CONCURRENT_STREAMS = 0xFFFFFFFFL;
    public static final int MAX_INITIAL_WINDOW_SIZE = Integer.MAX_VALUE;
    public static final int MAX_FRAME_SIZE_LOWER_BOUND = 16384;
    public static final int MAX_FRAME_SIZE_UPPER_BOUND = 0xFFFFFF;
    public static final long MAX_HEADER_LIST_SIZE = 0xFFFFFFFFL;
    public static final long MIN_HEADER_TABLE_SIZE = 0L;
    public static final long MIN_CONCURRENT_STREAMS = 0L;
    public static final int MIN_INITIAL_WINDOW_SIZE = 0;
    public static final long MIN_HEADER_LIST_SIZE = 0L;
    public static final int DEFAULT_WINDOW_SIZE = 65535;
    public static final short DEFAULT_PRIORITY_WEIGHT = 16;
    public static final int DEFAULT_HEADER_TABLE_SIZE = 4096;
    public static final long DEFAULT_HEADER_LIST_SIZE = 8192L;
    public static final int DEFAULT_MAX_FRAME_SIZE = 16384;
    public static final int SMALLEST_MAX_CONCURRENT_STREAMS = 100;
    static final int DEFAULT_MAX_RESERVED_STREAMS = 100;
    static final int DEFAULT_MIN_ALLOCATION_CHUNK = 1024;
    static final int DEFAULT_INITIAL_HUFFMAN_DECODE_CAPACITY = 32;
    public static final long DEFAULT_GRACEFUL_SHUTDOWN_TIMEOUT_MILLIS = TimeUnit.MILLISECONDS.convert(30L, TimeUnit.SECONDS);

    public static long calculateMaxHeaderListSizeGoAway(long l2) {
        return l2 + (l2 >>> 2);
    }

    public static boolean isOutboundStream(boolean bl2, int n2) {
        boolean bl3 = (n2 & 1) == 0;
        return n2 > 0 && bl2 == bl3;
    }

    public static boolean isStreamIdValid(int n2) {
        return n2 >= 0;
    }

    public static boolean isMaxFrameSizeValid(int n2) {
        return n2 >= 16384 && n2 <= 0xFFFFFF;
    }

    public static ByteBuf connectionPrefaceBuf() {
        return CONNECTION_PREFACE.retainedDuplicate();
    }

    public static ByteBuf emptyPingBuf() {
        return EMPTY_PING.retainedDuplicate();
    }

    public static Http2Exception getEmbeddedHttp2Exception(Throwable throwable) {
        while (throwable != null) {
            if (throwable instanceof Http2Exception) {
                return (Http2Exception)throwable;
            }
            throwable = throwable.getCause();
        }
        return null;
    }

    public static ByteBuf toByteBuf(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        if (throwable == null || throwable.getMessage() == null) {
            return Unpooled.EMPTY_BUFFER;
        }
        return ByteBufUtil.writeUtf8(channelHandlerContext.alloc(), (CharSequence)throwable.getMessage());
    }

    public static int readUnsignedInt(ByteBuf byteBuf) {
        return byteBuf.readInt() & Integer.MAX_VALUE;
    }

    public static void writeFrameHeader(ByteBuf byteBuf, int n2, byte by2, Http2Flags http2Flags, int n3) {
        byteBuf.ensureWritable(9 + n2);
        Http2CodecUtil.writeFrameHeaderInternal(byteBuf, n2, by2, http2Flags, n3);
    }

    public static int streamableBytes(StreamByteDistributor$StreamState streamByteDistributor$StreamState) {
        return Math.max(0, (int)Math.min(streamByteDistributor$StreamState.pendingBytes(), (long)streamByteDistributor$StreamState.windowSize()));
    }

    public static void headerListSizeExceeded(int n2, long l2, boolean bl2) {
        throw Http2Exception.headerListSizeError(n2, Http2Error.PROTOCOL_ERROR, bl2, "Header size exceeded max allowed size (%d)", l2);
    }

    public static void headerListSizeExceeded(long l2) {
        throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header size exceeded max allowed size (%d)", l2);
    }

    static void writeFrameHeaderInternal(ByteBuf byteBuf, int n2, byte by2, Http2Flags http2Flags, int n3) {
        byteBuf.writeMedium(n2);
        byteBuf.writeByte(by2);
        byteBuf.writeByte(http2Flags.value());
        byteBuf.writeInt(n3);
    }

    public static void verifyPadding(int n2) {
        if (n2 < 0 || n2 > 256) {
            throw new IllegalArgumentException(String.format("Invalid padding '%d'. Padding must be between 0 and %d (inclusive).", n2, 256));
        }
    }

    private Http2CodecUtil() {
    }
}

