/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http2.HpackHuffmanEncoder$EncodeProcessor;
import io.netty.handler.codec.http2.HpackHuffmanEncoder$EncodedLengthProcessor;
import io.netty.handler.codec.http2.HpackUtil;
import io.netty.util.AsciiString;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;

final class HpackHuffmanEncoder {
    private final int[] codes;
    private final byte[] lengths;
    private final HpackHuffmanEncoder$EncodedLengthProcessor encodedLengthProcessor = new HpackHuffmanEncoder$EncodedLengthProcessor(this);
    private final HpackHuffmanEncoder$EncodeProcessor encodeProcessor = new HpackHuffmanEncoder$EncodeProcessor(this);

    HpackHuffmanEncoder() {
        this(HpackUtil.HUFFMAN_CODES, HpackUtil.HUFFMAN_CODE_LENGTHS);
    }

    private HpackHuffmanEncoder(int[] nArray, byte[] byArray) {
        this.codes = nArray;
        this.lengths = byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(ByteBuf byteBuf, CharSequence charSequence) {
        ObjectUtil.checkNotNull(byteBuf, "out");
        if (charSequence instanceof AsciiString) {
            AsciiString asciiString = (AsciiString)charSequence;
            try {
                this.encodeProcessor.out = byteBuf;
                asciiString.forEachByte(this.encodeProcessor);
            }
            catch (Exception exception) {
                PlatformDependent.throwException(exception);
            }
            finally {
                this.encodeProcessor.end();
            }
        } else {
            this.encodeSlowPath(byteBuf, charSequence);
        }
    }

    private void encodeSlowPath(ByteBuf byteBuf, CharSequence charSequence) {
        long l2 = 0L;
        int n2 = 0;
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            int n3 = charSequence.charAt(i2) & 0xFF;
            int n4 = this.codes[n3];
            byte by2 = this.lengths[n3];
            l2 <<= by2;
            l2 |= (long)n4;
            n2 += by2;
            while (n2 >= 8) {
                byteBuf.writeByte((int)(l2 >> (n2 -= 8)));
            }
        }
        if (n2 > 0) {
            l2 <<= 8 - n2;
            byteBuf.writeByte((int)(l2 |= (long)(255 >>> n2)));
        }
    }

    int getEncodedLength(CharSequence charSequence) {
        if (charSequence instanceof AsciiString) {
            AsciiString asciiString = (AsciiString)charSequence;
            try {
                this.encodedLengthProcessor.reset();
                asciiString.forEachByte(this.encodedLengthProcessor);
                return this.encodedLengthProcessor.length();
            }
            catch (Exception exception) {
                PlatformDependent.throwException(exception);
                return -1;
            }
        }
        return this.getEncodedLengthSlowPath(charSequence);
    }

    private int getEncodedLengthSlowPath(CharSequence charSequence) {
        long l2 = 0L;
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            l2 += (long)this.lengths[charSequence.charAt(i2) & 0xFF];
        }
        return (int)(l2 + 7L >> 3);
    }

    static /* synthetic */ byte[] access$200(HpackHuffmanEncoder hpackHuffmanEncoder) {
        return hpackHuffmanEncoder.lengths;
    }

    static /* synthetic */ int[] access$300(HpackHuffmanEncoder hpackHuffmanEncoder) {
        return hpackHuffmanEncoder.codes;
    }
}

