/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http2.HpackHuffmanDecoder$DecoderProcessor;
import io.netty.handler.codec.http2.HpackHuffmanDecoder$Node;
import io.netty.handler.codec.http2.HpackUtil;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.util.AsciiString;
import io.netty.util.internal.ThrowableUtil;

final class HpackHuffmanDecoder {
    private static final Http2Exception EOS_DECODED = ThrowableUtil.unknownStackTrace(Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, "HPACK - EOS Decoded", new Object[0]), HpackHuffmanDecoder.class, "decode(..)");
    private static final Http2Exception INVALID_PADDING = ThrowableUtil.unknownStackTrace(Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, "HPACK - Invalid Padding", new Object[0]), HpackHuffmanDecoder.class, "decode(..)");
    private static final HpackHuffmanDecoder$Node ROOT = HpackHuffmanDecoder.buildTree(HpackUtil.HUFFMAN_CODES, HpackUtil.HUFFMAN_CODE_LENGTHS);
    private final HpackHuffmanDecoder$DecoderProcessor processor;

    HpackHuffmanDecoder(int n2) {
        this.processor = new HpackHuffmanDecoder$DecoderProcessor(n2);
    }

    public AsciiString decode(ByteBuf byteBuf, int n2) {
        this.processor.reset();
        byteBuf.forEachByte(byteBuf.readerIndex(), n2, this.processor);
        byteBuf.skipBytes(n2);
        return this.processor.end();
    }

    private static HpackHuffmanDecoder$Node buildTree(int[] nArray, byte[] byArray) {
        HpackHuffmanDecoder$Node hpackHuffmanDecoder$Node = new HpackHuffmanDecoder$Node();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            HpackHuffmanDecoder.insert(hpackHuffmanDecoder$Node, i2, nArray[i2], byArray[i2]);
        }
        return hpackHuffmanDecoder$Node;
    }

    private static void insert(HpackHuffmanDecoder$Node hpackHuffmanDecoder$Node, int n2, int n3, byte by2) {
        HpackHuffmanDecoder$Node hpackHuffmanDecoder$Node2 = hpackHuffmanDecoder$Node;
        while (by2 > 8) {
            if (HpackHuffmanDecoder$Node.access$000(hpackHuffmanDecoder$Node2)) {
                throw new IllegalStateException("invalid Huffman code: prefix not unique");
            }
            by2 = (byte)(by2 - 8);
            int n4 = n3 >>> by2 & 0xFF;
            if (HpackHuffmanDecoder$Node.access$100(hpackHuffmanDecoder$Node2)[n4] == null) {
                HpackHuffmanDecoder$Node.access$100((HpackHuffmanDecoder$Node)hpackHuffmanDecoder$Node2)[n4] = new HpackHuffmanDecoder$Node();
            }
            hpackHuffmanDecoder$Node2 = HpackHuffmanDecoder$Node.access$100(hpackHuffmanDecoder$Node2)[n4];
        }
        HpackHuffmanDecoder$Node hpackHuffmanDecoder$Node3 = new HpackHuffmanDecoder$Node(n2, by2);
        int n5 = 8 - by2;
        int n6 = n3 << n5 & 0xFF;
        int n7 = 1 << n5;
        for (int i2 = n6; i2 < n6 + n7; ++i2) {
            HpackHuffmanDecoder$Node.access$100((HpackHuffmanDecoder$Node)hpackHuffmanDecoder$Node2)[i2] = hpackHuffmanDecoder$Node3;
        }
    }

    static /* synthetic */ HpackHuffmanDecoder$Node access$200() {
        return ROOT;
    }

    static /* synthetic */ Http2Exception access$500() {
        return EOS_DECODED;
    }

    static /* synthetic */ Http2Exception access$600() {
        return INVALID_PADDING;
    }
}

