/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.HpackHuffmanDecoder;
import io.netty.handler.codec.http2.HpackHuffmanDecoder$Node;
import io.netty.util.AsciiString;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.ObjectUtil;

final class HpackHuffmanDecoder$DecoderProcessor
implements ByteProcessor {
    private final int initialCapacity;
    private byte[] bytes;
    private int index;
    private HpackHuffmanDecoder$Node node;
    private int current;
    private int currentBits;
    private int symbolBits;

    HpackHuffmanDecoder$DecoderProcessor(int n2) {
        this.initialCapacity = ObjectUtil.checkPositive(n2, "initialCapacity");
    }

    void reset() {
        this.node = HpackHuffmanDecoder.access$200();
        this.current = 0;
        this.currentBits = 0;
        this.symbolBits = 0;
        this.bytes = new byte[this.initialCapacity];
        this.index = 0;
    }

    @Override
    public boolean process(byte by2) {
        this.current = this.current << 8 | by2 & 0xFF;
        this.currentBits += 8;
        this.symbolBits += 8;
        do {
            this.node = HpackHuffmanDecoder$Node.access$100(this.node)[this.current >>> this.currentBits - 8 & 0xFF];
            this.currentBits -= HpackHuffmanDecoder$Node.access$300(this.node);
            if (!HpackHuffmanDecoder$Node.access$000(this.node)) continue;
            if (HpackHuffmanDecoder$Node.access$400(this.node) == 256) {
                throw HpackHuffmanDecoder.access$500();
            }
            this.append(HpackHuffmanDecoder$Node.access$400(this.node));
            this.node = HpackHuffmanDecoder.access$200();
            this.symbolBits = this.currentBits;
        } while (this.currentBits >= 8);
        return true;
    }

    AsciiString end() {
        while (this.currentBits > 0) {
            this.node = HpackHuffmanDecoder$Node.access$100(this.node)[this.current << 8 - this.currentBits & 0xFF];
            if (!HpackHuffmanDecoder$Node.access$000(this.node) || HpackHuffmanDecoder$Node.access$300(this.node) > this.currentBits) break;
            if (HpackHuffmanDecoder$Node.access$400(this.node) == 256) {
                throw HpackHuffmanDecoder.access$500();
            }
            this.currentBits -= HpackHuffmanDecoder$Node.access$300(this.node);
            this.append(HpackHuffmanDecoder$Node.access$400(this.node));
            this.node = HpackHuffmanDecoder.access$200();
            this.symbolBits = this.currentBits;
        }
        int n2 = (1 << this.symbolBits) - 1;
        if (this.symbolBits > 7 || (this.current & n2) != n2) {
            throw HpackHuffmanDecoder.access$600();
        }
        return new AsciiString(this.bytes, 0, this.index, false);
    }

    private void append(int n2) {
        if (this.bytes.length == this.index) {
            int n3 = this.bytes.length >= 1024 ? this.bytes.length + this.initialCapacity : this.bytes.length << 1;
            byte[] byArray = new byte[n3];
            System.arraycopy(this.bytes, 0, byArray, 0, this.bytes.length);
            this.bytes = byArray;
        }
        this.bytes[this.index++] = (byte)n2;
    }
}

