/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http2.HpackEncoder$HeaderEntry;
import io.netty.handler.codec.http2.HpackHeaderField;
import io.netty.handler.codec.http2.HpackHuffmanEncoder;
import io.netty.handler.codec.http2.HpackStaticTable;
import io.netty.handler.codec.http2.HpackUtil;
import io.netty.handler.codec.http2.HpackUtil$IndexType;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersEncoder$SensitivityDetector;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.MathUtil;
import java.util.Arrays;
import java.util.Map;

final class HpackEncoder {
    private final HpackEncoder$HeaderEntry[] headerFields;
    private final HpackEncoder$HeaderEntry head = new HpackEncoder$HeaderEntry(-1, AsciiString.EMPTY_STRING, AsciiString.EMPTY_STRING, Integer.MAX_VALUE, null);
    private final HpackHuffmanEncoder hpackHuffmanEncoder = new HpackHuffmanEncoder();
    private final byte hashMask;
    private final boolean ignoreMaxHeaderListSize;
    private long size;
    private long maxHeaderTableSize;
    private long maxHeaderListSize;

    HpackEncoder() {
        this(false);
    }

    public HpackEncoder(boolean bl2) {
        this(bl2, 16);
    }

    public HpackEncoder(boolean bl2, int n2) {
        this.ignoreMaxHeaderListSize = bl2;
        this.maxHeaderTableSize = 4096L;
        this.maxHeaderListSize = 0xFFFFFFFFL;
        this.headerFields = new HpackEncoder$HeaderEntry[MathUtil.findNextPositivePowerOfTwo(Math.max(2, Math.min(n2, 128)))];
        this.hashMask = (byte)(this.headerFields.length - 1);
        this.head.before = this.head.after = this.head;
    }

    public void encodeHeaders(int n2, ByteBuf byteBuf, Http2Headers http2Headers, Http2HeadersEncoder$SensitivityDetector http2HeadersEncoder$SensitivityDetector) {
        if (this.ignoreMaxHeaderListSize) {
            this.encodeHeadersIgnoreMaxHeaderListSize(byteBuf, http2Headers, http2HeadersEncoder$SensitivityDetector);
        } else {
            this.encodeHeadersEnforceMaxHeaderListSize(n2, byteBuf, http2Headers, http2HeadersEncoder$SensitivityDetector);
        }
    }

    private void encodeHeadersEnforceMaxHeaderListSize(int n2, ByteBuf byteBuf, Http2Headers http2Headers, Http2HeadersEncoder$SensitivityDetector http2HeadersEncoder$SensitivityDetector) {
        long l2 = 0L;
        for (Map.Entry<CharSequence, CharSequence> entry : http2Headers) {
            CharSequence charSequence;
            CharSequence charSequence2 = entry.getKey();
            if ((l2 += HpackHeaderField.sizeOf(charSequence2, charSequence = entry.getValue())) <= this.maxHeaderListSize) continue;
            Http2CodecUtil.headerListSizeExceeded(n2, this.maxHeaderListSize, false);
        }
        this.encodeHeadersIgnoreMaxHeaderListSize(byteBuf, http2Headers, http2HeadersEncoder$SensitivityDetector);
    }

    private void encodeHeadersIgnoreMaxHeaderListSize(ByteBuf byteBuf, Http2Headers http2Headers, Http2HeadersEncoder$SensitivityDetector http2HeadersEncoder$SensitivityDetector) {
        for (Map.Entry<CharSequence, CharSequence> entry : http2Headers) {
            CharSequence charSequence = entry.getKey();
            CharSequence charSequence2 = entry.getValue();
            this.encodeHeader(byteBuf, charSequence, charSequence2, http2HeadersEncoder$SensitivityDetector.isSensitive(charSequence, charSequence2), HpackHeaderField.sizeOf(charSequence, charSequence2));
        }
    }

    private void encodeHeader(ByteBuf byteBuf, CharSequence charSequence, CharSequence charSequence2, boolean bl2, long l2) {
        if (bl2) {
            int n2 = this.getNameIndex(charSequence);
            this.encodeLiteral(byteBuf, charSequence, charSequence2, HpackUtil$IndexType.NEVER, n2);
            return;
        }
        if (this.maxHeaderTableSize == 0L) {
            int n3 = HpackStaticTable.getIndex(charSequence, charSequence2);
            if (n3 == -1) {
                int n4 = HpackStaticTable.getIndex(charSequence);
                this.encodeLiteral(byteBuf, charSequence, charSequence2, HpackUtil$IndexType.NONE, n4);
            } else {
                HpackEncoder.encodeInteger(byteBuf, 128, 7, n3);
            }
            return;
        }
        if (l2 > this.maxHeaderTableSize) {
            int n5 = this.getNameIndex(charSequence);
            this.encodeLiteral(byteBuf, charSequence, charSequence2, HpackUtil$IndexType.NONE, n5);
            return;
        }
        HpackEncoder$HeaderEntry hpackEncoder$HeaderEntry = this.getEntry(charSequence, charSequence2);
        if (hpackEncoder$HeaderEntry != null) {
            int n6 = this.getIndex(hpackEncoder$HeaderEntry.index) + HpackStaticTable.length;
            HpackEncoder.encodeInteger(byteBuf, 128, 7, n6);
        } else {
            int n7 = HpackStaticTable.getIndex(charSequence, charSequence2);
            if (n7 != -1) {
                HpackEncoder.encodeInteger(byteBuf, 128, 7, n7);
            } else {
                this.ensureCapacity(l2);
                this.encodeLiteral(byteBuf, charSequence, charSequence2, HpackUtil$IndexType.INCREMENTAL, this.getNameIndex(charSequence));
                this.add(charSequence, charSequence2, l2);
            }
        }
    }

    public void setMaxHeaderTableSize(ByteBuf byteBuf, long l2) {
        if (l2 < 0L || l2 > 0xFFFFFFFFL) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header Table Size must be >= %d and <= %d but was %d", 0L, 0xFFFFFFFFL, l2);
        }
        if (this.maxHeaderTableSize == l2) {
            return;
        }
        this.maxHeaderTableSize = l2;
        this.ensureCapacity(0L);
        HpackEncoder.encodeInteger(byteBuf, 32, 5, l2);
    }

    public long getMaxHeaderTableSize() {
        return this.maxHeaderTableSize;
    }

    public void setMaxHeaderListSize(long l2) {
        if (l2 < 0L || l2 > 0xFFFFFFFFL) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header List Size must be >= %d and <= %d but was %d", 0L, 0xFFFFFFFFL, l2);
        }
        this.maxHeaderListSize = l2;
    }

    public long getMaxHeaderListSize() {
        return this.maxHeaderListSize;
    }

    private static void encodeInteger(ByteBuf byteBuf, int n2, int n3, int n4) {
        HpackEncoder.encodeInteger(byteBuf, n2, n3, (long)n4);
    }

    private static void encodeInteger(ByteBuf byteBuf, int n2, int n3, long l2) {
        assert (n3 >= 0 && n3 <= 8) : "N: " + n3;
        int n4 = 255 >>> 8 - n3;
        if (l2 < (long)n4) {
            byteBuf.writeByte((int)((long)n2 | l2));
        } else {
            byteBuf.writeByte(n2 | n4);
            long l3 = l2 - (long)n4;
            while ((l3 & 0xFFFFFFFFFFFFFF80L) != 0L) {
                byteBuf.writeByte((int)(l3 & 0x7FL | 0x80L));
                l3 >>>= 7;
            }
            byteBuf.writeByte((int)l3);
        }
    }

    private void encodeStringLiteral(ByteBuf byteBuf, CharSequence charSequence) {
        int n2 = this.hpackHuffmanEncoder.getEncodedLength(charSequence);
        if (n2 < charSequence.length()) {
            HpackEncoder.encodeInteger(byteBuf, 128, 7, n2);
            this.hpackHuffmanEncoder.encode(byteBuf, charSequence);
        } else {
            HpackEncoder.encodeInteger(byteBuf, 0, 7, charSequence.length());
            if (charSequence instanceof AsciiString) {
                AsciiString asciiString = (AsciiString)charSequence;
                byteBuf.writeBytes(asciiString.array(), asciiString.arrayOffset(), asciiString.length());
            } else {
                byteBuf.writeCharSequence(charSequence, CharsetUtil.ISO_8859_1);
            }
        }
    }

    private void encodeLiteral(ByteBuf byteBuf, CharSequence charSequence, CharSequence charSequence2, HpackUtil$IndexType hpackUtil$IndexType, int n2) {
        boolean bl2 = n2 != -1;
        switch (hpackUtil$IndexType) {
            case INCREMENTAL: {
                HpackEncoder.encodeInteger(byteBuf, 64, 6, bl2 ? n2 : 0);
                break;
            }
            case NONE: {
                HpackEncoder.encodeInteger(byteBuf, 0, 4, bl2 ? n2 : 0);
                break;
            }
            case NEVER: {
                HpackEncoder.encodeInteger(byteBuf, 16, 4, bl2 ? n2 : 0);
                break;
            }
            default: {
                throw new Error("should not reach here");
            }
        }
        if (!bl2) {
            this.encodeStringLiteral(byteBuf, charSequence);
        }
        this.encodeStringLiteral(byteBuf, charSequence2);
    }

    private int getNameIndex(CharSequence charSequence) {
        int n2 = HpackStaticTable.getIndex(charSequence);
        if (n2 == -1 && (n2 = this.getIndex(charSequence)) >= 0) {
            n2 += HpackStaticTable.length;
        }
        return n2;
    }

    private void ensureCapacity(long l2) {
        int n2;
        while (this.maxHeaderTableSize - this.size < l2 && (n2 = this.length()) != 0) {
            this.remove();
        }
    }

    int length() {
        return this.size == 0L ? 0 : this.head.after.index - this.head.before.index + 1;
    }

    long size() {
        return this.size;
    }

    HpackHeaderField getHeaderField(int n2) {
        HpackEncoder$HeaderEntry hpackEncoder$HeaderEntry = this.head;
        while (n2-- >= 0) {
            hpackEncoder$HeaderEntry = hpackEncoder$HeaderEntry.before;
        }
        return hpackEncoder$HeaderEntry;
    }

    private HpackEncoder$HeaderEntry getEntry(CharSequence charSequence, CharSequence charSequence2) {
        if (this.length() == 0 || charSequence == null || charSequence2 == null) {
            return null;
        }
        int n2 = AsciiString.hashCode(charSequence);
        int n3 = this.index(n2);
        HpackEncoder$HeaderEntry hpackEncoder$HeaderEntry = this.headerFields[n3];
        while (hpackEncoder$HeaderEntry != null) {
            if (hpackEncoder$HeaderEntry.hash == n2 && (HpackUtil.equalsConstantTime(charSequence, hpackEncoder$HeaderEntry.name) & HpackUtil.equalsConstantTime(charSequence2, hpackEncoder$HeaderEntry.value)) != 0) {
                return hpackEncoder$HeaderEntry;
            }
            hpackEncoder$HeaderEntry = hpackEncoder$HeaderEntry.next;
        }
        return null;
    }

    private int getIndex(CharSequence charSequence) {
        if (this.length() == 0 || charSequence == null) {
            return -1;
        }
        int n2 = AsciiString.hashCode(charSequence);
        int n3 = this.index(n2);
        HpackEncoder$HeaderEntry hpackEncoder$HeaderEntry = this.headerFields[n3];
        while (hpackEncoder$HeaderEntry != null) {
            if (hpackEncoder$HeaderEntry.hash == n2 && HpackUtil.equalsConstantTime(charSequence, hpackEncoder$HeaderEntry.name) != 0) {
                return this.getIndex(hpackEncoder$HeaderEntry.index);
            }
            hpackEncoder$HeaderEntry = hpackEncoder$HeaderEntry.next;
        }
        return -1;
    }

    private int getIndex(int n2) {
        return n2 == -1 ? -1 : n2 - this.head.before.index + 1;
    }

    private void add(CharSequence charSequence, CharSequence charSequence2, long l2) {
        HpackEncoder$HeaderEntry hpackEncoder$HeaderEntry;
        if (l2 > this.maxHeaderTableSize) {
            this.clear();
            return;
        }
        while (this.maxHeaderTableSize - this.size < l2) {
            this.remove();
        }
        int n2 = AsciiString.hashCode(charSequence);
        int n3 = this.index(n2);
        HpackEncoder$HeaderEntry hpackEncoder$HeaderEntry2 = this.headerFields[n3];
        this.headerFields[n3] = hpackEncoder$HeaderEntry = new HpackEncoder$HeaderEntry(n2, charSequence, charSequence2, this.head.before.index - 1, hpackEncoder$HeaderEntry2);
        HpackEncoder$HeaderEntry.access$000(hpackEncoder$HeaderEntry, this.head);
        this.size += l2;
    }

    private HpackHeaderField remove() {
        HpackEncoder$HeaderEntry hpackEncoder$HeaderEntry;
        if (this.size == 0L) {
            return null;
        }
        HpackEncoder$HeaderEntry hpackEncoder$HeaderEntry2 = this.head.after;
        int n2 = hpackEncoder$HeaderEntry2.hash;
        int n3 = this.index(n2);
        HpackEncoder$HeaderEntry hpackEncoder$HeaderEntry3 = hpackEncoder$HeaderEntry = this.headerFields[n3];
        while (hpackEncoder$HeaderEntry3 != null) {
            HpackEncoder$HeaderEntry hpackEncoder$HeaderEntry4 = hpackEncoder$HeaderEntry3.next;
            if (hpackEncoder$HeaderEntry3 == hpackEncoder$HeaderEntry2) {
                if (hpackEncoder$HeaderEntry == hpackEncoder$HeaderEntry2) {
                    this.headerFields[n3] = hpackEncoder$HeaderEntry4;
                } else {
                    hpackEncoder$HeaderEntry.next = hpackEncoder$HeaderEntry4;
                }
                HpackEncoder$HeaderEntry.access$100(hpackEncoder$HeaderEntry2);
                this.size -= (long)hpackEncoder$HeaderEntry2.size();
                return hpackEncoder$HeaderEntry2;
            }
            hpackEncoder$HeaderEntry = hpackEncoder$HeaderEntry3;
            hpackEncoder$HeaderEntry3 = hpackEncoder$HeaderEntry4;
        }
        return null;
    }

    private void clear() {
        Arrays.fill(this.headerFields, null);
        this.head.before = this.head.after = this.head;
        this.size = 0L;
    }

    private int index(int n2) {
        return n2 & this.hashMask;
    }
}

