/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http2.HpackDecoder$HeaderType;
import io.netty.handler.codec.http2.HpackDynamicTable;
import io.netty.handler.codec.http2.HpackHeaderField;
import io.netty.handler.codec.http2.HpackHuffmanDecoder;
import io.netty.handler.codec.http2.HpackStaticTable;
import io.netty.handler.codec.http2.HpackUtil$IndexType;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Headers$PseudoHeaderName;
import io.netty.util.AsciiString;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.ThrowableUtil;

final class HpackDecoder {
    private static final Http2Exception DECODE_ULE_128_DECOMPRESSION_EXCEPTION = ThrowableUtil.unknownStackTrace(Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, "HPACK - decompression failure", new Object[0]), HpackDecoder.class, "decodeULE128(..)");
    private static final Http2Exception DECODE_ULE_128_TO_LONG_DECOMPRESSION_EXCEPTION = ThrowableUtil.unknownStackTrace(Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, "HPACK - long overflow", new Object[0]), HpackDecoder.class, "decodeULE128(..)");
    private static final Http2Exception DECODE_ULE_128_TO_INT_DECOMPRESSION_EXCEPTION = ThrowableUtil.unknownStackTrace(Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, "HPACK - int overflow", new Object[0]), HpackDecoder.class, "decodeULE128ToInt(..)");
    private static final Http2Exception DECODE_ILLEGAL_INDEX_VALUE = ThrowableUtil.unknownStackTrace(Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, "HPACK - illegal index value", new Object[0]), HpackDecoder.class, "decode(..)");
    private static final Http2Exception INDEX_HEADER_ILLEGAL_INDEX_VALUE = ThrowableUtil.unknownStackTrace(Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, "HPACK - illegal index value", new Object[0]), HpackDecoder.class, "indexHeader(..)");
    private static final Http2Exception READ_NAME_ILLEGAL_INDEX_VALUE = ThrowableUtil.unknownStackTrace(Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, "HPACK - illegal index value", new Object[0]), HpackDecoder.class, "readName(..)");
    private static final Http2Exception INVALID_MAX_DYNAMIC_TABLE_SIZE = ThrowableUtil.unknownStackTrace(Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, "HPACK - invalid max dynamic table size", new Object[0]), HpackDecoder.class, "setDynamicTableSize(..)");
    private static final Http2Exception MAX_DYNAMIC_TABLE_SIZE_CHANGE_REQUIRED = ThrowableUtil.unknownStackTrace(Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, "HPACK - max dynamic table size change required", new Object[0]), HpackDecoder.class, "decode(..)");
    private static final byte READ_HEADER_REPRESENTATION = 0;
    private static final byte READ_MAX_DYNAMIC_TABLE_SIZE = 1;
    private static final byte READ_INDEXED_HEADER = 2;
    private static final byte READ_INDEXED_HEADER_NAME = 3;
    private static final byte READ_LITERAL_HEADER_NAME_LENGTH_PREFIX = 4;
    private static final byte READ_LITERAL_HEADER_NAME_LENGTH = 5;
    private static final byte READ_LITERAL_HEADER_NAME = 6;
    private static final byte READ_LITERAL_HEADER_VALUE_LENGTH_PREFIX = 7;
    private static final byte READ_LITERAL_HEADER_VALUE_LENGTH = 8;
    private static final byte READ_LITERAL_HEADER_VALUE = 9;
    private final HpackDynamicTable hpackDynamicTable;
    private final HpackHuffmanDecoder hpackHuffmanDecoder;
    private long maxHeaderListSizeGoAway;
    private long maxHeaderListSize;
    private long maxDynamicTableSize;
    private long encoderMaxDynamicTableSize;
    private boolean maxDynamicTableSizeChangeRequired;

    HpackDecoder(long l2, int n2) {
        this(l2, n2, 4096);
    }

    HpackDecoder(long l2, int n2, int n3) {
        this.maxHeaderListSize = ObjectUtil.checkPositive(l2, "maxHeaderListSize");
        this.maxHeaderListSizeGoAway = Http2CodecUtil.calculateMaxHeaderListSizeGoAway(l2);
        this.maxDynamicTableSize = this.encoderMaxDynamicTableSize = (long)n3;
        this.maxDynamicTableSizeChangeRequired = false;
        this.hpackDynamicTable = new HpackDynamicTable(n3);
        this.hpackHuffmanDecoder = new HpackHuffmanDecoder(n2);
    }

    public void decode(int n2, ByteBuf byteBuf, Http2Headers http2Headers, boolean bl2) {
        int n3 = 0;
        long l2 = 0L;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl3 = false;
        CharSequence charSequence = null;
        HpackDecoder$HeaderType hpackDecoder$HeaderType = null;
        HpackUtil$IndexType hpackUtil$IndexType = HpackUtil$IndexType.NONE;
        block28: while (byteBuf.isReadable()) {
            switch (n6) {
                case 0: {
                    HpackHeaderField hpackHeaderField;
                    byte by2 = byteBuf.readByte();
                    if (this.maxDynamicTableSizeChangeRequired && (by2 & 0xE0) != 32) {
                        throw MAX_DYNAMIC_TABLE_SIZE_CHANGE_REQUIRED;
                    }
                    if (by2 < 0) {
                        n3 = by2 & 0x7F;
                        switch (n3) {
                            case 0: {
                                throw DECODE_ILLEGAL_INDEX_VALUE;
                            }
                            case 127: {
                                n6 = 2;
                                continue block28;
                            }
                        }
                        hpackHeaderField = this.getIndexedHeader(n3);
                        hpackDecoder$HeaderType = this.validate(hpackHeaderField.name, hpackDecoder$HeaderType, bl2);
                        l2 = this.addHeader(http2Headers, hpackHeaderField.name, hpackHeaderField.value, l2);
                        continue block28;
                    }
                    if ((by2 & 0x40) == 64) {
                        hpackUtil$IndexType = HpackUtil$IndexType.INCREMENTAL;
                        n3 = by2 & 0x3F;
                        switch (n3) {
                            case 0: {
                                n6 = 4;
                                continue block28;
                            }
                            case 63: {
                                n6 = 3;
                                continue block28;
                            }
                        }
                        charSequence = this.readName(n3);
                        hpackDecoder$HeaderType = this.validate(charSequence, hpackDecoder$HeaderType, bl2);
                        n4 = charSequence.length();
                        n6 = 7;
                        continue block28;
                    }
                    if ((by2 & 0x20) == 32) {
                        n3 = by2 & 0x1F;
                        if (n3 == 31) {
                            n6 = 1;
                            continue block28;
                        }
                        this.setDynamicTableSize(n3);
                        n6 = 0;
                        continue block28;
                    }
                    hpackUtil$IndexType = (by2 & 0x10) == 16 ? HpackUtil$IndexType.NEVER : HpackUtil$IndexType.NONE;
                    n3 = by2 & 0xF;
                    switch (n3) {
                        case 0: {
                            n6 = 4;
                            continue block28;
                        }
                        case 15: {
                            n6 = 3;
                            continue block28;
                        }
                    }
                    charSequence = this.readName(n3);
                    hpackDecoder$HeaderType = this.validate(charSequence, hpackDecoder$HeaderType, bl2);
                    n4 = charSequence.length();
                    n6 = 7;
                    continue block28;
                }
                case 1: {
                    this.setDynamicTableSize(HpackDecoder.decodeULE128(byteBuf, (long)n3));
                    n6 = 0;
                    continue block28;
                }
                case 2: {
                    HpackHeaderField hpackHeaderField = this.getIndexedHeader(HpackDecoder.decodeULE128(byteBuf, n3));
                    hpackDecoder$HeaderType = this.validate(hpackHeaderField.name, hpackDecoder$HeaderType, bl2);
                    l2 = this.addHeader(http2Headers, hpackHeaderField.name, hpackHeaderField.value, l2);
                    n6 = 0;
                    continue block28;
                }
                case 3: {
                    charSequence = this.readName(HpackDecoder.decodeULE128(byteBuf, n3));
                    hpackDecoder$HeaderType = this.validate(charSequence, hpackDecoder$HeaderType, bl2);
                    n4 = charSequence.length();
                    n6 = 7;
                    continue block28;
                }
                case 4: {
                    byte by2 = byteBuf.readByte();
                    bl3 = (by2 & 0x80) == 128;
                    n3 = by2 & 0x7F;
                    if (n3 == 127) {
                        n6 = 5;
                        continue block28;
                    }
                    if ((long)n3 > this.maxHeaderListSizeGoAway - l2) {
                        Http2CodecUtil.headerListSizeExceeded(this.maxHeaderListSizeGoAway);
                    }
                    n4 = n3;
                    n6 = 6;
                    continue block28;
                }
                case 5: {
                    n4 = HpackDecoder.decodeULE128(byteBuf, n3);
                    if ((long)n4 > this.maxHeaderListSizeGoAway - l2) {
                        Http2CodecUtil.headerListSizeExceeded(this.maxHeaderListSizeGoAway);
                    }
                    n6 = 6;
                    continue block28;
                }
                case 6: {
                    if (byteBuf.readableBytes() < n4) {
                        throw HpackDecoder.notEnoughDataException(byteBuf);
                    }
                    charSequence = this.readStringLiteral(byteBuf, n4, bl3);
                    hpackDecoder$HeaderType = this.validate(charSequence, hpackDecoder$HeaderType, bl2);
                    n6 = 7;
                    continue block28;
                }
                case 7: {
                    byte by2 = byteBuf.readByte();
                    bl3 = (by2 & 0x80) == 128;
                    n3 = by2 & 0x7F;
                    switch (n3) {
                        case 127: {
                            n6 = 8;
                            continue block28;
                        }
                        case 0: {
                            hpackDecoder$HeaderType = this.validate(charSequence, hpackDecoder$HeaderType, bl2);
                            l2 = this.insertHeader(http2Headers, charSequence, AsciiString.EMPTY_STRING, hpackUtil$IndexType, l2);
                            n6 = 0;
                            continue block28;
                        }
                    }
                    if ((long)n3 + (long)n4 > this.maxHeaderListSizeGoAway - l2) {
                        Http2CodecUtil.headerListSizeExceeded(this.maxHeaderListSizeGoAway);
                    }
                    n5 = n3;
                    n6 = 9;
                    continue block28;
                }
                case 8: {
                    n5 = HpackDecoder.decodeULE128(byteBuf, n3);
                    if ((long)n5 + (long)n4 > this.maxHeaderListSizeGoAway - l2) {
                        Http2CodecUtil.headerListSizeExceeded(this.maxHeaderListSizeGoAway);
                    }
                    n6 = 9;
                    continue block28;
                }
                case 9: {
                    if (byteBuf.readableBytes() < n5) {
                        throw HpackDecoder.notEnoughDataException(byteBuf);
                    }
                    CharSequence charSequence2 = this.readStringLiteral(byteBuf, n5, bl3);
                    hpackDecoder$HeaderType = this.validate(charSequence, hpackDecoder$HeaderType, bl2);
                    l2 = this.insertHeader(http2Headers, charSequence, charSequence2, hpackUtil$IndexType, l2);
                    n6 = 0;
                    continue block28;
                }
            }
            throw new Error("should not reach here state: " + n6);
        }
        if (l2 > this.maxHeaderListSize) {
            Http2CodecUtil.headerListSizeExceeded(n2, this.maxHeaderListSize, true);
        }
        if (n6 != 0) {
            throw Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, "Incomplete header block fragment.", new Object[0]);
        }
    }

    public void setMaxHeaderTableSize(long l2) {
        if (l2 < 0L || l2 > 0xFFFFFFFFL) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header Table Size must be >= %d and <= %d but was %d", 0L, 0xFFFFFFFFL, l2);
        }
        this.maxDynamicTableSize = l2;
        if (this.maxDynamicTableSize < this.encoderMaxDynamicTableSize) {
            this.maxDynamicTableSizeChangeRequired = true;
            this.hpackDynamicTable.setCapacity(this.maxDynamicTableSize);
        }
    }

    public void setMaxHeaderListSize(long l2, long l3) {
        if (l3 < l2 || l3 < 0L) {
            throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, "Header List Size GO_AWAY %d must be positive and >= %d", l3, l2);
        }
        if (l2 < 0L || l2 > 0xFFFFFFFFL) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header List Size must be >= %d and <= %d but was %d", 0L, 0xFFFFFFFFL, l2);
        }
        this.maxHeaderListSize = l2;
        this.maxHeaderListSizeGoAway = l3;
    }

    public long getMaxHeaderListSize() {
        return this.maxHeaderListSize;
    }

    public long getMaxHeaderListSizeGoAway() {
        return this.maxHeaderListSizeGoAway;
    }

    public long getMaxHeaderTableSize() {
        return this.hpackDynamicTable.capacity();
    }

    int length() {
        return this.hpackDynamicTable.length();
    }

    long size() {
        return this.hpackDynamicTable.size();
    }

    HpackHeaderField getHeaderField(int n2) {
        return this.hpackDynamicTable.getEntry(n2 + 1);
    }

    private void setDynamicTableSize(long l2) {
        if (l2 > this.maxDynamicTableSize) {
            throw INVALID_MAX_DYNAMIC_TABLE_SIZE;
        }
        this.encoderMaxDynamicTableSize = l2;
        this.maxDynamicTableSizeChangeRequired = false;
        this.hpackDynamicTable.setCapacity(l2);
    }

    private HpackDecoder$HeaderType validate(CharSequence charSequence, HpackDecoder$HeaderType hpackDecoder$HeaderType, boolean bl2) {
        if (!bl2) {
            return null;
        }
        if (Http2Headers$PseudoHeaderName.hasPseudoHeaderFormat(charSequence)) {
            HpackDecoder$HeaderType hpackDecoder$HeaderType2;
            if (hpackDecoder$HeaderType == HpackDecoder$HeaderType.REGULAR_HEADER) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Pseudo-header field '%s' found after regular header.", charSequence);
            }
            Http2Headers$PseudoHeaderName http2Headers$PseudoHeaderName = Http2Headers$PseudoHeaderName.getPseudoHeader(charSequence);
            if (http2Headers$PseudoHeaderName == null) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Invalid HTTP/2 pseudo-header '%s' encountered.", charSequence);
            }
            HpackDecoder$HeaderType hpackDecoder$HeaderType3 = hpackDecoder$HeaderType2 = http2Headers$PseudoHeaderName.isRequestOnly() ? HpackDecoder$HeaderType.REQUEST_PSEUDO_HEADER : HpackDecoder$HeaderType.RESPONSE_PSEUDO_HEADER;
            if (hpackDecoder$HeaderType != null && hpackDecoder$HeaderType2 != hpackDecoder$HeaderType) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Mix of request and response pseudo-headers.", new Object[0]);
            }
            return hpackDecoder$HeaderType2;
        }
        return HpackDecoder$HeaderType.REGULAR_HEADER;
    }

    private CharSequence readName(int n2) {
        if (n2 <= HpackStaticTable.length) {
            HpackHeaderField hpackHeaderField = HpackStaticTable.getEntry(n2);
            return hpackHeaderField.name;
        }
        if (n2 - HpackStaticTable.length <= this.hpackDynamicTable.length()) {
            HpackHeaderField hpackHeaderField = this.hpackDynamicTable.getEntry(n2 - HpackStaticTable.length);
            return hpackHeaderField.name;
        }
        throw READ_NAME_ILLEGAL_INDEX_VALUE;
    }

    private HpackHeaderField getIndexedHeader(int n2) {
        if (n2 <= HpackStaticTable.length) {
            return HpackStaticTable.getEntry(n2);
        }
        if (n2 - HpackStaticTable.length <= this.hpackDynamicTable.length()) {
            return this.hpackDynamicTable.getEntry(n2 - HpackStaticTable.length);
        }
        throw INDEX_HEADER_ILLEGAL_INDEX_VALUE;
    }

    private long insertHeader(Http2Headers http2Headers, CharSequence charSequence, CharSequence charSequence2, HpackUtil$IndexType hpackUtil$IndexType, long l2) {
        l2 = this.addHeader(http2Headers, charSequence, charSequence2, l2);
        switch (hpackUtil$IndexType) {
            case NONE: 
            case NEVER: {
                break;
            }
            case INCREMENTAL: {
                this.hpackDynamicTable.add(new HpackHeaderField(charSequence, charSequence2));
                break;
            }
            default: {
                throw new Error("should not reach here");
            }
        }
        return l2;
    }

    private long addHeader(Http2Headers http2Headers, CharSequence charSequence, CharSequence charSequence2, long l2) {
        if ((l2 += HpackHeaderField.sizeOf(charSequence, charSequence2)) > this.maxHeaderListSizeGoAway) {
            Http2CodecUtil.headerListSizeExceeded(this.maxHeaderListSizeGoAway);
        }
        http2Headers.add(charSequence, charSequence2);
        return l2;
    }

    private CharSequence readStringLiteral(ByteBuf byteBuf, int n2, boolean bl2) {
        if (bl2) {
            return this.hpackHuffmanDecoder.decode(byteBuf, n2);
        }
        byte[] byArray = new byte[n2];
        byteBuf.readBytes(byArray);
        return new AsciiString(byArray, false);
    }

    private static IllegalArgumentException notEnoughDataException(ByteBuf byteBuf) {
        return new IllegalArgumentException("decode only works with an entire header block! " + byteBuf);
    }

    static int decodeULE128(ByteBuf byteBuf, int n2) {
        int n3 = byteBuf.readerIndex();
        long l2 = HpackDecoder.decodeULE128(byteBuf, (long)n2);
        if (l2 > Integer.MAX_VALUE) {
            byteBuf.readerIndex(n3);
            throw DECODE_ULE_128_TO_INT_DECOMPRESSION_EXCEPTION;
        }
        return (int)l2;
    }

    static long decodeULE128(ByteBuf byteBuf, long l2) {
        assert (l2 <= 127L && l2 >= 0L);
        boolean bl2 = l2 == 0L;
        int n2 = byteBuf.writerIndex();
        int n3 = byteBuf.readerIndex();
        int n4 = 0;
        while (n3 < n2) {
            byte by2 = byteBuf.getByte(n3);
            if (n4 == 56 && ((by2 & 0x80) != 0 || by2 == 127 && !bl2)) {
                throw DECODE_ULE_128_TO_LONG_DECOMPRESSION_EXCEPTION;
            }
            if ((by2 & 0x80) == 0) {
                byteBuf.readerIndex(n3 + 1);
                return l2 + (((long)by2 & 0x7FL) << n4);
            }
            l2 += ((long)by2 & 0x7FL) << n4;
            ++n3;
            n4 += 7;
        }
        throw DECODE_ULE_128_DECOMPRESSION_EXCEPTION;
    }
}

