/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;

final class DelegatingDecompressorFrameListener$Http2Decompressor {
    private final EmbeddedChannel decompressor;
    private int compressed;
    private int decompressed;
    static final /* synthetic */ boolean $assertionsDisabled;

    DelegatingDecompressorFrameListener$Http2Decompressor(EmbeddedChannel embeddedChannel) {
        this.decompressor = embeddedChannel;
    }

    EmbeddedChannel decompressor() {
        return this.decompressor;
    }

    void incrementCompressedBytes(int n2) {
        if (!$assertionsDisabled && n2 < 0) {
            throw new AssertionError();
        }
        this.compressed += n2;
    }

    void incrementDecompressedBytes(int n2) {
        if (!$assertionsDisabled && n2 < 0) {
            throw new AssertionError();
        }
        this.decompressed += n2;
    }

    int consumeBytes(int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("decompressedBytes must not be negative: " + n3);
        }
        if (this.decompressed - n3 < 0) {
            throw Http2Exception.streamError(n2, Http2Error.INTERNAL_ERROR, "Attempting to return too many bytes for stream %d. decompressed: %d decompressedBytes: %d", n2, this.decompressed, n3);
        }
        double d2 = (double)n3 / (double)this.decompressed;
        int n4 = Math.min(this.compressed, (int)Math.ceil((double)this.compressed * d2));
        if (this.compressed - n4 < 0) {
            throw Http2Exception.streamError(n2, Http2Error.INTERNAL_ERROR, "overflow when converting decompressed bytes to compressed bytes for stream %d.decompressedBytes: %d decompressed: %d compressed: %d consumedCompressed: %d", n2, n3, this.decompressed, this.compressed, n4);
        }
        this.decompressed -= n3;
        this.compressed -= n4;
        return n4;
    }

    static {
        $assertionsDisabled = !DelegatingDecompressorFrameListener.class.desiredAssertionStatus();
    }
}

