/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.DefaultHttp2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2RemoteFlowController$FlowControlled;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.StreamByteDistributor$StreamState;
import java.util.ArrayDeque;
import java.util.Deque;

final class DefaultHttp2RemoteFlowController$FlowState
implements StreamByteDistributor$StreamState {
    private final Http2Stream stream;
    private final Deque<Http2RemoteFlowController$FlowControlled> pendingWriteQueue;
    private int window;
    private long pendingBytes;
    private boolean markedWritable;
    private boolean writing;
    private boolean cancelled;
    static final /* synthetic */ boolean $assertionsDisabled;
    final /* synthetic */ DefaultHttp2RemoteFlowController this$0;

    DefaultHttp2RemoteFlowController$FlowState(DefaultHttp2RemoteFlowController defaultHttp2RemoteFlowController, Http2Stream http2Stream) {
        this.this$0 = defaultHttp2RemoteFlowController;
        this.stream = http2Stream;
        this.pendingWriteQueue = new ArrayDeque<Http2RemoteFlowController$FlowControlled>(2);
    }

    boolean isWritable() {
        return (long)this.windowSize() > this.pendingBytes() && !this.cancelled;
    }

    @Override
    public Http2Stream stream() {
        return this.stream;
    }

    boolean markedWritability() {
        return this.markedWritable;
    }

    void markedWritability(boolean bl2) {
        this.markedWritable = bl2;
    }

    @Override
    public int windowSize() {
        return this.window;
    }

    void windowSize(int n2) {
        this.window = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int writeAllocatedBytes(int n2) {
        int n3;
        int n4 = n2;
        Throwable throwable = null;
        try {
            int n5;
            Http2RemoteFlowController$FlowControlled http2RemoteFlowController$FlowControlled;
            if (!$assertionsDisabled && this.writing) {
                throw new AssertionError();
            }
            this.writing = true;
            boolean bl2 = false;
            while (!(this.cancelled || (http2RemoteFlowController$FlowControlled = this.peek()) == null || (n5 = Math.min(n2, this.writableWindow())) <= 0 && http2RemoteFlowController$FlowControlled.size() > 0)) {
                bl2 = true;
                int n6 = http2RemoteFlowController$FlowControlled.size();
                try {
                    http2RemoteFlowController$FlowControlled.write(DefaultHttp2RemoteFlowController.access$500(this.this$0), Math.max(0, n5));
                    if (http2RemoteFlowController$FlowControlled.size() != 0) continue;
                    this.pendingWriteQueue.remove();
                    http2RemoteFlowController$FlowControlled.writeComplete();
                }
                finally {
                    n2 -= n6 - http2RemoteFlowController$FlowControlled.size();
                }
            }
            if (!bl2) {
                n5 = -1;
                return n5;
            }
        }
        catch (Throwable throwable2) {
            this.cancelled = true;
            throwable = throwable2;
        }
        finally {
            this.writing = false;
            int n7 = n4 - n2;
            this.decrementPendingBytes(n7, false);
            this.decrementFlowControlWindow(n7);
            if (this.cancelled) {
                this.cancel(Http2Error.INTERNAL_ERROR, throwable);
            }
        }
        return n3;
    }

    int incrementStreamWindow(int n2) {
        if (n2 > 0 && Integer.MAX_VALUE - n2 < this.window) {
            throw Http2Exception.streamError(this.stream.id(), Http2Error.FLOW_CONTROL_ERROR, "Window size overflow for stream: %d", this.stream.id());
        }
        this.window += n2;
        DefaultHttp2RemoteFlowController.access$600(this.this$0).updateStreamableBytes(this);
        return this.window;
    }

    private int writableWindow() {
        return Math.min(this.window, DefaultHttp2RemoteFlowController.access$700(this.this$0));
    }

    @Override
    public long pendingBytes() {
        return this.pendingBytes;
    }

    void enqueueFrame(Http2RemoteFlowController$FlowControlled http2RemoteFlowController$FlowControlled) {
        Http2RemoteFlowController$FlowControlled http2RemoteFlowController$FlowControlled2 = this.pendingWriteQueue.peekLast();
        if (http2RemoteFlowController$FlowControlled2 == null) {
            this.enqueueFrameWithoutMerge(http2RemoteFlowController$FlowControlled);
            return;
        }
        int n2 = http2RemoteFlowController$FlowControlled2.size();
        if (http2RemoteFlowController$FlowControlled2.merge(DefaultHttp2RemoteFlowController.access$500(this.this$0), http2RemoteFlowController$FlowControlled)) {
            this.incrementPendingBytes(http2RemoteFlowController$FlowControlled2.size() - n2, true);
            return;
        }
        this.enqueueFrameWithoutMerge(http2RemoteFlowController$FlowControlled);
    }

    private void enqueueFrameWithoutMerge(Http2RemoteFlowController$FlowControlled http2RemoteFlowController$FlowControlled) {
        this.pendingWriteQueue.offer(http2RemoteFlowController$FlowControlled);
        this.incrementPendingBytes(http2RemoteFlowController$FlowControlled.size(), true);
    }

    @Override
    public boolean hasFrame() {
        return !this.pendingWriteQueue.isEmpty();
    }

    private Http2RemoteFlowController$FlowControlled peek() {
        return this.pendingWriteQueue.peek();
    }

    void cancel(Http2Error http2Error, Throwable throwable) {
        this.cancelled = true;
        if (this.writing) {
            return;
        }
        Http2RemoteFlowController$FlowControlled http2RemoteFlowController$FlowControlled = this.pendingWriteQueue.poll();
        if (http2RemoteFlowController$FlowControlled != null) {
            Http2Exception http2Exception = Http2Exception.streamError(this.stream.id(), http2Error, throwable, "Stream closed before write could take place", new Object[0]);
            do {
                this.writeError(http2RemoteFlowController$FlowControlled, http2Exception);
            } while ((http2RemoteFlowController$FlowControlled = this.pendingWriteQueue.poll()) != null);
        }
        DefaultHttp2RemoteFlowController.access$600(this.this$0).updateStreamableBytes(this);
        DefaultHttp2RemoteFlowController.access$300(this.this$0).stateCancelled(this);
    }

    private void incrementPendingBytes(int n2, boolean bl2) {
        this.pendingBytes += (long)n2;
        DefaultHttp2RemoteFlowController.access$300(this.this$0).incrementPendingBytes(n2);
        if (bl2) {
            DefaultHttp2RemoteFlowController.access$600(this.this$0).updateStreamableBytes(this);
        }
    }

    private void decrementPendingBytes(int n2, boolean bl2) {
        this.incrementPendingBytes(-n2, bl2);
    }

    private void decrementFlowControlWindow(int n2) {
        try {
            int n3 = -n2;
            DefaultHttp2RemoteFlowController.access$800(this.this$0).incrementStreamWindow(n3);
            this.incrementStreamWindow(n3);
        }
        catch (Http2Exception http2Exception) {
            throw new IllegalStateException("Invalid window state when writing frame: " + http2Exception.getMessage(), http2Exception);
        }
    }

    private void writeError(Http2RemoteFlowController$FlowControlled http2RemoteFlowController$FlowControlled, Http2Exception http2Exception) {
        if (!$assertionsDisabled && DefaultHttp2RemoteFlowController.access$500(this.this$0) == null) {
            throw new AssertionError();
        }
        this.decrementPendingBytes(http2RemoteFlowController$FlowControlled.size(), true);
        http2RemoteFlowController$FlowControlled.error(DefaultHttp2RemoteFlowController.access$500(this.this$0), http2Exception);
    }

    static /* synthetic */ Http2Stream access$1300(DefaultHttp2RemoteFlowController$FlowState defaultHttp2RemoteFlowController$FlowState) {
        return defaultHttp2RemoteFlowController$FlowState.stream;
    }

    static {
        $assertionsDisabled = !DefaultHttp2RemoteFlowController.class.desiredAssertionStatus();
    }
}

