/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.Http2PingFrame;
import io.netty.util.internal.StringUtil;

public class DefaultHttp2PingFrame
implements Http2PingFrame {
    private final long content;
    private final boolean ack;

    public DefaultHttp2PingFrame(long l2) {
        this(l2, false);
    }

    DefaultHttp2PingFrame(long l2, boolean bl2) {
        this.content = l2;
        this.ack = bl2;
    }

    @Override
    public boolean ack() {
        return this.ack;
    }

    @Override
    public String name() {
        return "PING";
    }

    @Override
    public long content() {
        return this.content;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Http2PingFrame)) {
            return false;
        }
        Http2PingFrame http2PingFrame = (Http2PingFrame)object;
        return this.ack == http2PingFrame.ack() && this.content == http2PingFrame.content();
    }

    public int hashCode() {
        int n2 = super.hashCode();
        n2 = n2 * 31 + (this.ack ? 1 : 0);
        return n2;
    }

    public String toString() {
        return StringUtil.simpleClassName(this) + "(content=" + this.content + ", ack=" + this.ack + ')';
    }
}

