/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.DefaultHttp2LocalFlowController$1;
import io.netty.handler.codec.http2.DefaultHttp2LocalFlowController$2;
import io.netty.handler.codec.http2.DefaultHttp2LocalFlowController$AutoRefillState;
import io.netty.handler.codec.http2.DefaultHttp2LocalFlowController$DefaultState;
import io.netty.handler.codec.http2.DefaultHttp2LocalFlowController$FlowState;
import io.netty.handler.codec.http2.DefaultHttp2LocalFlowController$WindowUpdateVisitor;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Connection$PropertyKey;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2Stream$State;
import io.netty.util.internal.ObjectUtil;

public class DefaultHttp2LocalFlowController
implements Http2LocalFlowController {
    public static final float DEFAULT_WINDOW_UPDATE_RATIO = 0.5f;
    private final Http2Connection connection;
    private final Http2Connection$PropertyKey stateKey;
    private Http2FrameWriter frameWriter;
    private ChannelHandlerContext ctx;
    private float windowUpdateRatio;
    private int initialWindowSize = 65535;
    private static final DefaultHttp2LocalFlowController$FlowState REDUCED_FLOW_STATE = new DefaultHttp2LocalFlowController$2();

    public DefaultHttp2LocalFlowController(Http2Connection http2Connection) {
        this(http2Connection, 0.5f, false);
    }

    public DefaultHttp2LocalFlowController(Http2Connection http2Connection, float f2, boolean bl2) {
        this.connection = ObjectUtil.checkNotNull(http2Connection, "connection");
        this.windowUpdateRatio(f2);
        this.stateKey = http2Connection.newKey();
        DefaultHttp2LocalFlowController$DefaultState defaultHttp2LocalFlowController$DefaultState = bl2 ? new DefaultHttp2LocalFlowController$AutoRefillState(this, http2Connection.connectionStream(), this.initialWindowSize) : new DefaultHttp2LocalFlowController$DefaultState(this, http2Connection.connectionStream(), this.initialWindowSize);
        http2Connection.connectionStream().setProperty(this.stateKey, defaultHttp2LocalFlowController$DefaultState);
        http2Connection.addListener(new DefaultHttp2LocalFlowController$1(this));
    }

    @Override
    public DefaultHttp2LocalFlowController frameWriter(Http2FrameWriter http2FrameWriter) {
        this.frameWriter = ObjectUtil.checkNotNull(http2FrameWriter, "frameWriter");
        return this;
    }

    @Override
    public void channelHandlerContext(ChannelHandlerContext channelHandlerContext) {
        this.ctx = ObjectUtil.checkNotNull(channelHandlerContext, "ctx");
    }

    @Override
    public void initialWindowSize(int n2) {
        assert (this.ctx == null || this.ctx.executor().inEventLoop());
        int n3 = n2 - this.initialWindowSize;
        this.initialWindowSize = n2;
        DefaultHttp2LocalFlowController$WindowUpdateVisitor defaultHttp2LocalFlowController$WindowUpdateVisitor = new DefaultHttp2LocalFlowController$WindowUpdateVisitor(this, n3);
        this.connection.forEachActiveStream(defaultHttp2LocalFlowController$WindowUpdateVisitor);
        defaultHttp2LocalFlowController$WindowUpdateVisitor.throwIfError();
    }

    @Override
    public int initialWindowSize() {
        return this.initialWindowSize;
    }

    @Override
    public int windowSize(Http2Stream http2Stream) {
        return this.state(http2Stream).windowSize();
    }

    @Override
    public int initialWindowSize(Http2Stream http2Stream) {
        return this.state(http2Stream).initialWindowSize();
    }

    @Override
    public void incrementWindowSize(Http2Stream http2Stream, int n2) {
        assert (this.ctx != null && this.ctx.executor().inEventLoop());
        DefaultHttp2LocalFlowController$FlowState defaultHttp2LocalFlowController$FlowState = this.state(http2Stream);
        defaultHttp2LocalFlowController$FlowState.incrementInitialStreamWindow(n2);
        defaultHttp2LocalFlowController$FlowState.writeWindowUpdateIfNeeded();
    }

    @Override
    public boolean consumeBytes(Http2Stream http2Stream, int n2) {
        assert (this.ctx != null && this.ctx.executor().inEventLoop());
        if (n2 < 0) {
            throw new IllegalArgumentException("numBytes must not be negative");
        }
        if (n2 == 0) {
            return false;
        }
        if (http2Stream != null && !DefaultHttp2LocalFlowController.isClosed(http2Stream)) {
            if (http2Stream.id() == 0) {
                throw new UnsupportedOperationException("Returning bytes for the connection window is not supported");
            }
            boolean bl2 = this.connectionState().consumeBytes(n2);
            return bl2 |= this.state(http2Stream).consumeBytes(n2);
        }
        return false;
    }

    @Override
    public int unconsumedBytes(Http2Stream http2Stream) {
        return this.state(http2Stream).unconsumedBytes();
    }

    private static void checkValidRatio(float f2) {
        if (Double.compare(f2, 0.0) <= 0 || Double.compare(f2, 1.0) >= 0) {
            throw new IllegalArgumentException("Invalid ratio: " + f2);
        }
    }

    public void windowUpdateRatio(float f2) {
        assert (this.ctx == null || this.ctx.executor().inEventLoop());
        DefaultHttp2LocalFlowController.checkValidRatio(f2);
        this.windowUpdateRatio = f2;
    }

    public float windowUpdateRatio() {
        return this.windowUpdateRatio;
    }

    public void windowUpdateRatio(Http2Stream http2Stream, float f2) {
        assert (this.ctx != null && this.ctx.executor().inEventLoop());
        DefaultHttp2LocalFlowController.checkValidRatio(f2);
        DefaultHttp2LocalFlowController$FlowState defaultHttp2LocalFlowController$FlowState = this.state(http2Stream);
        defaultHttp2LocalFlowController$FlowState.windowUpdateRatio(f2);
        defaultHttp2LocalFlowController$FlowState.writeWindowUpdateIfNeeded();
    }

    public float windowUpdateRatio(Http2Stream http2Stream) {
        return this.state(http2Stream).windowUpdateRatio();
    }

    @Override
    public void receiveFlowControlledFrame(Http2Stream http2Stream, ByteBuf byteBuf, int n2, boolean bl2) {
        assert (this.ctx != null && this.ctx.executor().inEventLoop());
        int n3 = byteBuf.readableBytes() + n2;
        DefaultHttp2LocalFlowController$FlowState defaultHttp2LocalFlowController$FlowState = this.connectionState();
        defaultHttp2LocalFlowController$FlowState.receiveFlowControlledFrame(n3);
        if (http2Stream != null && !DefaultHttp2LocalFlowController.isClosed(http2Stream)) {
            DefaultHttp2LocalFlowController$FlowState defaultHttp2LocalFlowController$FlowState2 = this.state(http2Stream);
            defaultHttp2LocalFlowController$FlowState2.endOfStream(bl2);
            defaultHttp2LocalFlowController$FlowState2.receiveFlowControlledFrame(n3);
        } else if (n3 > 0) {
            defaultHttp2LocalFlowController$FlowState.consumeBytes(n3);
        }
    }

    private DefaultHttp2LocalFlowController$FlowState connectionState() {
        return (DefaultHttp2LocalFlowController$FlowState)this.connection.connectionStream().getProperty(this.stateKey);
    }

    private DefaultHttp2LocalFlowController$FlowState state(Http2Stream http2Stream) {
        return (DefaultHttp2LocalFlowController$FlowState)http2Stream.getProperty(this.stateKey);
    }

    private static boolean isClosed(Http2Stream http2Stream) {
        return http2Stream.state() == Http2Stream$State.CLOSED;
    }

    static /* synthetic */ Http2Connection$PropertyKey access$000(DefaultHttp2LocalFlowController defaultHttp2LocalFlowController) {
        return defaultHttp2LocalFlowController.stateKey;
    }

    static /* synthetic */ DefaultHttp2LocalFlowController$FlowState access$100() {
        return REDUCED_FLOW_STATE;
    }

    static /* synthetic */ int access$200(DefaultHttp2LocalFlowController defaultHttp2LocalFlowController) {
        return defaultHttp2LocalFlowController.initialWindowSize;
    }

    static /* synthetic */ DefaultHttp2LocalFlowController$FlowState access$300(DefaultHttp2LocalFlowController defaultHttp2LocalFlowController, Http2Stream http2Stream) {
        return defaultHttp2LocalFlowController.state(http2Stream);
    }

    static /* synthetic */ ChannelHandlerContext access$400(DefaultHttp2LocalFlowController defaultHttp2LocalFlowController) {
        return defaultHttp2LocalFlowController.ctx;
    }

    static /* synthetic */ DefaultHttp2LocalFlowController$FlowState access$500(DefaultHttp2LocalFlowController defaultHttp2LocalFlowController) {
        return defaultHttp2LocalFlowController.connectionState();
    }

    static /* synthetic */ float access$600(DefaultHttp2LocalFlowController defaultHttp2LocalFlowController) {
        return defaultHttp2LocalFlowController.windowUpdateRatio;
    }

    static /* synthetic */ Http2FrameWriter access$700(DefaultHttp2LocalFlowController defaultHttp2LocalFlowController) {
        return defaultHttp2LocalFlowController.frameWriter;
    }
}

