/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.DefaultHttp2LocalFlowController;
import io.netty.handler.codec.http2.DefaultHttp2LocalFlowController$FlowState;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Stream;

class DefaultHttp2LocalFlowController$DefaultState
implements DefaultHttp2LocalFlowController$FlowState {
    private final Http2Stream stream;
    private int window;
    private int processedWindow;
    private int initialStreamWindowSize;
    private float streamWindowUpdateRatio;
    private int lowerBound;
    private boolean endOfStream;
    static final /* synthetic */ boolean $assertionsDisabled;
    final /* synthetic */ DefaultHttp2LocalFlowController this$0;

    public DefaultHttp2LocalFlowController$DefaultState(DefaultHttp2LocalFlowController defaultHttp2LocalFlowController, Http2Stream http2Stream, int n2) {
        this.this$0 = defaultHttp2LocalFlowController;
        this.stream = http2Stream;
        this.window(n2);
        this.streamWindowUpdateRatio = DefaultHttp2LocalFlowController.access$600(defaultHttp2LocalFlowController);
    }

    @Override
    public void window(int n2) {
        if (!$assertionsDisabled && DefaultHttp2LocalFlowController.access$400(this.this$0) != null && !DefaultHttp2LocalFlowController.access$400(this.this$0).executor().inEventLoop()) {
            throw new AssertionError();
        }
        this.processedWindow = this.initialStreamWindowSize = n2;
        this.window = this.initialStreamWindowSize;
    }

    @Override
    public int windowSize() {
        return this.window;
    }

    @Override
    public int initialWindowSize() {
        return this.initialStreamWindowSize;
    }

    @Override
    public void endOfStream(boolean bl2) {
        this.endOfStream = bl2;
    }

    @Override
    public float windowUpdateRatio() {
        return this.streamWindowUpdateRatio;
    }

    @Override
    public void windowUpdateRatio(float f2) {
        if (!$assertionsDisabled && DefaultHttp2LocalFlowController.access$400(this.this$0) != null && !DefaultHttp2LocalFlowController.access$400(this.this$0).executor().inEventLoop()) {
            throw new AssertionError();
        }
        this.streamWindowUpdateRatio = f2;
    }

    @Override
    public void incrementInitialStreamWindow(int n2) {
        int n3 = (int)Math.min(Integer.MAX_VALUE, Math.max(0L, (long)this.initialStreamWindowSize + (long)n2));
        n2 = n3 - this.initialStreamWindowSize;
        this.initialStreamWindowSize += n2;
    }

    @Override
    public void incrementFlowControlWindows(int n2) {
        if (n2 > 0 && this.window > Integer.MAX_VALUE - n2) {
            throw Http2Exception.streamError(this.stream.id(), Http2Error.FLOW_CONTROL_ERROR, "Flow control window overflowed for stream: %d", this.stream.id());
        }
        this.window += n2;
        this.processedWindow += n2;
        this.lowerBound = n2 < 0 ? n2 : 0;
    }

    @Override
    public void receiveFlowControlledFrame(int n2) {
        if (!$assertionsDisabled && n2 < 0) {
            throw new AssertionError();
        }
        this.window -= n2;
        if (this.window < this.lowerBound) {
            throw Http2Exception.streamError(this.stream.id(), Http2Error.FLOW_CONTROL_ERROR, "Flow control window exceeded for stream: %d", this.stream.id());
        }
    }

    private void returnProcessedBytes(int n2) {
        if (this.processedWindow - n2 < this.window) {
            throw Http2Exception.streamError(this.stream.id(), Http2Error.INTERNAL_ERROR, "Attempting to return too many bytes for stream %d", this.stream.id());
        }
        this.processedWindow -= n2;
    }

    @Override
    public boolean consumeBytes(int n2) {
        this.returnProcessedBytes(n2);
        return this.writeWindowUpdateIfNeeded();
    }

    @Override
    public int unconsumedBytes() {
        return this.processedWindow - this.window;
    }

    @Override
    public boolean writeWindowUpdateIfNeeded() {
        if (this.endOfStream || this.initialStreamWindowSize <= 0) {
            return false;
        }
        int n2 = (int)((float)this.initialStreamWindowSize * this.streamWindowUpdateRatio);
        if (this.processedWindow <= n2) {
            this.writeWindowUpdate();
            return true;
        }
        return false;
    }

    private void writeWindowUpdate() {
        int n2 = this.initialStreamWindowSize - this.processedWindow;
        try {
            this.incrementFlowControlWindows(n2);
        }
        catch (Throwable throwable) {
            throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, throwable, "Attempting to return too many bytes for stream %d", this.stream.id());
        }
        DefaultHttp2LocalFlowController.access$700(this.this$0).writeWindowUpdate(DefaultHttp2LocalFlowController.access$400(this.this$0), this.stream.id(), n2, DefaultHttp2LocalFlowController.access$400(this.this$0).newPromise());
    }

    static {
        $assertionsDisabled = !DefaultHttp2LocalFlowController.class.desiredAssertionStatus();
    }
}

