/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http2.HpackEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.handler.codec.http2.Http2HeadersEncoder$Configuration;
import io.netty.handler.codec.http2.Http2HeadersEncoder$SensitivityDetector;
import io.netty.util.internal.ObjectUtil;

public class DefaultHttp2HeadersEncoder
implements Http2HeadersEncoder,
Http2HeadersEncoder$Configuration {
    private final HpackEncoder hpackEncoder;
    private final Http2HeadersEncoder$SensitivityDetector sensitivityDetector;
    private final ByteBuf tableSizeChangeOutput = Unpooled.buffer();

    public DefaultHttp2HeadersEncoder() {
        this(NEVER_SENSITIVE);
    }

    public DefaultHttp2HeadersEncoder(Http2HeadersEncoder$SensitivityDetector http2HeadersEncoder$SensitivityDetector) {
        this(http2HeadersEncoder$SensitivityDetector, new HpackEncoder());
    }

    public DefaultHttp2HeadersEncoder(Http2HeadersEncoder$SensitivityDetector http2HeadersEncoder$SensitivityDetector, boolean bl2) {
        this(http2HeadersEncoder$SensitivityDetector, new HpackEncoder(bl2));
    }

    public DefaultHttp2HeadersEncoder(Http2HeadersEncoder$SensitivityDetector http2HeadersEncoder$SensitivityDetector, boolean bl2, int n2) {
        this(http2HeadersEncoder$SensitivityDetector, new HpackEncoder(bl2, n2));
    }

    DefaultHttp2HeadersEncoder(Http2HeadersEncoder$SensitivityDetector http2HeadersEncoder$SensitivityDetector, HpackEncoder hpackEncoder) {
        this.sensitivityDetector = ObjectUtil.checkNotNull(http2HeadersEncoder$SensitivityDetector, "sensitiveDetector");
        this.hpackEncoder = ObjectUtil.checkNotNull(hpackEncoder, "hpackEncoder");
    }

    @Override
    public void encodeHeaders(int n2, Http2Headers http2Headers, ByteBuf byteBuf) {
        try {
            if (this.tableSizeChangeOutput.isReadable()) {
                byteBuf.writeBytes(this.tableSizeChangeOutput);
                this.tableSizeChangeOutput.clear();
            }
            this.hpackEncoder.encodeHeaders(n2, byteBuf, http2Headers, this.sensitivityDetector);
        }
        catch (Http2Exception http2Exception) {
            throw http2Exception;
        }
        catch (Throwable throwable) {
            throw Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, throwable, "Failed encoding headers block: %s", throwable.getMessage());
        }
    }

    @Override
    public void maxHeaderTableSize(long l2) {
        this.hpackEncoder.setMaxHeaderTableSize(this.tableSizeChangeOutput, l2);
    }

    @Override
    public long maxHeaderTableSize() {
        return this.hpackEncoder.getMaxHeaderTableSize();
    }

    @Override
    public void maxHeaderListSize(long l2) {
        this.hpackEncoder.setMaxHeaderListSize(l2);
    }

    @Override
    public long maxHeaderListSize() {
        return this.hpackEncoder.getMaxHeaderListSize();
    }

    @Override
    public Http2HeadersEncoder$Configuration configuration() {
        return this;
    }
}

