/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.DefaultHeaders$NameValidator;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.util.AsciiString;
import io.netty.util.internal.PlatformDependent;

final class DefaultHttp2Headers$2
implements DefaultHeaders$NameValidator<CharSequence> {
    DefaultHttp2Headers$2() {
    }

    @Override
    public void validateName(CharSequence charSequence) {
        if (charSequence == null || charSequence.length() == 0) {
            PlatformDependent.throwException(Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "empty headers are not allowed [%s]", charSequence));
        }
        if (charSequence instanceof AsciiString) {
            int n2;
            try {
                n2 = ((AsciiString)charSequence).forEachByte(DefaultHttp2Headers.access$000());
            }
            catch (Http2Exception http2Exception) {
                PlatformDependent.throwException(http2Exception);
                return;
            }
            catch (Throwable throwable) {
                PlatformDependent.throwException(Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, throwable, "unexpected error. invalid header name [%s]", charSequence));
                return;
            }
            if (n2 != -1) {
                PlatformDependent.throwException(Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "invalid header name [%s]", charSequence));
            }
        } else {
            for (int i2 = 0; i2 < charSequence.length(); ++i2) {
                if (!AsciiString.isUpperCase(charSequence.charAt(i2))) continue;
                PlatformDependent.throwException(Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "invalid header name [%s]", charSequence));
            }
        }
    }
}

