/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2HeadersEncoder;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2CodecUtil$SimpleChannelPromiseAggregator;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameSizePolicy;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2FrameWriter$Configuration;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.handler.codec.http2.Http2HeadersEncoder$Configuration;
import io.netty.handler.codec.http2.Http2HeadersEncoder$SensitivityDetector;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.util.ReferenceCounted;
import io.netty.util.collection.CharObjectMap$PrimitiveEntry;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;

public class DefaultHttp2FrameWriter
implements Http2FrameSizePolicy,
Http2FrameWriter,
Http2FrameWriter$Configuration {
    private static final String STREAM_ID = "Stream ID";
    private static final String STREAM_DEPENDENCY = "Stream Dependency";
    private static final ByteBuf ZERO_BUFFER = Unpooled.unreleasableBuffer(Unpooled.directBuffer(255).writeZero(255)).asReadOnly();
    private final Http2HeadersEncoder headersEncoder;
    private int maxFrameSize;

    public DefaultHttp2FrameWriter() {
        this(new DefaultHttp2HeadersEncoder());
    }

    public DefaultHttp2FrameWriter(Http2HeadersEncoder$SensitivityDetector http2HeadersEncoder$SensitivityDetector) {
        this(new DefaultHttp2HeadersEncoder(http2HeadersEncoder$SensitivityDetector));
    }

    public DefaultHttp2FrameWriter(Http2HeadersEncoder$SensitivityDetector http2HeadersEncoder$SensitivityDetector, boolean bl2) {
        this(new DefaultHttp2HeadersEncoder(http2HeadersEncoder$SensitivityDetector, bl2));
    }

    public DefaultHttp2FrameWriter(Http2HeadersEncoder http2HeadersEncoder) {
        this.headersEncoder = http2HeadersEncoder;
        this.maxFrameSize = 16384;
    }

    @Override
    public Http2FrameWriter$Configuration configuration() {
        return this;
    }

    @Override
    public Http2HeadersEncoder$Configuration headersConfiguration() {
        return this.headersEncoder.configuration();
    }

    @Override
    public Http2FrameSizePolicy frameSizePolicy() {
        return this;
    }

    @Override
    public void maxFrameSize(int n2) {
        if (!Http2CodecUtil.isMaxFrameSizeValid(n2)) {
            throw Http2Exception.connectionError(Http2Error.FRAME_SIZE_ERROR, "Invalid MAX_FRAME_SIZE specified in sent settings: %d", n2);
        }
        this.maxFrameSize = n2;
    }

    @Override
    public int maxFrameSize() {
        return this.maxFrameSize;
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelFuture writeData(ChannelHandlerContext channelHandlerContext, int n2, ByteBuf byteBuf, int n3, boolean bl2, ChannelPromise channelPromise) {
        Http2CodecUtil$SimpleChannelPromiseAggregator http2CodecUtil$SimpleChannelPromiseAggregator = new Http2CodecUtil$SimpleChannelPromiseAggregator(channelPromise, channelHandlerContext.channel(), channelHandlerContext.executor());
        ReferenceCounted referenceCounted = null;
        try {
            DefaultHttp2FrameWriter.verifyStreamId(n2, STREAM_ID);
            Http2CodecUtil.verifyPadding(n3);
            int n4 = byteBuf.readableBytes();
            Http2Flags http2Flags = new Http2Flags();
            http2Flags.endOfStream(false);
            http2Flags.paddingPresent(false);
            if (n4 > this.maxFrameSize) {
                referenceCounted = channelHandlerContext.alloc().buffer(9);
                Http2CodecUtil.writeFrameHeaderInternal((ByteBuf)referenceCounted, this.maxFrameSize, (byte)0, http2Flags, n2);
                do {
                    channelHandlerContext.write(((ByteBuf)referenceCounted).retainedSlice(), http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
                    channelHandlerContext.write(byteBuf.readRetainedSlice(this.maxFrameSize), http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
                } while ((n4 -= this.maxFrameSize) > this.maxFrameSize);
            }
            if (n3 == 0) {
                if (referenceCounted != null) {
                    referenceCounted.release();
                    referenceCounted = null;
                }
                ByteBuf byteBuf2 = channelHandlerContext.alloc().buffer(9);
                http2Flags.endOfStream(bl2);
                Http2CodecUtil.writeFrameHeaderInternal(byteBuf2, n4, (byte)0, http2Flags, n2);
                channelHandlerContext.write(byteBuf2, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
                ByteBuf byteBuf3 = byteBuf.readSlice(n4);
                byteBuf = null;
                channelHandlerContext.write(byteBuf3, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
            } else {
                if (n4 != this.maxFrameSize) {
                    if (referenceCounted != null) {
                        referenceCounted.release();
                        referenceCounted = null;
                    }
                } else {
                    ByteBuf byteBuf4;
                    n4 -= this.maxFrameSize;
                    if (referenceCounted == null) {
                        byteBuf4 = channelHandlerContext.alloc().buffer(9);
                        Http2CodecUtil.writeFrameHeaderInternal(byteBuf4, this.maxFrameSize, (byte)0, http2Flags, n2);
                    } else {
                        byteBuf4 = ((ByteBuf)referenceCounted).slice();
                        referenceCounted = null;
                    }
                    channelHandlerContext.write(byteBuf4, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
                    byteBuf4 = byteBuf.readSlice(this.maxFrameSize);
                    byteBuf = null;
                    channelHandlerContext.write(byteBuf4, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
                }
                do {
                    int n5 = Math.min(n4, this.maxFrameSize);
                    int n6 = Math.min(n3, Math.max(0, this.maxFrameSize - 1 - n5));
                    ByteBuf byteBuf5 = channelHandlerContext.alloc().buffer(10);
                    http2Flags.endOfStream(bl2 && (n4 -= n5) == 0 && (n3 -= n6) == 0);
                    http2Flags.paddingPresent(n6 > 0);
                    Http2CodecUtil.writeFrameHeaderInternal(byteBuf5, n6 + n5, (byte)0, http2Flags, n2);
                    DefaultHttp2FrameWriter.writePaddingLength(byteBuf5, n6);
                    channelHandlerContext.write(byteBuf5, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
                    if (n5 != 0) {
                        if (n4 == 0) {
                            ByteBuf byteBuf6 = byteBuf.readSlice(n5);
                            byteBuf = null;
                            channelHandlerContext.write(byteBuf6, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
                        } else {
                            channelHandlerContext.write(byteBuf.readRetainedSlice(n5), http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
                        }
                    }
                    if (DefaultHttp2FrameWriter.paddingBytes(n6) <= 0) continue;
                    channelHandlerContext.write(ZERO_BUFFER.slice(0, DefaultHttp2FrameWriter.paddingBytes(n6)), http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
                } while (n4 != 0 || n3 != 0);
            }
        }
        catch (Throwable throwable) {
            if (referenceCounted != null) {
                referenceCounted.release();
            }
            try {
                if (byteBuf != null) {
                    byteBuf.release();
                }
            }
            finally {
                http2CodecUtil$SimpleChannelPromiseAggregator.setFailure(throwable);
                http2CodecUtil$SimpleChannelPromiseAggregator.doneAllocatingPromises();
            }
            return http2CodecUtil$SimpleChannelPromiseAggregator;
        }
        return http2CodecUtil$SimpleChannelPromiseAggregator.doneAllocatingPromises();
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext channelHandlerContext, int n2, Http2Headers http2Headers, int n3, boolean bl2, ChannelPromise channelPromise) {
        return this.writeHeadersInternal(channelHandlerContext, n2, http2Headers, n3, bl2, false, 0, (short)0, false, channelPromise);
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext channelHandlerContext, int n2, Http2Headers http2Headers, int n3, short s2, boolean bl2, int n4, boolean bl3, ChannelPromise channelPromise) {
        return this.writeHeadersInternal(channelHandlerContext, n2, http2Headers, n4, bl3, true, n3, s2, bl2, channelPromise);
    }

    @Override
    public ChannelFuture writePriority(ChannelHandlerContext channelHandlerContext, int n2, int n3, short s2, boolean bl2, ChannelPromise channelPromise) {
        try {
            DefaultHttp2FrameWriter.verifyStreamId(n2, STREAM_ID);
            DefaultHttp2FrameWriter.verifyStreamId(n3, STREAM_DEPENDENCY);
            DefaultHttp2FrameWriter.verifyWeight(s2);
            ByteBuf byteBuf = channelHandlerContext.alloc().buffer(14);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf, 5, (byte)2, new Http2Flags(), n2);
            byteBuf.writeInt(bl2 ? (int)(0x80000000L | (long)n3) : n3);
            byteBuf.writeByte(s2 - 1);
            return channelHandlerContext.write(byteBuf, channelPromise);
        }
        catch (Throwable throwable) {
            return channelPromise.setFailure(throwable);
        }
    }

    @Override
    public ChannelFuture writeRstStream(ChannelHandlerContext channelHandlerContext, int n2, long l2, ChannelPromise channelPromise) {
        try {
            DefaultHttp2FrameWriter.verifyStreamId(n2, STREAM_ID);
            DefaultHttp2FrameWriter.verifyErrorCode(l2);
            ByteBuf byteBuf = channelHandlerContext.alloc().buffer(13);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf, 4, (byte)3, new Http2Flags(), n2);
            byteBuf.writeInt((int)l2);
            return channelHandlerContext.write(byteBuf, channelPromise);
        }
        catch (Throwable throwable) {
            return channelPromise.setFailure(throwable);
        }
    }

    @Override
    public ChannelFuture writeSettings(ChannelHandlerContext channelHandlerContext, Http2Settings http2Settings, ChannelPromise channelPromise) {
        try {
            ObjectUtil.checkNotNull(http2Settings, "settings");
            int n2 = 6 * http2Settings.size();
            ByteBuf byteBuf = channelHandlerContext.alloc().buffer(9 + http2Settings.size() * 6);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf, n2, (byte)4, new Http2Flags(), 0);
            for (CharObjectMap$PrimitiveEntry charObjectMap$PrimitiveEntry : http2Settings.entries()) {
                byteBuf.writeChar(charObjectMap$PrimitiveEntry.key());
                byteBuf.writeInt(((Long)charObjectMap$PrimitiveEntry.value()).intValue());
            }
            return channelHandlerContext.write(byteBuf, channelPromise);
        }
        catch (Throwable throwable) {
            return channelPromise.setFailure(throwable);
        }
    }

    @Override
    public ChannelFuture writeSettingsAck(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        try {
            ByteBuf byteBuf = channelHandlerContext.alloc().buffer(9);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf, 0, (byte)4, new Http2Flags().ack(true), 0);
            return channelHandlerContext.write(byteBuf, channelPromise);
        }
        catch (Throwable throwable) {
            return channelPromise.setFailure(throwable);
        }
    }

    @Override
    public ChannelFuture writePing(ChannelHandlerContext channelHandlerContext, boolean bl2, long l2, ChannelPromise channelPromise) {
        Http2Flags http2Flags = bl2 ? new Http2Flags().ack(true) : new Http2Flags();
        ByteBuf byteBuf = channelHandlerContext.alloc().buffer(17);
        Http2CodecUtil.writeFrameHeaderInternal(byteBuf, 8, (byte)6, http2Flags, 0);
        byteBuf.writeLong(l2);
        return channelHandlerContext.write(byteBuf, channelPromise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelFuture writePushPromise(ChannelHandlerContext channelHandlerContext, int n2, int n3, Http2Headers http2Headers, int n4, ChannelPromise channelPromise) {
        ReferenceCounted referenceCounted = null;
        Http2CodecUtil$SimpleChannelPromiseAggregator http2CodecUtil$SimpleChannelPromiseAggregator = new Http2CodecUtil$SimpleChannelPromiseAggregator(channelPromise, channelHandlerContext.channel(), channelHandlerContext.executor());
        try {
            DefaultHttp2FrameWriter.verifyStreamId(n2, STREAM_ID);
            DefaultHttp2FrameWriter.verifyStreamId(n3, "Promised Stream ID");
            Http2CodecUtil.verifyPadding(n4);
            referenceCounted = channelHandlerContext.alloc().buffer();
            this.headersEncoder.encodeHeaders(n2, http2Headers, (ByteBuf)referenceCounted);
            Http2Flags http2Flags = new Http2Flags().paddingPresent(n4 > 0);
            int n5 = 4 + n4;
            int n6 = this.maxFrameSize - n5;
            ByteBuf byteBuf = ((ByteBuf)referenceCounted).readRetainedSlice(Math.min(((ByteBuf)referenceCounted).readableBytes(), n6));
            http2Flags.endOfHeaders(!((ByteBuf)referenceCounted).isReadable());
            int n7 = byteBuf.readableBytes() + n5;
            ByteBuf byteBuf2 = channelHandlerContext.alloc().buffer(14);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf2, n7, (byte)5, http2Flags, n2);
            DefaultHttp2FrameWriter.writePaddingLength(byteBuf2, n4);
            byteBuf2.writeInt(n3);
            channelHandlerContext.write(byteBuf2, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
            channelHandlerContext.write(byteBuf, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
            if (DefaultHttp2FrameWriter.paddingBytes(n4) > 0) {
                channelHandlerContext.write(ZERO_BUFFER.slice(0, DefaultHttp2FrameWriter.paddingBytes(n4)), http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
            }
            if (!http2Flags.endOfHeaders()) {
                this.writeContinuationFrames(channelHandlerContext, n2, (ByteBuf)referenceCounted, n4, http2CodecUtil$SimpleChannelPromiseAggregator);
            }
        }
        catch (Http2Exception http2Exception) {
            http2CodecUtil$SimpleChannelPromiseAggregator.setFailure(http2Exception);
        }
        catch (Throwable throwable) {
            http2CodecUtil$SimpleChannelPromiseAggregator.setFailure(throwable);
            http2CodecUtil$SimpleChannelPromiseAggregator.doneAllocatingPromises();
            PlatformDependent.throwException(throwable);
        }
        finally {
            if (referenceCounted != null) {
                referenceCounted.release();
            }
        }
        return http2CodecUtil$SimpleChannelPromiseAggregator.doneAllocatingPromises();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelFuture writeGoAway(ChannelHandlerContext channelHandlerContext, int n2, long l2, ByteBuf byteBuf, ChannelPromise channelPromise) {
        Http2CodecUtil$SimpleChannelPromiseAggregator http2CodecUtil$SimpleChannelPromiseAggregator = new Http2CodecUtil$SimpleChannelPromiseAggregator(channelPromise, channelHandlerContext.channel(), channelHandlerContext.executor());
        try {
            DefaultHttp2FrameWriter.verifyStreamOrConnectionId(n2, "Last Stream ID");
            DefaultHttp2FrameWriter.verifyErrorCode(l2);
            int n3 = 8 + byteBuf.readableBytes();
            ByteBuf byteBuf2 = channelHandlerContext.alloc().buffer(17);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf2, n3, (byte)7, new Http2Flags(), 0);
            byteBuf2.writeInt(n2);
            byteBuf2.writeInt((int)l2);
            channelHandlerContext.write(byteBuf2, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
        }
        catch (Throwable throwable) {
            try {
                byteBuf.release();
            }
            finally {
                http2CodecUtil$SimpleChannelPromiseAggregator.setFailure(throwable);
                http2CodecUtil$SimpleChannelPromiseAggregator.doneAllocatingPromises();
            }
            return http2CodecUtil$SimpleChannelPromiseAggregator;
        }
        try {
            channelHandlerContext.write(byteBuf, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
        }
        catch (Throwable throwable) {
            http2CodecUtil$SimpleChannelPromiseAggregator.setFailure(throwable);
        }
        return http2CodecUtil$SimpleChannelPromiseAggregator.doneAllocatingPromises();
    }

    @Override
    public ChannelFuture writeWindowUpdate(ChannelHandlerContext channelHandlerContext, int n2, int n3, ChannelPromise channelPromise) {
        try {
            DefaultHttp2FrameWriter.verifyStreamOrConnectionId(n2, STREAM_ID);
            DefaultHttp2FrameWriter.verifyWindowSizeIncrement(n3);
            ByteBuf byteBuf = channelHandlerContext.alloc().buffer(13);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf, 4, (byte)8, new Http2Flags(), n2);
            byteBuf.writeInt(n3);
            return channelHandlerContext.write(byteBuf, channelPromise);
        }
        catch (Throwable throwable) {
            return channelPromise.setFailure(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelFuture writeFrame(ChannelHandlerContext channelHandlerContext, byte by2, int n2, Http2Flags http2Flags, ByteBuf byteBuf, ChannelPromise channelPromise) {
        Http2CodecUtil$SimpleChannelPromiseAggregator http2CodecUtil$SimpleChannelPromiseAggregator = new Http2CodecUtil$SimpleChannelPromiseAggregator(channelPromise, channelHandlerContext.channel(), channelHandlerContext.executor());
        try {
            DefaultHttp2FrameWriter.verifyStreamOrConnectionId(n2, STREAM_ID);
            ByteBuf byteBuf2 = channelHandlerContext.alloc().buffer(9);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf2, byteBuf.readableBytes(), by2, http2Flags, n2);
            channelHandlerContext.write(byteBuf2, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
        }
        catch (Throwable throwable) {
            try {
                byteBuf.release();
            }
            finally {
                http2CodecUtil$SimpleChannelPromiseAggregator.setFailure(throwable);
                http2CodecUtil$SimpleChannelPromiseAggregator.doneAllocatingPromises();
            }
            return http2CodecUtil$SimpleChannelPromiseAggregator;
        }
        try {
            channelHandlerContext.write(byteBuf, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
        }
        catch (Throwable throwable) {
            http2CodecUtil$SimpleChannelPromiseAggregator.setFailure(throwable);
        }
        return http2CodecUtil$SimpleChannelPromiseAggregator.doneAllocatingPromises();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelFuture writeHeadersInternal(ChannelHandlerContext channelHandlerContext, int n2, Http2Headers http2Headers, int n3, boolean bl2, boolean bl3, int n4, short s2, boolean bl4, ChannelPromise channelPromise) {
        ReferenceCounted referenceCounted = null;
        Http2CodecUtil$SimpleChannelPromiseAggregator http2CodecUtil$SimpleChannelPromiseAggregator = new Http2CodecUtil$SimpleChannelPromiseAggregator(channelPromise, channelHandlerContext.channel(), channelHandlerContext.executor());
        try {
            DefaultHttp2FrameWriter.verifyStreamId(n2, STREAM_ID);
            if (bl3) {
                DefaultHttp2FrameWriter.verifyStreamOrConnectionId(n4, STREAM_DEPENDENCY);
                Http2CodecUtil.verifyPadding(n3);
                DefaultHttp2FrameWriter.verifyWeight(s2);
            }
            referenceCounted = channelHandlerContext.alloc().buffer();
            this.headersEncoder.encodeHeaders(n2, http2Headers, (ByteBuf)referenceCounted);
            Http2Flags http2Flags = new Http2Flags().endOfStream(bl2).priorityPresent(bl3).paddingPresent(n3 > 0);
            int n5 = n3 + http2Flags.getNumPriorityBytes();
            int n6 = this.maxFrameSize - n5;
            ByteBuf byteBuf = ((ByteBuf)referenceCounted).readRetainedSlice(Math.min(((ByteBuf)referenceCounted).readableBytes(), n6));
            http2Flags.endOfHeaders(!((ByteBuf)referenceCounted).isReadable());
            int n7 = byteBuf.readableBytes() + n5;
            ByteBuf byteBuf2 = channelHandlerContext.alloc().buffer(15);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf2, n7, (byte)1, http2Flags, n2);
            DefaultHttp2FrameWriter.writePaddingLength(byteBuf2, n3);
            if (bl3) {
                byteBuf2.writeInt(bl4 ? (int)(0x80000000L | (long)n4) : n4);
                byteBuf2.writeByte(s2 - 1);
            }
            channelHandlerContext.write(byteBuf2, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
            channelHandlerContext.write(byteBuf, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
            if (DefaultHttp2FrameWriter.paddingBytes(n3) > 0) {
                channelHandlerContext.write(ZERO_BUFFER.slice(0, DefaultHttp2FrameWriter.paddingBytes(n3)), http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
            }
            if (!http2Flags.endOfHeaders()) {
                this.writeContinuationFrames(channelHandlerContext, n2, (ByteBuf)referenceCounted, n3, http2CodecUtil$SimpleChannelPromiseAggregator);
            }
        }
        catch (Http2Exception http2Exception) {
            http2CodecUtil$SimpleChannelPromiseAggregator.setFailure(http2Exception);
        }
        catch (Throwable throwable) {
            http2CodecUtil$SimpleChannelPromiseAggregator.setFailure(throwable);
            http2CodecUtil$SimpleChannelPromiseAggregator.doneAllocatingPromises();
            PlatformDependent.throwException(throwable);
        }
        finally {
            if (referenceCounted != null) {
                referenceCounted.release();
            }
        }
        return http2CodecUtil$SimpleChannelPromiseAggregator.doneAllocatingPromises();
    }

    private ChannelFuture writeContinuationFrames(ChannelHandlerContext channelHandlerContext, int n2, ByteBuf byteBuf, int n3, Http2CodecUtil$SimpleChannelPromiseAggregator http2CodecUtil$SimpleChannelPromiseAggregator) {
        Http2Flags http2Flags = new Http2Flags().paddingPresent(n3 > 0);
        int n4 = this.maxFrameSize - n3;
        if (n4 <= 0) {
            return http2CodecUtil$SimpleChannelPromiseAggregator.setFailure(new IllegalArgumentException("Padding [" + n3 + "] is too large for max frame size [" + this.maxFrameSize + "]"));
        }
        if (byteBuf.isReadable()) {
            int n5 = Math.min(byteBuf.readableBytes(), n4);
            int n6 = n5 + n3;
            ByteBuf byteBuf2 = channelHandlerContext.alloc().buffer(10);
            Http2CodecUtil.writeFrameHeaderInternal(byteBuf2, n6, (byte)9, http2Flags, n2);
            DefaultHttp2FrameWriter.writePaddingLength(byteBuf2, n3);
            do {
                n5 = Math.min(byteBuf.readableBytes(), n4);
                ByteBuf byteBuf3 = byteBuf.readRetainedSlice(n5);
                n6 = n5 + n3;
                if (byteBuf.isReadable()) {
                    channelHandlerContext.write(byteBuf2.retain(), http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
                } else {
                    http2Flags = http2Flags.endOfHeaders(true);
                    byteBuf2.release();
                    byteBuf2 = channelHandlerContext.alloc().buffer(10);
                    Http2CodecUtil.writeFrameHeaderInternal(byteBuf2, n6, (byte)9, http2Flags, n2);
                    DefaultHttp2FrameWriter.writePaddingLength(byteBuf2, n3);
                    channelHandlerContext.write(byteBuf2, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
                }
                channelHandlerContext.write(byteBuf3, http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
                if (DefaultHttp2FrameWriter.paddingBytes(n3) <= 0) continue;
                channelHandlerContext.write(ZERO_BUFFER.slice(0, DefaultHttp2FrameWriter.paddingBytes(n3)), http2CodecUtil$SimpleChannelPromiseAggregator.newPromise());
            } while (byteBuf.isReadable());
        }
        return http2CodecUtil$SimpleChannelPromiseAggregator;
    }

    private static int paddingBytes(int n2) {
        return n2 - 1;
    }

    private static void writePaddingLength(ByteBuf byteBuf, int n2) {
        if (n2 > 0) {
            byteBuf.writeByte(n2 - 1);
        }
    }

    private static void verifyStreamId(int n2, String string) {
        if (n2 <= 0) {
            throw new IllegalArgumentException(string + " must be > 0");
        }
    }

    private static void verifyStreamOrConnectionId(int n2, String string) {
        if (n2 < 0) {
            throw new IllegalArgumentException(string + " must be >= 0");
        }
    }

    private static void verifyWeight(short s2) {
        if (s2 < 1 || s2 > 256) {
            throw new IllegalArgumentException("Invalid weight: " + s2);
        }
    }

    private static void verifyErrorCode(long l2) {
        if (l2 < 0L || l2 > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Invalid errorCode: " + l2);
        }
    }

    private static void verifyWindowSizeIncrement(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("WindowSizeIncrement must be >= 0");
        }
    }

    private static void verifyPingPayload(ByteBuf byteBuf) {
        if (byteBuf == null || byteBuf.readableBytes() != 8) {
            throw new IllegalArgumentException("Opaque data must be 8 bytes");
        }
    }
}

