/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader$1;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader$2;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader$3;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader$HeadersContinuation;
import io.netty.handler.codec.http2.DefaultHttp2HeadersDecoder;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameReader$Configuration;
import io.netty.handler.codec.http2.Http2FrameSizePolicy;
import io.netty.handler.codec.http2.Http2HeadersDecoder;
import io.netty.handler.codec.http2.Http2HeadersDecoder$Configuration;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.util.internal.PlatformDependent;

public class DefaultHttp2FrameReader
implements Http2FrameReader,
Http2FrameReader$Configuration,
Http2FrameSizePolicy {
    private final Http2HeadersDecoder headersDecoder;
    private boolean readingHeaders = true;
    private boolean readError;
    private byte frameType;
    private int streamId;
    private Http2Flags flags;
    private int payloadLength;
    private DefaultHttp2FrameReader$HeadersContinuation headersContinuation;
    private int maxFrameSize;

    public DefaultHttp2FrameReader() {
        this(true);
    }

    public DefaultHttp2FrameReader(boolean bl2) {
        this(new DefaultHttp2HeadersDecoder(bl2));
    }

    public DefaultHttp2FrameReader(Http2HeadersDecoder http2HeadersDecoder) {
        this.headersDecoder = http2HeadersDecoder;
        this.maxFrameSize = 16384;
    }

    @Override
    public Http2HeadersDecoder$Configuration headersConfiguration() {
        return this.headersDecoder.configuration();
    }

    @Override
    public Http2FrameReader$Configuration configuration() {
        return this;
    }

    @Override
    public Http2FrameSizePolicy frameSizePolicy() {
        return this;
    }

    @Override
    public void maxFrameSize(int n2) {
        if (!Http2CodecUtil.isMaxFrameSizeValid(n2)) {
            throw Http2Exception.streamError(this.streamId, Http2Error.FRAME_SIZE_ERROR, "Invalid MAX_FRAME_SIZE specified in sent settings: %d", n2);
        }
        this.maxFrameSize = n2;
    }

    @Override
    public int maxFrameSize() {
        return this.maxFrameSize;
    }

    @Override
    public void close() {
        this.closeHeadersContinuation();
    }

    private void closeHeadersContinuation() {
        if (this.headersContinuation != null) {
            this.headersContinuation.close();
            this.headersContinuation = null;
        }
    }

    @Override
    public void readFrame(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, Http2FrameListener http2FrameListener) {
        if (this.readError) {
            byteBuf.skipBytes(byteBuf.readableBytes());
            return;
        }
        try {
            do {
                if (this.readingHeaders) {
                    this.processHeaderState(byteBuf);
                    if (this.readingHeaders) {
                        return;
                    }
                }
                this.processPayloadState(channelHandlerContext, byteBuf, http2FrameListener);
                if (this.readingHeaders) continue;
                return;
            } while (byteBuf.isReadable());
        }
        catch (Http2Exception http2Exception) {
            this.readError = !Http2Exception.isStreamError(http2Exception);
            throw http2Exception;
        }
        catch (RuntimeException runtimeException) {
            this.readError = true;
            throw runtimeException;
        }
        catch (Throwable throwable) {
            this.readError = true;
            PlatformDependent.throwException(throwable);
        }
    }

    private void processHeaderState(ByteBuf byteBuf) {
        if (byteBuf.readableBytes() < 9) {
            return;
        }
        this.payloadLength = byteBuf.readUnsignedMedium();
        if (this.payloadLength > this.maxFrameSize) {
            throw Http2Exception.connectionError(Http2Error.FRAME_SIZE_ERROR, "Frame length: %d exceeds maximum: %d", this.payloadLength, this.maxFrameSize);
        }
        this.frameType = byteBuf.readByte();
        this.flags = new Http2Flags(byteBuf.readUnsignedByte());
        this.streamId = Http2CodecUtil.readUnsignedInt(byteBuf);
        this.readingHeaders = false;
        switch (this.frameType) {
            case 0: {
                this.verifyDataFrame();
                break;
            }
            case 1: {
                this.verifyHeadersFrame();
                break;
            }
            case 2: {
                this.verifyPriorityFrame();
                break;
            }
            case 3: {
                this.verifyRstStreamFrame();
                break;
            }
            case 4: {
                this.verifySettingsFrame();
                break;
            }
            case 5: {
                this.verifyPushPromiseFrame();
                break;
            }
            case 6: {
                this.verifyPingFrame();
                break;
            }
            case 7: {
                this.verifyGoAwayFrame();
                break;
            }
            case 8: {
                this.verifyWindowUpdateFrame();
                break;
            }
            case 9: {
                this.verifyContinuationFrame();
                break;
            }
            default: {
                this.verifyUnknownFrame();
            }
        }
    }

    private void processPayloadState(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, Http2FrameListener http2FrameListener) {
        if (byteBuf.readableBytes() < this.payloadLength) {
            return;
        }
        ByteBuf byteBuf2 = byteBuf.readSlice(this.payloadLength);
        this.readingHeaders = true;
        switch (this.frameType) {
            case 0: {
                this.readDataFrame(channelHandlerContext, byteBuf2, http2FrameListener);
                break;
            }
            case 1: {
                this.readHeadersFrame(channelHandlerContext, byteBuf2, http2FrameListener);
                break;
            }
            case 2: {
                this.readPriorityFrame(channelHandlerContext, byteBuf2, http2FrameListener);
                break;
            }
            case 3: {
                this.readRstStreamFrame(channelHandlerContext, byteBuf2, http2FrameListener);
                break;
            }
            case 4: {
                this.readSettingsFrame(channelHandlerContext, byteBuf2, http2FrameListener);
                break;
            }
            case 5: {
                this.readPushPromiseFrame(channelHandlerContext, byteBuf2, http2FrameListener);
                break;
            }
            case 6: {
                this.readPingFrame(channelHandlerContext, byteBuf2.readLong(), http2FrameListener);
                break;
            }
            case 7: {
                DefaultHttp2FrameReader.readGoAwayFrame(channelHandlerContext, byteBuf2, http2FrameListener);
                break;
            }
            case 8: {
                this.readWindowUpdateFrame(channelHandlerContext, byteBuf2, http2FrameListener);
                break;
            }
            case 9: {
                this.readContinuationFrame(byteBuf2, http2FrameListener);
                break;
            }
            default: {
                this.readUnknownFrame(channelHandlerContext, byteBuf2, http2FrameListener);
            }
        }
    }

    private void verifyDataFrame() {
        this.verifyAssociatedWithAStream();
        this.verifyNotProcessingHeaders();
        this.verifyPayloadLength(this.payloadLength);
        if (this.payloadLength < this.flags.getPaddingPresenceFieldLength()) {
            throw Http2Exception.streamError(this.streamId, Http2Error.FRAME_SIZE_ERROR, "Frame length %d too small.", this.payloadLength);
        }
    }

    private void verifyHeadersFrame() {
        this.verifyAssociatedWithAStream();
        this.verifyNotProcessingHeaders();
        this.verifyPayloadLength(this.payloadLength);
        int n2 = this.flags.getPaddingPresenceFieldLength() + this.flags.getNumPriorityBytes();
        if (this.payloadLength < n2) {
            throw Http2Exception.streamError(this.streamId, Http2Error.FRAME_SIZE_ERROR, "Frame length too small." + this.payloadLength, new Object[0]);
        }
    }

    private void verifyPriorityFrame() {
        this.verifyAssociatedWithAStream();
        this.verifyNotProcessingHeaders();
        if (this.payloadLength != 5) {
            throw Http2Exception.streamError(this.streamId, Http2Error.FRAME_SIZE_ERROR, "Invalid frame length %d.", this.payloadLength);
        }
    }

    private void verifyRstStreamFrame() {
        this.verifyAssociatedWithAStream();
        this.verifyNotProcessingHeaders();
        if (this.payloadLength != 4) {
            throw Http2Exception.connectionError(Http2Error.FRAME_SIZE_ERROR, "Invalid frame length %d.", this.payloadLength);
        }
    }

    private void verifySettingsFrame() {
        this.verifyNotProcessingHeaders();
        this.verifyPayloadLength(this.payloadLength);
        if (this.streamId != 0) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "A stream ID must be zero.", new Object[0]);
        }
        if (this.flags.ack() && this.payloadLength > 0) {
            throw Http2Exception.connectionError(Http2Error.FRAME_SIZE_ERROR, "Ack settings frame must have an empty payload.", new Object[0]);
        }
        if (this.payloadLength % 6 > 0) {
            throw Http2Exception.connectionError(Http2Error.FRAME_SIZE_ERROR, "Frame length %d invalid.", this.payloadLength);
        }
    }

    private void verifyPushPromiseFrame() {
        this.verifyNotProcessingHeaders();
        this.verifyPayloadLength(this.payloadLength);
        int n2 = this.flags.getPaddingPresenceFieldLength() + 4;
        if (this.payloadLength < n2) {
            throw Http2Exception.streamError(this.streamId, Http2Error.FRAME_SIZE_ERROR, "Frame length %d too small.", this.payloadLength);
        }
    }

    private void verifyPingFrame() {
        this.verifyNotProcessingHeaders();
        if (this.streamId != 0) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "A stream ID must be zero.", new Object[0]);
        }
        if (this.payloadLength != 8) {
            throw Http2Exception.connectionError(Http2Error.FRAME_SIZE_ERROR, "Frame length %d incorrect size for ping.", this.payloadLength);
        }
    }

    private void verifyGoAwayFrame() {
        this.verifyNotProcessingHeaders();
        this.verifyPayloadLength(this.payloadLength);
        if (this.streamId != 0) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "A stream ID must be zero.", new Object[0]);
        }
        if (this.payloadLength < 8) {
            throw Http2Exception.connectionError(Http2Error.FRAME_SIZE_ERROR, "Frame length %d too small.", this.payloadLength);
        }
    }

    private void verifyWindowUpdateFrame() {
        this.verifyNotProcessingHeaders();
        DefaultHttp2FrameReader.verifyStreamOrConnectionId(this.streamId, "Stream ID");
        if (this.payloadLength != 4) {
            throw Http2Exception.connectionError(Http2Error.FRAME_SIZE_ERROR, "Invalid frame length %d.", this.payloadLength);
        }
    }

    private void verifyContinuationFrame() {
        this.verifyAssociatedWithAStream();
        this.verifyPayloadLength(this.payloadLength);
        if (this.headersContinuation == null) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Received %s frame but not currently processing headers.", this.frameType);
        }
        if (this.streamId != this.headersContinuation.getStreamId()) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Continuation stream ID does not match pending headers. Expected %d, but received %d.", this.headersContinuation.getStreamId(), this.streamId);
        }
        if (this.payloadLength < this.flags.getPaddingPresenceFieldLength()) {
            throw Http2Exception.streamError(this.streamId, Http2Error.FRAME_SIZE_ERROR, "Frame length %d too small for padding.", this.payloadLength);
        }
    }

    private void verifyUnknownFrame() {
        this.verifyNotProcessingHeaders();
    }

    private void readDataFrame(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, Http2FrameListener http2FrameListener) {
        int n2 = this.readPadding(byteBuf);
        this.verifyPadding(n2);
        int n3 = DefaultHttp2FrameReader.lengthWithoutTrailingPadding(byteBuf.readableBytes(), n2);
        ByteBuf byteBuf2 = byteBuf.readSlice(n3);
        http2FrameListener.onDataRead(channelHandlerContext, this.streamId, byteBuf2, n2, this.flags.endOfStream());
        byteBuf.skipBytes(byteBuf.readableBytes());
    }

    private void readHeadersFrame(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, Http2FrameListener http2FrameListener) {
        int n2 = this.streamId;
        Http2Flags http2Flags = this.flags;
        int n3 = this.readPadding(byteBuf);
        this.verifyPadding(n3);
        if (this.flags.priorityPresent()) {
            long l2 = byteBuf.readUnsignedInt();
            boolean bl2 = (l2 & 0x80000000L) != 0L;
            int n4 = (int)(l2 & Integer.MAX_VALUE);
            if (n4 == this.streamId) {
                throw Http2Exception.streamError(this.streamId, Http2Error.PROTOCOL_ERROR, "A stream cannot depend on itself.", new Object[0]);
            }
            short s2 = (short)(byteBuf.readUnsignedByte() + 1);
            ByteBuf byteBuf2 = byteBuf.readSlice(DefaultHttp2FrameReader.lengthWithoutTrailingPadding(byteBuf.readableBytes(), n3));
            this.headersContinuation = new DefaultHttp2FrameReader$1(this, n2, channelHandlerContext, n4, s2, bl2, n3, http2Flags);
            this.headersContinuation.processFragment(this.flags.endOfHeaders(), byteBuf2, http2FrameListener);
            this.resetHeadersContinuationIfEnd(this.flags.endOfHeaders());
            return;
        }
        this.headersContinuation = new DefaultHttp2FrameReader$2(this, n2, channelHandlerContext, n3, http2Flags);
        ByteBuf byteBuf3 = byteBuf.readSlice(DefaultHttp2FrameReader.lengthWithoutTrailingPadding(byteBuf.readableBytes(), n3));
        this.headersContinuation.processFragment(this.flags.endOfHeaders(), byteBuf3, http2FrameListener);
        this.resetHeadersContinuationIfEnd(this.flags.endOfHeaders());
    }

    private void resetHeadersContinuationIfEnd(boolean bl2) {
        if (bl2) {
            this.closeHeadersContinuation();
        }
    }

    private void readPriorityFrame(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, Http2FrameListener http2FrameListener) {
        long l2 = byteBuf.readUnsignedInt();
        boolean bl2 = (l2 & 0x80000000L) != 0L;
        int n2 = (int)(l2 & Integer.MAX_VALUE);
        if (n2 == this.streamId) {
            throw Http2Exception.streamError(this.streamId, Http2Error.PROTOCOL_ERROR, "A stream cannot depend on itself.", new Object[0]);
        }
        short s2 = (short)(byteBuf.readUnsignedByte() + 1);
        http2FrameListener.onPriorityRead(channelHandlerContext, this.streamId, n2, s2, bl2);
    }

    private void readRstStreamFrame(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, Http2FrameListener http2FrameListener) {
        long l2 = byteBuf.readUnsignedInt();
        http2FrameListener.onRstStreamRead(channelHandlerContext, this.streamId, l2);
    }

    private void readSettingsFrame(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, Http2FrameListener http2FrameListener) {
        if (this.flags.ack()) {
            http2FrameListener.onSettingsAckRead(channelHandlerContext);
        } else {
            int n2 = this.payloadLength / 6;
            Http2Settings http2Settings = new Http2Settings();
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = (char)byteBuf.readUnsignedShort();
                long l2 = byteBuf.readUnsignedInt();
                try {
                    http2Settings.put(c2, l2);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    switch (c2) {
                        case '\u0005': {
                            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, illegalArgumentException, illegalArgumentException.getMessage(), new Object[0]);
                        }
                        case '\u0004': {
                            throw Http2Exception.connectionError(Http2Error.FLOW_CONTROL_ERROR, illegalArgumentException, illegalArgumentException.getMessage(), new Object[0]);
                        }
                    }
                    throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, illegalArgumentException, illegalArgumentException.getMessage(), new Object[0]);
                }
            }
            http2FrameListener.onSettingsRead(channelHandlerContext, http2Settings);
        }
    }

    private void readPushPromiseFrame(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, Http2FrameListener http2FrameListener) {
        int n2 = this.streamId;
        int n3 = this.readPadding(byteBuf);
        this.verifyPadding(n3);
        int n4 = Http2CodecUtil.readUnsignedInt(byteBuf);
        this.headersContinuation = new DefaultHttp2FrameReader$3(this, n2, channelHandlerContext, n4, n3);
        ByteBuf byteBuf2 = byteBuf.readSlice(DefaultHttp2FrameReader.lengthWithoutTrailingPadding(byteBuf.readableBytes(), n3));
        this.headersContinuation.processFragment(this.flags.endOfHeaders(), byteBuf2, http2FrameListener);
        this.resetHeadersContinuationIfEnd(this.flags.endOfHeaders());
    }

    private void readPingFrame(ChannelHandlerContext channelHandlerContext, long l2, Http2FrameListener http2FrameListener) {
        if (this.flags.ack()) {
            http2FrameListener.onPingAckRead(channelHandlerContext, l2);
        } else {
            http2FrameListener.onPingRead(channelHandlerContext, l2);
        }
    }

    private static void readGoAwayFrame(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, Http2FrameListener http2FrameListener) {
        int n2 = Http2CodecUtil.readUnsignedInt(byteBuf);
        long l2 = byteBuf.readUnsignedInt();
        ByteBuf byteBuf2 = byteBuf.readSlice(byteBuf.readableBytes());
        http2FrameListener.onGoAwayRead(channelHandlerContext, n2, l2, byteBuf2);
    }

    private void readWindowUpdateFrame(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, Http2FrameListener http2FrameListener) {
        int n2 = Http2CodecUtil.readUnsignedInt(byteBuf);
        if (n2 == 0) {
            throw Http2Exception.streamError(this.streamId, Http2Error.PROTOCOL_ERROR, "Received WINDOW_UPDATE with delta 0 for stream: %d", this.streamId);
        }
        http2FrameListener.onWindowUpdateRead(channelHandlerContext, this.streamId, n2);
    }

    private void readContinuationFrame(ByteBuf byteBuf, Http2FrameListener http2FrameListener) {
        ByteBuf byteBuf2 = byteBuf.readSlice(byteBuf.readableBytes());
        this.headersContinuation.processFragment(this.flags.endOfHeaders(), byteBuf2, http2FrameListener);
        this.resetHeadersContinuationIfEnd(this.flags.endOfHeaders());
    }

    private void readUnknownFrame(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, Http2FrameListener http2FrameListener) {
        byteBuf = byteBuf.readSlice(byteBuf.readableBytes());
        http2FrameListener.onUnknownFrame(channelHandlerContext, this.frameType, this.streamId, this.flags, byteBuf);
    }

    private int readPadding(ByteBuf byteBuf) {
        if (!this.flags.paddingPresent()) {
            return 0;
        }
        return byteBuf.readUnsignedByte() + 1;
    }

    private void verifyPadding(int n2) {
        int n3 = DefaultHttp2FrameReader.lengthWithoutTrailingPadding(this.payloadLength, n2);
        if (n3 < 0) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Frame payload too small for padding.", new Object[0]);
        }
    }

    private static int lengthWithoutTrailingPadding(int n2, int n3) {
        return n3 == 0 ? n2 : n2 - (n3 - 1);
    }

    private void verifyNotProcessingHeaders() {
        if (this.headersContinuation != null) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Received frame of type %s while processing headers on stream %d.", this.frameType, this.headersContinuation.getStreamId());
        }
    }

    private void verifyPayloadLength(int n2) {
        if (n2 > this.maxFrameSize) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Total payload length %d exceeds max frame length.", n2);
        }
    }

    private void verifyAssociatedWithAStream() {
        if (this.streamId == 0) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Frame of type %s must be associated with a stream.", this.frameType);
        }
    }

    private static void verifyStreamOrConnectionId(int n2, String string) {
        if (n2 < 0) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "%s must be >= 0", string);
        }
    }

    static /* synthetic */ Http2HeadersDecoder access$100(DefaultHttp2FrameReader defaultHttp2FrameReader) {
        return defaultHttp2FrameReader.headersDecoder;
    }

    static /* synthetic */ int access$200(DefaultHttp2FrameReader defaultHttp2FrameReader) {
        return defaultHttp2FrameReader.streamId;
    }

    static /* synthetic */ DefaultHttp2FrameReader$HeadersContinuation access$302(DefaultHttp2FrameReader defaultHttp2FrameReader, DefaultHttp2FrameReader$HeadersContinuation defaultHttp2FrameReader$HeadersContinuation) {
        defaultHttp2FrameReader.headersContinuation = defaultHttp2FrameReader$HeadersContinuation;
        return defaultHttp2FrameReader.headersContinuation;
    }
}

