/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http2.AbstractHttp2StreamFrame;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;

public final class DefaultHttp2DataFrame
extends AbstractHttp2StreamFrame
implements Http2DataFrame {
    private final ByteBuf content;
    private final boolean endStream;
    private final int padding;
    private final int initialFlowControlledBytes;

    public DefaultHttp2DataFrame(ByteBuf byteBuf) {
        this(byteBuf, false);
    }

    public DefaultHttp2DataFrame(boolean bl2) {
        this(Unpooled.EMPTY_BUFFER, bl2);
    }

    public DefaultHttp2DataFrame(ByteBuf byteBuf, boolean bl2) {
        this(byteBuf, bl2, 0);
    }

    public DefaultHttp2DataFrame(ByteBuf byteBuf, boolean bl2, int n2) {
        this.content = ObjectUtil.checkNotNull(byteBuf, "content");
        this.endStream = bl2;
        Http2CodecUtil.verifyPadding(n2);
        this.padding = n2;
        if ((long)this.content().readableBytes() + (long)n2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("content + padding must be <= Integer.MAX_VALUE");
        }
        this.initialFlowControlledBytes = this.content().readableBytes() + n2;
    }

    @Override
    public DefaultHttp2DataFrame stream(Http2FrameStream http2FrameStream) {
        super.stream(http2FrameStream);
        return this;
    }

    @Override
    public String name() {
        return "DATA";
    }

    @Override
    public boolean isEndStream() {
        return this.endStream;
    }

    @Override
    public int padding() {
        return this.padding;
    }

    @Override
    public ByteBuf content() {
        if (this.content.refCnt() <= 0) {
            throw new IllegalReferenceCountException(this.content.refCnt());
        }
        return this.content;
    }

    @Override
    public int initialFlowControlledBytes() {
        return this.initialFlowControlledBytes;
    }

    @Override
    public DefaultHttp2DataFrame copy() {
        return this.replace(this.content().copy());
    }

    @Override
    public DefaultHttp2DataFrame duplicate() {
        return this.replace(this.content().duplicate());
    }

    @Override
    public DefaultHttp2DataFrame retainedDuplicate() {
        return this.replace(this.content().retainedDuplicate());
    }

    @Override
    public DefaultHttp2DataFrame replace(ByteBuf byteBuf) {
        return new DefaultHttp2DataFrame(byteBuf, this.endStream, this.padding);
    }

    @Override
    public int refCnt() {
        return this.content.refCnt();
    }

    @Override
    public boolean release() {
        return this.content.release();
    }

    @Override
    public boolean release(int n2) {
        return this.content.release(n2);
    }

    @Override
    public DefaultHttp2DataFrame retain() {
        this.content.retain();
        return this;
    }

    @Override
    public DefaultHttp2DataFrame retain(int n2) {
        this.content.retain(n2);
        return this;
    }

    public String toString() {
        return StringUtil.simpleClassName(this) + "(stream=" + this.stream() + ", content=" + this.content + ", endStream=" + this.endStream + ", padding=" + this.padding + ')';
    }

    @Override
    public DefaultHttp2DataFrame touch() {
        this.content.touch();
        return this;
    }

    @Override
    public DefaultHttp2DataFrame touch(Object object) {
        this.content.touch(object);
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DefaultHttp2DataFrame)) {
            return false;
        }
        DefaultHttp2DataFrame defaultHttp2DataFrame = (DefaultHttp2DataFrame)object;
        return super.equals(defaultHttp2DataFrame) && this.content.equals(defaultHttp2DataFrame.content()) && this.endStream == defaultHttp2DataFrame.endStream && this.padding == defaultHttp2DataFrame.padding;
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        n2 = n2 * 31 + this.content.hashCode();
        n2 = n2 * 31 + (this.endStream ? 0 : 1);
        n2 = n2 * 31 + this.padding;
        return n2;
    }
}

