/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder$1;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder$2;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder$FlowControlledData;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder$FlowControlledHeaders;
import io.netty.handler.codec.http2.DefaultHttp2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameSizePolicy;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2FrameWriter$Configuration;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersEncoder$Configuration;
import io.netty.handler.codec.http2.Http2LifecycleManager;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayDeque;

public class DefaultHttp2ConnectionEncoder
implements Http2ConnectionEncoder {
    private final Http2FrameWriter frameWriter;
    private final Http2Connection connection;
    private Http2LifecycleManager lifecycleManager;
    private final ArrayDeque<Http2Settings> outstandingLocalSettingsQueue = new ArrayDeque(4);

    public DefaultHttp2ConnectionEncoder(Http2Connection http2Connection, Http2FrameWriter http2FrameWriter) {
        this.connection = ObjectUtil.checkNotNull(http2Connection, "connection");
        this.frameWriter = ObjectUtil.checkNotNull(http2FrameWriter, "frameWriter");
        if (http2Connection.remote().flowController() == null) {
            http2Connection.remote().flowController(new DefaultHttp2RemoteFlowController(http2Connection));
        }
    }

    @Override
    public void lifecycleManager(Http2LifecycleManager http2LifecycleManager) {
        this.lifecycleManager = ObjectUtil.checkNotNull(http2LifecycleManager, "lifecycleManager");
    }

    @Override
    public Http2FrameWriter frameWriter() {
        return this.frameWriter;
    }

    @Override
    public Http2Connection connection() {
        return this.connection;
    }

    @Override
    public final Http2RemoteFlowController flowController() {
        return this.connection().remote().flowController();
    }

    @Override
    public void remoteSettings(Http2Settings http2Settings) {
        Integer n2;
        Integer n3;
        Long l2;
        Long l3;
        Long l4;
        Boolean bl2 = http2Settings.pushEnabled();
        Http2FrameWriter$Configuration http2FrameWriter$Configuration = this.configuration();
        Http2HeadersEncoder$Configuration http2HeadersEncoder$Configuration = http2FrameWriter$Configuration.headersConfiguration();
        Http2FrameSizePolicy http2FrameSizePolicy = http2FrameWriter$Configuration.frameSizePolicy();
        if (bl2 != null) {
            if (!this.connection.isServer() && bl2.booleanValue()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Client received a value of ENABLE_PUSH specified to other than 0", new Object[0]);
            }
            this.connection.remote().allowPushTo(bl2);
        }
        if ((l4 = http2Settings.maxConcurrentStreams()) != null) {
            this.connection.local().maxActiveStreams((int)Math.min(l4, Integer.MAX_VALUE));
        }
        if ((l3 = http2Settings.headerTableSize()) != null) {
            http2HeadersEncoder$Configuration.maxHeaderTableSize((int)Math.min(l3, Integer.MAX_VALUE));
        }
        if ((l2 = http2Settings.maxHeaderListSize()) != null) {
            http2HeadersEncoder$Configuration.maxHeaderListSize(l2);
        }
        if ((n3 = http2Settings.maxFrameSize()) != null) {
            http2FrameSizePolicy.maxFrameSize(n3);
        }
        if ((n2 = http2Settings.initialWindowSize()) != null) {
            this.flowController().initialWindowSize(n2);
        }
    }

    @Override
    public ChannelFuture writeData(ChannelHandlerContext channelHandlerContext, int n2, ByteBuf byteBuf, int n3, boolean bl2, ChannelPromise channelPromise) {
        Http2Stream http2Stream;
        try {
            http2Stream = this.requireStream(n2);
            switch (http2Stream.state()) {
                case OPEN: 
                case HALF_CLOSED_REMOTE: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Stream " + http2Stream.id() + " in unexpected state " + (Object)((Object)http2Stream.state()));
                }
            }
        }
        catch (Throwable throwable) {
            byteBuf.release();
            return channelPromise.setFailure(throwable);
        }
        this.flowController().addFlowControlled(http2Stream, new DefaultHttp2ConnectionEncoder$FlowControlledData(this, http2Stream, byteBuf, n3, bl2, channelPromise));
        return channelPromise;
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext channelHandlerContext, int n2, Http2Headers http2Headers, int n3, boolean bl2, ChannelPromise channelPromise) {
        return this.writeHeaders(channelHandlerContext, n2, http2Headers, 0, (short)16, false, n3, bl2, channelPromise);
    }

    private static boolean validateHeadersSentState(Http2Stream http2Stream, Http2Headers http2Headers, boolean bl2, boolean bl3) {
        boolean bl4;
        boolean bl5 = bl4 = bl2 && HttpStatusClass.valueOf(http2Headers.status()) == HttpStatusClass.INFORMATIONAL;
        if ((bl4 || !bl3) && http2Stream.isHeadersSent() || http2Stream.isTrailersSent()) {
            throw new IllegalStateException("Stream " + http2Stream.id() + " sent too many headers EOS: " + bl3);
        }
        return bl4;
    }

    @Override
    public ChannelFuture writeHeaders(ChannelHandlerContext channelHandlerContext, int n2, Http2Headers http2Headers, int n3, short s2, boolean bl2, int n4, boolean bl3, ChannelPromise channelPromise) {
        try {
            Http2Stream http2Stream = this.connection.stream(n2);
            if (http2Stream == null) {
                try {
                    http2Stream = this.connection.local().createStream(n2, bl3);
                }
                catch (Http2Exception http2Exception) {
                    if (this.connection.remote().mayHaveCreatedStream(n2)) {
                        channelPromise.tryFailure(new IllegalStateException("Stream no longer exists: " + n2, http2Exception));
                        return channelPromise;
                    }
                    throw http2Exception;
                }
            } else {
                switch (http2Stream.state()) {
                    case RESERVED_LOCAL: {
                        http2Stream.open(bl3);
                        break;
                    }
                    case OPEN: 
                    case HALF_CLOSED_REMOTE: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Stream " + http2Stream.id() + " in unexpected state " + (Object)((Object)http2Stream.state()));
                    }
                }
            }
            Http2RemoteFlowController http2RemoteFlowController = this.flowController();
            if (!bl3 || !http2RemoteFlowController.hasFlowControlled(http2Stream)) {
                Object object;
                Object object2;
                boolean bl4 = DefaultHttp2ConnectionEncoder.validateHeadersSentState(http2Stream, http2Headers, this.connection.isServer(), bl3);
                if (bl3) {
                    object2 = http2Stream;
                    object = new DefaultHttp2ConnectionEncoder$1(this, (Http2Stream)object2);
                    channelPromise = channelPromise.unvoid().addListener((GenericFutureListener<? extends Future<? super Void>>)object);
                }
                if ((object = (object2 = this.frameWriter.writeHeaders(channelHandlerContext, n2, http2Headers, n3, s2, bl2, n4, bl3, channelPromise)).cause()) == null) {
                    http2Stream.headersSent(bl4);
                    if (!object2.isSuccess()) {
                        this.notifyLifecycleManagerOnError((ChannelFuture)object2, channelHandlerContext);
                    }
                } else {
                    this.lifecycleManager.onError(channelHandlerContext, true, (Throwable)object);
                }
                return object2;
            }
            http2RemoteFlowController.addFlowControlled(http2Stream, new DefaultHttp2ConnectionEncoder$FlowControlledHeaders(this, http2Stream, http2Headers, n3, s2, bl2, n4, true, channelPromise));
            return channelPromise;
        }
        catch (Throwable throwable) {
            this.lifecycleManager.onError(channelHandlerContext, true, throwable);
            channelPromise.tryFailure(throwable);
            return channelPromise;
        }
    }

    @Override
    public ChannelFuture writePriority(ChannelHandlerContext channelHandlerContext, int n2, int n3, short s2, boolean bl2, ChannelPromise channelPromise) {
        return this.frameWriter.writePriority(channelHandlerContext, n2, n3, s2, bl2, channelPromise);
    }

    @Override
    public ChannelFuture writeRstStream(ChannelHandlerContext channelHandlerContext, int n2, long l2, ChannelPromise channelPromise) {
        return this.lifecycleManager.resetStream(channelHandlerContext, n2, l2, channelPromise);
    }

    @Override
    public ChannelFuture writeSettings(ChannelHandlerContext channelHandlerContext, Http2Settings http2Settings, ChannelPromise channelPromise) {
        this.outstandingLocalSettingsQueue.add(http2Settings);
        try {
            Boolean bl2 = http2Settings.pushEnabled();
            if (bl2 != null && this.connection.isServer()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Server sending SETTINGS frame with ENABLE_PUSH specified", new Object[0]);
            }
        }
        catch (Throwable throwable) {
            return channelPromise.setFailure(throwable);
        }
        return this.frameWriter.writeSettings(channelHandlerContext, http2Settings, channelPromise);
    }

    @Override
    public ChannelFuture writeSettingsAck(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        return this.frameWriter.writeSettingsAck(channelHandlerContext, channelPromise);
    }

    @Override
    public ChannelFuture writePing(ChannelHandlerContext channelHandlerContext, boolean bl2, long l2, ChannelPromise channelPromise) {
        return this.frameWriter.writePing(channelHandlerContext, bl2, l2, channelPromise);
    }

    @Override
    public ChannelFuture writePushPromise(ChannelHandlerContext channelHandlerContext, int n2, int n3, Http2Headers http2Headers, int n4, ChannelPromise channelPromise) {
        try {
            if (this.connection.goAwayReceived()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Sending PUSH_PROMISE after GO_AWAY received.", new Object[0]);
            }
            Http2Stream http2Stream = this.requireStream(n2);
            this.connection.local().reservePushStream(n3, http2Stream);
            ChannelFuture channelFuture = this.frameWriter.writePushPromise(channelHandlerContext, n2, n3, http2Headers, n4, channelPromise);
            Throwable throwable = channelFuture.cause();
            if (throwable == null) {
                http2Stream.pushPromiseSent();
                if (!channelFuture.isSuccess()) {
                    this.notifyLifecycleManagerOnError(channelFuture, channelHandlerContext);
                }
            } else {
                this.lifecycleManager.onError(channelHandlerContext, true, throwable);
            }
            return channelFuture;
        }
        catch (Throwable throwable) {
            this.lifecycleManager.onError(channelHandlerContext, true, throwable);
            channelPromise.tryFailure(throwable);
            return channelPromise;
        }
    }

    @Override
    public ChannelFuture writeGoAway(ChannelHandlerContext channelHandlerContext, int n2, long l2, ByteBuf byteBuf, ChannelPromise channelPromise) {
        return this.lifecycleManager.goAway(channelHandlerContext, n2, l2, byteBuf, channelPromise);
    }

    @Override
    public ChannelFuture writeWindowUpdate(ChannelHandlerContext channelHandlerContext, int n2, int n3, ChannelPromise channelPromise) {
        return channelPromise.setFailure(new UnsupportedOperationException("Use the Http2[Inbound|Outbound]FlowController objects to control window sizes"));
    }

    @Override
    public ChannelFuture writeFrame(ChannelHandlerContext channelHandlerContext, byte by2, int n2, Http2Flags http2Flags, ByteBuf byteBuf, ChannelPromise channelPromise) {
        return this.frameWriter.writeFrame(channelHandlerContext, by2, n2, http2Flags, byteBuf, channelPromise);
    }

    @Override
    public void close() {
        this.frameWriter.close();
    }

    @Override
    public Http2Settings pollSentSettings() {
        return this.outstandingLocalSettingsQueue.poll();
    }

    @Override
    public Http2FrameWriter$Configuration configuration() {
        return this.frameWriter.configuration();
    }

    private Http2Stream requireStream(int n2) {
        Http2Stream http2Stream = this.connection.stream(n2);
        if (http2Stream == null) {
            String string = this.connection.streamMayHaveExisted(n2) ? "Stream no longer exists: " + n2 : "Stream does not exist: " + n2;
            throw new IllegalArgumentException(string);
        }
        return http2Stream;
    }

    private void notifyLifecycleManagerOnError(ChannelFuture channelFuture, ChannelHandlerContext channelHandlerContext) {
        channelFuture.addListener(new DefaultHttp2ConnectionEncoder$2(this, channelHandlerContext));
    }

    static /* synthetic */ Http2LifecycleManager access$000(DefaultHttp2ConnectionEncoder defaultHttp2ConnectionEncoder) {
        return defaultHttp2ConnectionEncoder.lifecycleManager;
    }

    static /* synthetic */ Http2Connection access$100(DefaultHttp2ConnectionEncoder defaultHttp2ConnectionEncoder) {
        return defaultHttp2ConnectionEncoder.connection;
    }

    static /* synthetic */ boolean access$200(Http2Stream http2Stream, Http2Headers http2Headers, boolean bl2, boolean bl3) {
        return DefaultHttp2ConnectionEncoder.validateHeadersSentState(http2Stream, http2Headers, bl2, bl3);
    }

    static /* synthetic */ Http2FrameWriter access$300(DefaultHttp2ConnectionEncoder defaultHttp2ConnectionEncoder) {
        return defaultHttp2ConnectionEncoder.frameWriter;
    }
}

