/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.CoalescingBufferQueue;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder$FlowControlledBase;
import io.netty.handler.codec.http2.Http2RemoteFlowController$FlowControlled;
import io.netty.handler.codec.http2.Http2Stream;

final class DefaultHttp2ConnectionEncoder$FlowControlledData
extends DefaultHttp2ConnectionEncoder$FlowControlledBase {
    private final CoalescingBufferQueue queue;
    private int dataSize;
    final /* synthetic */ DefaultHttp2ConnectionEncoder this$0;

    DefaultHttp2ConnectionEncoder$FlowControlledData(DefaultHttp2ConnectionEncoder defaultHttp2ConnectionEncoder, Http2Stream http2Stream, ByteBuf byteBuf, int n2, boolean bl2, ChannelPromise channelPromise) {
        this.this$0 = defaultHttp2ConnectionEncoder;
        super(defaultHttp2ConnectionEncoder, http2Stream, n2, bl2, channelPromise);
        this.queue = new CoalescingBufferQueue(channelPromise.channel());
        this.queue.add(byteBuf, channelPromise);
        this.dataSize = this.queue.readableBytes();
    }

    @Override
    public int size() {
        return this.dataSize + this.padding;
    }

    @Override
    public void error(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        this.queue.releaseAndFailAll(throwable);
        DefaultHttp2ConnectionEncoder.access$000(this.this$0).onError(channelHandlerContext, true, throwable);
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, int n2) {
        int n3 = this.queue.readableBytes();
        if (!this.endOfStream) {
            if (n3 == 0) {
                ChannelPromise channelPromise = channelHandlerContext.newPromise().addListener(this);
                channelHandlerContext.write(this.queue.remove(0, channelPromise), channelPromise);
                return;
            }
            if (n2 == 0) {
                return;
            }
        }
        int n4 = Math.min(n3, n2);
        ChannelPromise channelPromise = channelHandlerContext.newPromise().addListener(this);
        ByteBuf byteBuf = this.queue.remove(n4, channelPromise);
        this.dataSize = this.queue.readableBytes();
        int n5 = Math.min(n2 - n4, this.padding);
        this.padding -= n5;
        this.this$0.frameWriter().writeData(channelHandlerContext, this.stream.id(), byteBuf, n5, this.endOfStream && this.size() == 0, channelPromise);
    }

    @Override
    public boolean merge(ChannelHandlerContext channelHandlerContext, Http2RemoteFlowController$FlowControlled http2RemoteFlowController$FlowControlled) {
        DefaultHttp2ConnectionEncoder$FlowControlledData defaultHttp2ConnectionEncoder$FlowControlledData;
        if (DefaultHttp2ConnectionEncoder$FlowControlledData.class != http2RemoteFlowController$FlowControlled.getClass() || Integer.MAX_VALUE - (defaultHttp2ConnectionEncoder$FlowControlledData = (DefaultHttp2ConnectionEncoder$FlowControlledData)http2RemoteFlowController$FlowControlled).size() < this.size()) {
            return false;
        }
        defaultHttp2ConnectionEncoder$FlowControlledData.queue.copyTo(this.queue);
        this.dataSize = this.queue.readableBytes();
        this.padding = Math.max(this.padding, defaultHttp2ConnectionEncoder$FlowControlledData.padding);
        this.endOfStream = defaultHttp2ConnectionEncoder$FlowControlledData.endOfStream;
        return true;
    }
}

