/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionDecoder$FrameReadListener;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionDecoder$PrefaceFrameListener;
import io.netty.handler.codec.http2.DefaultHttp2LocalFlowController;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameReader$Configuration;
import io.netty.handler.codec.http2.Http2FrameSizePolicy;
import io.netty.handler.codec.http2.Http2HeadersDecoder$Configuration;
import io.netty.handler.codec.http2.Http2LifecycleManager;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2PromisedRequestVerifier;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.List;

public class DefaultHttp2ConnectionDecoder
implements Http2ConnectionDecoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultHttp2ConnectionDecoder.class);
    private Http2FrameListener internalFrameListener = new DefaultHttp2ConnectionDecoder$PrefaceFrameListener(this);
    private final Http2Connection connection;
    private Http2LifecycleManager lifecycleManager;
    private final Http2ConnectionEncoder encoder;
    private final Http2FrameReader frameReader;
    private Http2FrameListener listener;
    private final Http2PromisedRequestVerifier requestVerifier;

    public DefaultHttp2ConnectionDecoder(Http2Connection http2Connection, Http2ConnectionEncoder http2ConnectionEncoder, Http2FrameReader http2FrameReader) {
        this(http2Connection, http2ConnectionEncoder, http2FrameReader, Http2PromisedRequestVerifier.ALWAYS_VERIFY);
    }

    public DefaultHttp2ConnectionDecoder(Http2Connection http2Connection, Http2ConnectionEncoder http2ConnectionEncoder, Http2FrameReader http2FrameReader, Http2PromisedRequestVerifier http2PromisedRequestVerifier) {
        this.connection = ObjectUtil.checkNotNull(http2Connection, "connection");
        this.frameReader = ObjectUtil.checkNotNull(http2FrameReader, "frameReader");
        this.encoder = ObjectUtil.checkNotNull(http2ConnectionEncoder, "encoder");
        this.requestVerifier = ObjectUtil.checkNotNull(http2PromisedRequestVerifier, "requestVerifier");
        if (http2Connection.local().flowController() == null) {
            http2Connection.local().flowController(new DefaultHttp2LocalFlowController(http2Connection));
        }
        http2Connection.local().flowController().frameWriter(http2ConnectionEncoder.frameWriter());
    }

    @Override
    public void lifecycleManager(Http2LifecycleManager http2LifecycleManager) {
        this.lifecycleManager = ObjectUtil.checkNotNull(http2LifecycleManager, "lifecycleManager");
    }

    @Override
    public Http2Connection connection() {
        return this.connection;
    }

    @Override
    public final Http2LocalFlowController flowController() {
        return this.connection.local().flowController();
    }

    @Override
    public void frameListener(Http2FrameListener http2FrameListener) {
        this.listener = ObjectUtil.checkNotNull(http2FrameListener, "listener");
    }

    @Override
    public Http2FrameListener frameListener() {
        return this.listener;
    }

    Http2FrameListener internalFrameListener() {
        return this.internalFrameListener;
    }

    @Override
    public boolean prefaceReceived() {
        return DefaultHttp2ConnectionDecoder$FrameReadListener.class == this.internalFrameListener.getClass();
    }

    @Override
    public void decodeFrame(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        this.frameReader.readFrame(channelHandlerContext, byteBuf, this.internalFrameListener);
    }

    @Override
    public Http2Settings localSettings() {
        Http2Settings http2Settings = new Http2Settings();
        Http2FrameReader$Configuration http2FrameReader$Configuration = this.frameReader.configuration();
        Http2HeadersDecoder$Configuration http2HeadersDecoder$Configuration = http2FrameReader$Configuration.headersConfiguration();
        Http2FrameSizePolicy http2FrameSizePolicy = http2FrameReader$Configuration.frameSizePolicy();
        http2Settings.initialWindowSize(this.flowController().initialWindowSize());
        http2Settings.maxConcurrentStreams(this.connection.remote().maxActiveStreams());
        http2Settings.headerTableSize(http2HeadersDecoder$Configuration.maxHeaderTableSize());
        http2Settings.maxFrameSize(http2FrameSizePolicy.maxFrameSize());
        http2Settings.maxHeaderListSize(http2HeadersDecoder$Configuration.maxHeaderListSize());
        if (!this.connection.isServer()) {
            http2Settings.pushEnabled(this.connection.local().allowPushTo());
        }
        return http2Settings;
    }

    @Override
    public void close() {
        this.frameReader.close();
    }

    protected long calculateMaxHeaderListSizeGoAway(long l2) {
        return Http2CodecUtil.calculateMaxHeaderListSizeGoAway(l2);
    }

    private int unconsumedBytes(Http2Stream http2Stream) {
        return this.flowController().unconsumedBytes(http2Stream);
    }

    void onGoAwayRead0(ChannelHandlerContext channelHandlerContext, int n2, long l2, ByteBuf byteBuf) {
        if (this.connection.goAwayReceived() && this.connection.local().lastStreamKnownByPeer() < n2) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "lastStreamId MUST NOT increase. Current value: %d new value: %d", this.connection.local().lastStreamKnownByPeer(), n2);
        }
        this.listener.onGoAwayRead(channelHandlerContext, n2, l2, byteBuf);
        this.connection.goAwayReceived(n2, l2, byteBuf);
    }

    void onUnknownFrame0(ChannelHandlerContext channelHandlerContext, byte by2, int n2, Http2Flags http2Flags, ByteBuf byteBuf) {
        this.listener.onUnknownFrame(channelHandlerContext, by2, n2, http2Flags, byteBuf);
    }

    static /* synthetic */ Http2Connection access$100(DefaultHttp2ConnectionDecoder defaultHttp2ConnectionDecoder) {
        return defaultHttp2ConnectionDecoder.connection;
    }

    static /* synthetic */ int access$200(DefaultHttp2ConnectionDecoder defaultHttp2ConnectionDecoder, Http2Stream http2Stream) {
        return defaultHttp2ConnectionDecoder.unconsumedBytes(http2Stream);
    }

    static /* synthetic */ Http2FrameListener access$300(DefaultHttp2ConnectionDecoder defaultHttp2ConnectionDecoder) {
        return defaultHttp2ConnectionDecoder.listener;
    }

    static /* synthetic */ Http2LifecycleManager access$400(DefaultHttp2ConnectionDecoder defaultHttp2ConnectionDecoder) {
        return defaultHttp2ConnectionDecoder.lifecycleManager;
    }

    static /* synthetic */ Http2ConnectionEncoder access$500(DefaultHttp2ConnectionDecoder defaultHttp2ConnectionDecoder) {
        return defaultHttp2ConnectionDecoder.encoder;
    }

    static /* synthetic */ Http2FrameReader access$600(DefaultHttp2ConnectionDecoder defaultHttp2ConnectionDecoder) {
        return defaultHttp2ConnectionDecoder.frameReader;
    }

    static /* synthetic */ Http2PromisedRequestVerifier access$700(DefaultHttp2ConnectionDecoder defaultHttp2ConnectionDecoder) {
        return defaultHttp2ConnectionDecoder.requestVerifier;
    }

    static /* synthetic */ InternalLogger access$800() {
        return logger;
    }

    static /* synthetic */ Http2FrameListener access$900(DefaultHttp2ConnectionDecoder defaultHttp2ConnectionDecoder) {
        return defaultHttp2ConnectionDecoder.internalFrameListener;
    }

    static /* synthetic */ Http2FrameListener access$902(DefaultHttp2ConnectionDecoder defaultHttp2ConnectionDecoder, Http2FrameListener http2FrameListener) {
        defaultHttp2ConnectionDecoder.internalFrameListener = http2FrameListener;
        return defaultHttp2ConnectionDecoder.internalFrameListener;
    }
}

