/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2Connection$1;
import io.netty.handler.codec.http2.DefaultHttp2Connection$2;
import io.netty.handler.codec.http2.DefaultHttp2Connection$ActiveStreams;
import io.netty.handler.codec.http2.DefaultHttp2Connection$ConnectionStream;
import io.netty.handler.codec.http2.DefaultHttp2Connection$DefaultEndpoint;
import io.netty.handler.codec.http2.DefaultHttp2Connection$DefaultPropertyKey;
import io.netty.handler.codec.http2.DefaultHttp2Connection$DefaultStream;
import io.netty.handler.codec.http2.DefaultHttp2Connection$PropertyKeyRegistry;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Connection$Endpoint;
import io.netty.handler.codec.http2.Http2Connection$Listener;
import io.netty.handler.codec.http2.Http2Connection$PropertyKey;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2Stream$State;
import io.netty.handler.codec.http2.Http2StreamVisitor;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.collection.IntObjectMap$PrimitiveEntry;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.UnaryPromiseNotifier;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DefaultHttp2Connection
implements Http2Connection {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultHttp2Connection.class);
    final IntObjectMap<Http2Stream> streamMap = new IntObjectHashMap<Http2Stream>();
    final DefaultHttp2Connection$PropertyKeyRegistry propertyKeyRegistry = new DefaultHttp2Connection$PropertyKeyRegistry(this, null);
    final DefaultHttp2Connection$ConnectionStream connectionStream = new DefaultHttp2Connection$ConnectionStream(this);
    final DefaultHttp2Connection$DefaultEndpoint<Http2LocalFlowController> localEndpoint;
    final DefaultHttp2Connection$DefaultEndpoint<Http2RemoteFlowController> remoteEndpoint;
    final List<Http2Connection$Listener> listeners = new ArrayList<Http2Connection$Listener>(4);
    final DefaultHttp2Connection$ActiveStreams activeStreams = new DefaultHttp2Connection$ActiveStreams(this, this.listeners);
    Promise<Void> closePromise;

    public DefaultHttp2Connection(boolean bl2) {
        this(bl2, 100);
    }

    public DefaultHttp2Connection(boolean bl2, int n2) {
        this.localEndpoint = new DefaultHttp2Connection$DefaultEndpoint(this, bl2, bl2 ? Integer.MAX_VALUE : n2);
        this.remoteEndpoint = new DefaultHttp2Connection$DefaultEndpoint(this, !bl2, n2);
        this.streamMap.put(this.connectionStream.id(), (Http2Stream)this.connectionStream);
    }

    final boolean isClosed() {
        return this.closePromise != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Void> close(Promise<Void> promise) {
        ObjectUtil.checkNotNull(promise, "promise");
        if (this.closePromise != null) {
            if (this.closePromise != promise) {
                if (promise instanceof ChannelPromise && ((ChannelPromise)this.closePromise).isVoid()) {
                    this.closePromise = promise;
                } else {
                    this.closePromise.addListener(new UnaryPromiseNotifier<Void>(promise));
                }
            }
        } else {
            this.closePromise = promise;
        }
        if (this.isStreamMapEmpty()) {
            promise.trySuccess(null);
            return promise;
        }
        Iterator<IntObjectMap$PrimitiveEntry<Http2Stream>> iterator = this.streamMap.entries().iterator();
        if (this.activeStreams.allowModifications()) {
            this.activeStreams.incrementPendingIterations();
            try {
                while (iterator.hasNext()) {
                    DefaultHttp2Connection$DefaultStream defaultHttp2Connection$DefaultStream = (DefaultHttp2Connection$DefaultStream)iterator.next().value();
                    if (defaultHttp2Connection$DefaultStream.id() == 0) continue;
                    defaultHttp2Connection$DefaultStream.close(iterator);
                }
            }
            finally {
                this.activeStreams.decrementPendingIterations();
            }
        } else {
            while (iterator.hasNext()) {
                Http2Stream http2Stream = iterator.next().value();
                if (http2Stream.id() == 0) continue;
                http2Stream.close();
            }
        }
        return this.closePromise;
    }

    @Override
    public void addListener(Http2Connection$Listener http2Connection$Listener) {
        this.listeners.add(http2Connection$Listener);
    }

    @Override
    public void removeListener(Http2Connection$Listener http2Connection$Listener) {
        this.listeners.remove(http2Connection$Listener);
    }

    @Override
    public boolean isServer() {
        return this.localEndpoint.isServer();
    }

    @Override
    public Http2Stream connectionStream() {
        return this.connectionStream;
    }

    @Override
    public Http2Stream stream(int n2) {
        return this.streamMap.get(n2);
    }

    @Override
    public boolean streamMayHaveExisted(int n2) {
        return this.remoteEndpoint.mayHaveCreatedStream(n2) || this.localEndpoint.mayHaveCreatedStream(n2);
    }

    @Override
    public int numActiveStreams() {
        return this.activeStreams.size();
    }

    @Override
    public Http2Stream forEachActiveStream(Http2StreamVisitor http2StreamVisitor) {
        return this.activeStreams.forEachActiveStream(http2StreamVisitor);
    }

    @Override
    public Http2Connection$Endpoint<Http2LocalFlowController> local() {
        return this.localEndpoint;
    }

    @Override
    public Http2Connection$Endpoint<Http2RemoteFlowController> remote() {
        return this.remoteEndpoint;
    }

    @Override
    public boolean goAwayReceived() {
        return DefaultHttp2Connection$DefaultEndpoint.access$100(this.localEndpoint) >= 0;
    }

    @Override
    public void goAwayReceived(int n2, long l2, ByteBuf byteBuf) {
        DefaultHttp2Connection$DefaultEndpoint.access$200(this.localEndpoint, n2);
        for (int i2 = 0; i2 < this.listeners.size(); ++i2) {
            try {
                this.listeners.get(i2).onGoAwayReceived(n2, l2, byteBuf);
                continue;
            }
            catch (Throwable throwable) {
                logger.error("Caught Throwable from listener onGoAwayReceived.", throwable);
            }
        }
        try {
            this.forEachActiveStream(new DefaultHttp2Connection$1(this, n2));
        }
        catch (Http2Exception http2Exception) {
            PlatformDependent.throwException(http2Exception);
        }
    }

    @Override
    public boolean goAwaySent() {
        return DefaultHttp2Connection$DefaultEndpoint.access$100(this.remoteEndpoint) >= 0;
    }

    @Override
    public void goAwaySent(int n2, long l2, ByteBuf byteBuf) {
        DefaultHttp2Connection$DefaultEndpoint.access$200(this.remoteEndpoint, n2);
        for (int i2 = 0; i2 < this.listeners.size(); ++i2) {
            try {
                this.listeners.get(i2).onGoAwaySent(n2, l2, byteBuf);
                continue;
            }
            catch (Throwable throwable) {
                logger.error("Caught Throwable from listener onGoAwaySent.", throwable);
            }
        }
        try {
            this.forEachActiveStream(new DefaultHttp2Connection$2(this, n2));
        }
        catch (Http2Exception http2Exception) {
            PlatformDependent.throwException(http2Exception);
        }
    }

    private boolean isStreamMapEmpty() {
        return this.streamMap.size() == 1;
    }

    void removeStream(DefaultHttp2Connection$DefaultStream defaultHttp2Connection$DefaultStream, Iterator<?> iterator) {
        boolean bl2;
        if (iterator == null) {
            bl2 = this.streamMap.remove(defaultHttp2Connection$DefaultStream.id()) != null;
        } else {
            iterator.remove();
            bl2 = true;
        }
        if (bl2) {
            for (int i2 = 0; i2 < this.listeners.size(); ++i2) {
                try {
                    this.listeners.get(i2).onStreamRemoved(defaultHttp2Connection$DefaultStream);
                    continue;
                }
                catch (Throwable throwable) {
                    logger.error("Caught Throwable from listener onStreamRemoved.", throwable);
                }
            }
            if (this.closePromise != null && this.isStreamMapEmpty()) {
                this.closePromise.trySuccess(null);
            }
        }
    }

    static Http2Stream$State activeState(int n2, Http2Stream$State http2Stream$State, boolean bl2, boolean bl3) {
        switch (http2Stream$State) {
            case IDLE: {
                return bl3 ? (bl2 ? Http2Stream$State.HALF_CLOSED_LOCAL : Http2Stream$State.HALF_CLOSED_REMOTE) : Http2Stream$State.OPEN;
            }
            case RESERVED_LOCAL: {
                return Http2Stream$State.HALF_CLOSED_REMOTE;
            }
            case RESERVED_REMOTE: {
                return Http2Stream$State.HALF_CLOSED_LOCAL;
            }
        }
        throw Http2Exception.streamError(n2, Http2Error.PROTOCOL_ERROR, "Attempting to open a stream in an invalid state: " + (Object)((Object)http2Stream$State), new Object[0]);
    }

    void notifyHalfClosed(Http2Stream http2Stream) {
        for (int i2 = 0; i2 < this.listeners.size(); ++i2) {
            try {
                this.listeners.get(i2).onStreamHalfClosed(http2Stream);
                continue;
            }
            catch (Throwable throwable) {
                logger.error("Caught Throwable from listener onStreamHalfClosed.", throwable);
            }
        }
    }

    void notifyClosed(Http2Stream http2Stream) {
        for (int i2 = 0; i2 < this.listeners.size(); ++i2) {
            try {
                this.listeners.get(i2).onStreamClosed(http2Stream);
                continue;
            }
            catch (Throwable throwable) {
                logger.error("Caught Throwable from listener onStreamClosed.", throwable);
            }
        }
    }

    @Override
    public Http2Connection$PropertyKey newKey() {
        return this.propertyKeyRegistry.newKey();
    }

    final DefaultHttp2Connection$DefaultPropertyKey verifyKey(Http2Connection$PropertyKey http2Connection$PropertyKey) {
        return ObjectUtil.checkNotNull((DefaultHttp2Connection$DefaultPropertyKey)http2Connection$PropertyKey, "key").verifyConnection(this);
    }

    static /* synthetic */ InternalLogger access$400() {
        return logger;
    }
}

