/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2Connection$DefaultEndpoint;
import io.netty.handler.codec.http2.DefaultHttp2Connection$DefaultStream$PropertyMap;
import io.netty.handler.codec.http2.Http2Connection$PropertyKey;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FlowController;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2Stream$State;
import java.util.Iterator;

class DefaultHttp2Connection$DefaultStream
implements Http2Stream {
    private static final byte META_STATE_SENT_RST = 1;
    private static final byte META_STATE_SENT_HEADERS = 2;
    private static final byte META_STATE_SENT_TRAILERS = 4;
    private static final byte META_STATE_SENT_PUSHPROMISE = 8;
    private static final byte META_STATE_RECV_HEADERS = 16;
    private static final byte META_STATE_RECV_TRAILERS = 32;
    private final int id;
    private final DefaultHttp2Connection$DefaultStream$PropertyMap properties = new DefaultHttp2Connection$DefaultStream$PropertyMap(this);
    private Http2Stream$State state;
    private byte metaState;
    final /* synthetic */ DefaultHttp2Connection this$0;

    DefaultHttp2Connection$DefaultStream(DefaultHttp2Connection defaultHttp2Connection, int n2, Http2Stream$State http2Stream$State) {
        this.this$0 = defaultHttp2Connection;
        this.id = n2;
        this.state = http2Stream$State;
    }

    @Override
    public final int id() {
        return this.id;
    }

    @Override
    public final Http2Stream$State state() {
        return this.state;
    }

    @Override
    public boolean isResetSent() {
        return (this.metaState & 1) != 0;
    }

    @Override
    public Http2Stream resetSent() {
        this.metaState = (byte)(this.metaState | 1);
        return this;
    }

    @Override
    public Http2Stream headersSent(boolean bl2) {
        if (!bl2) {
            this.metaState = (byte)(this.metaState | (this.isHeadersSent() ? 4 : 2));
        }
        return this;
    }

    @Override
    public boolean isHeadersSent() {
        return (this.metaState & 2) != 0;
    }

    @Override
    public boolean isTrailersSent() {
        return (this.metaState & 4) != 0;
    }

    @Override
    public Http2Stream headersReceived(boolean bl2) {
        if (!bl2) {
            this.metaState = (byte)(this.metaState | (this.isHeadersReceived() ? 32 : 16));
        }
        return this;
    }

    @Override
    public boolean isHeadersReceived() {
        return (this.metaState & 0x10) != 0;
    }

    @Override
    public boolean isTrailersReceived() {
        return (this.metaState & 0x20) != 0;
    }

    @Override
    public Http2Stream pushPromiseSent() {
        this.metaState = (byte)(this.metaState | 8);
        return this;
    }

    @Override
    public boolean isPushPromiseSent() {
        return (this.metaState & 8) != 0;
    }

    @Override
    public final <V> V setProperty(Http2Connection$PropertyKey http2Connection$PropertyKey, V v2) {
        return this.properties.add(this.this$0.verifyKey(http2Connection$PropertyKey), v2);
    }

    @Override
    public final <V> V getProperty(Http2Connection$PropertyKey http2Connection$PropertyKey) {
        return this.properties.get(this.this$0.verifyKey(http2Connection$PropertyKey));
    }

    @Override
    public final <V> V removeProperty(Http2Connection$PropertyKey http2Connection$PropertyKey) {
        return this.properties.remove(this.this$0.verifyKey(http2Connection$PropertyKey));
    }

    @Override
    public Http2Stream open(boolean bl2) {
        this.state = DefaultHttp2Connection.activeState(this.id, this.state, this.isLocal(), bl2);
        if (!this.createdBy().canOpenStream()) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Maximum active streams violated for this endpoint.", new Object[0]);
        }
        this.activate();
        return this;
    }

    void activate() {
        if (this.state == Http2Stream$State.HALF_CLOSED_LOCAL) {
            this.headersSent(false);
        } else if (this.state == Http2Stream$State.HALF_CLOSED_REMOTE) {
            this.headersReceived(false);
        }
        this.this$0.activeStreams.activate(this);
    }

    Http2Stream close(Iterator<?> iterator) {
        if (this.state == Http2Stream$State.CLOSED) {
            return this;
        }
        this.state = Http2Stream$State.CLOSED;
        --this.createdBy().numStreams;
        this.this$0.activeStreams.deactivate(this, iterator);
        return this;
    }

    @Override
    public Http2Stream close() {
        return this.close(null);
    }

    @Override
    public Http2Stream closeLocalSide() {
        switch (this.state) {
            case OPEN: {
                this.state = Http2Stream$State.HALF_CLOSED_LOCAL;
                this.this$0.notifyHalfClosed(this);
                break;
            }
            case HALF_CLOSED_LOCAL: {
                break;
            }
            default: {
                this.close();
            }
        }
        return this;
    }

    @Override
    public Http2Stream closeRemoteSide() {
        switch (this.state) {
            case OPEN: {
                this.state = Http2Stream$State.HALF_CLOSED_REMOTE;
                this.this$0.notifyHalfClosed(this);
                break;
            }
            case HALF_CLOSED_REMOTE: {
                break;
            }
            default: {
                this.close();
            }
        }
        return this;
    }

    DefaultHttp2Connection$DefaultEndpoint<? extends Http2FlowController> createdBy() {
        return this.this$0.localEndpoint.isValidStreamId(this.id) ? this.this$0.localEndpoint : this.this$0.remoteEndpoint;
    }

    final boolean isLocal() {
        return this.this$0.localEndpoint.isValidStreamId(this.id);
    }
}

