/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2Connection$DefaultStream;
import io.netty.handler.codec.http2.Http2Connection$Endpoint;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FlowController;
import io.netty.handler.codec.http2.Http2NoMoreStreamIdsException;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2Stream$State;
import io.netty.util.internal.ObjectUtil;

final class DefaultHttp2Connection$DefaultEndpoint<F extends Http2FlowController>
implements Http2Connection$Endpoint<F> {
    private final boolean server;
    private int nextStreamIdToCreate;
    private int nextReservationStreamId;
    private int lastStreamKnownByPeer = -1;
    private boolean pushToAllowed = true;
    private F flowController;
    private int maxStreams;
    private int maxActiveStreams;
    private final int maxReservedStreams;
    int numActiveStreams;
    int numStreams;
    static final /* synthetic */ boolean $assertionsDisabled;
    final /* synthetic */ DefaultHttp2Connection this$0;

    DefaultHttp2Connection$DefaultEndpoint(DefaultHttp2Connection defaultHttp2Connection, boolean bl2, int n2) {
        this.this$0 = defaultHttp2Connection;
        this.server = bl2;
        if (bl2) {
            this.nextStreamIdToCreate = 2;
            this.nextReservationStreamId = 0;
        } else {
            this.nextStreamIdToCreate = 1;
            this.nextReservationStreamId = 1;
        }
        this.pushToAllowed = !bl2;
        this.maxActiveStreams = Integer.MAX_VALUE;
        this.maxReservedStreams = ObjectUtil.checkPositiveOrZero(n2, "maxReservedStreams");
        this.updateMaxStreams();
    }

    @Override
    public int incrementAndGetNextStreamId() {
        return this.nextReservationStreamId >= 0 ? (this.nextReservationStreamId = this.nextReservationStreamId + 2) : this.nextReservationStreamId;
    }

    private void incrementExpectedStreamId(int n2) {
        if (n2 > this.nextReservationStreamId && this.nextReservationStreamId >= 0) {
            this.nextReservationStreamId = n2;
        }
        this.nextStreamIdToCreate = n2 + 2;
        ++this.numStreams;
    }

    @Override
    public boolean isValidStreamId(int n2) {
        return n2 > 0 && this.server == ((n2 & 1) == 0);
    }

    @Override
    public boolean mayHaveCreatedStream(int n2) {
        return this.isValidStreamId(n2) && n2 <= this.lastStreamCreated();
    }

    @Override
    public boolean canOpenStream() {
        return this.numActiveStreams < this.maxActiveStreams;
    }

    @Override
    public DefaultHttp2Connection$DefaultStream createStream(int n2, boolean bl2) {
        Http2Stream$State http2Stream$State = DefaultHttp2Connection.activeState(n2, Http2Stream$State.IDLE, this.isLocal(), bl2);
        this.checkNewStreamAllowed(n2, http2Stream$State);
        DefaultHttp2Connection$DefaultStream defaultHttp2Connection$DefaultStream = new DefaultHttp2Connection$DefaultStream(this.this$0, n2, http2Stream$State);
        this.incrementExpectedStreamId(n2);
        this.addStream(defaultHttp2Connection$DefaultStream);
        defaultHttp2Connection$DefaultStream.activate();
        return defaultHttp2Connection$DefaultStream;
    }

    @Override
    public boolean created(Http2Stream http2Stream) {
        return http2Stream instanceof DefaultHttp2Connection$DefaultStream && ((DefaultHttp2Connection$DefaultStream)http2Stream).createdBy() == this;
    }

    @Override
    public boolean isServer() {
        return this.server;
    }

    @Override
    public DefaultHttp2Connection$DefaultStream reservePushStream(int n2, Http2Stream http2Stream) {
        if (http2Stream == null) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Parent stream missing", new Object[0]);
        }
        if (this.isLocal() ? !http2Stream.state().localSideOpen() : !http2Stream.state().remoteSideOpen()) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Stream %d is not open for sending push promise", http2Stream.id());
        }
        if (!this.opposite().allowPushTo()) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Server push not allowed to opposite endpoint", new Object[0]);
        }
        Http2Stream$State http2Stream$State = this.isLocal() ? Http2Stream$State.RESERVED_LOCAL : Http2Stream$State.RESERVED_REMOTE;
        this.checkNewStreamAllowed(n2, http2Stream$State);
        DefaultHttp2Connection$DefaultStream defaultHttp2Connection$DefaultStream = new DefaultHttp2Connection$DefaultStream(this.this$0, n2, http2Stream$State);
        this.incrementExpectedStreamId(n2);
        this.addStream(defaultHttp2Connection$DefaultStream);
        return defaultHttp2Connection$DefaultStream;
    }

    private void addStream(DefaultHttp2Connection$DefaultStream defaultHttp2Connection$DefaultStream) {
        this.this$0.streamMap.put(defaultHttp2Connection$DefaultStream.id(), (Http2Stream)defaultHttp2Connection$DefaultStream);
        for (int i2 = 0; i2 < this.this$0.listeners.size(); ++i2) {
            try {
                this.this$0.listeners.get(i2).onStreamAdded(defaultHttp2Connection$DefaultStream);
                continue;
            }
            catch (Throwable throwable) {
                DefaultHttp2Connection.access$400().error("Caught Throwable from listener onStreamAdded.", throwable);
            }
        }
    }

    @Override
    public void allowPushTo(boolean bl2) {
        if (bl2 && this.server) {
            throw new IllegalArgumentException("Servers do not allow push");
        }
        this.pushToAllowed = bl2;
    }

    @Override
    public boolean allowPushTo() {
        return this.pushToAllowed;
    }

    @Override
    public int numActiveStreams() {
        return this.numActiveStreams;
    }

    @Override
    public int maxActiveStreams() {
        return this.maxActiveStreams;
    }

    @Override
    public void maxActiveStreams(int n2) {
        this.maxActiveStreams = n2;
        this.updateMaxStreams();
    }

    @Override
    public int lastStreamCreated() {
        return this.nextStreamIdToCreate > 1 ? this.nextStreamIdToCreate - 2 : 0;
    }

    @Override
    public int lastStreamKnownByPeer() {
        return this.lastStreamKnownByPeer;
    }

    private void lastStreamKnownByPeer(int n2) {
        this.lastStreamKnownByPeer = n2;
    }

    @Override
    public F flowController() {
        return this.flowController;
    }

    @Override
    public void flowController(F f2) {
        this.flowController = (Http2FlowController)ObjectUtil.checkNotNull(f2, "flowController");
    }

    @Override
    public Http2Connection$Endpoint<? extends Http2FlowController> opposite() {
        return this.isLocal() ? this.this$0.remoteEndpoint : this.this$0.localEndpoint;
    }

    private void updateMaxStreams() {
        this.maxStreams = (int)Math.min(Integer.MAX_VALUE, (long)this.maxActiveStreams + (long)this.maxReservedStreams);
    }

    private void checkNewStreamAllowed(int n2, Http2Stream$State http2Stream$State) {
        boolean bl2;
        if (!$assertionsDisabled && http2Stream$State == Http2Stream$State.IDLE) {
            throw new AssertionError();
        }
        if (this.this$0.goAwayReceived() && n2 > this.this$0.localEndpoint.lastStreamKnownByPeer()) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Cannot create stream %d since this endpoint has received a GOAWAY frame with last stream id %d.", n2, this.this$0.localEndpoint.lastStreamKnownByPeer());
        }
        if (!this.isValidStreamId(n2)) {
            if (n2 < 0) {
                throw new Http2NoMoreStreamIdsException();
            }
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Request stream %d is not correct for %s connection", n2, this.server ? "server" : "client");
        }
        if (n2 < this.nextStreamIdToCreate) {
            throw Http2Exception.closedStreamError(Http2Error.PROTOCOL_ERROR, "Request stream %d is behind the next expected stream %d", n2, this.nextStreamIdToCreate);
        }
        if (this.nextStreamIdToCreate <= 0) {
            throw Http2Exception.connectionError(Http2Error.REFUSED_STREAM, "Stream IDs are exhausted for this endpoint.", new Object[0]);
        }
        boolean bl3 = bl2 = http2Stream$State == Http2Stream$State.RESERVED_LOCAL || http2Stream$State == Http2Stream$State.RESERVED_REMOTE;
        if (!bl2 && !this.canOpenStream() || bl2 && this.numStreams >= this.maxStreams) {
            throw Http2Exception.streamError(n2, Http2Error.REFUSED_STREAM, "Maximum active streams violated for this endpoint.", new Object[0]);
        }
        if (this.this$0.isClosed()) {
            throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, "Attempted to create stream id %d after connection was closed", n2);
        }
    }

    private boolean isLocal() {
        return this == this.this$0.localEndpoint;
    }

    static /* synthetic */ int access$100(DefaultHttp2Connection$DefaultEndpoint defaultHttp2Connection$DefaultEndpoint) {
        return defaultHttp2Connection$DefaultEndpoint.lastStreamKnownByPeer;
    }

    static /* synthetic */ void access$200(DefaultHttp2Connection$DefaultEndpoint defaultHttp2Connection$DefaultEndpoint, int n2) {
        defaultHttp2Connection$DefaultEndpoint.lastStreamKnownByPeer(n2);
    }

    static {
        $assertionsDisabled = !DefaultHttp2Connection.class.desiredAssertionStatus();
    }
}

