/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2Connection$ActiveStreams$1;
import io.netty.handler.codec.http2.DefaultHttp2Connection$ActiveStreams$2;
import io.netty.handler.codec.http2.DefaultHttp2Connection$DefaultStream;
import io.netty.handler.codec.http2.DefaultHttp2Connection$Event;
import io.netty.handler.codec.http2.Http2Connection$Listener;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamVisitor;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;

final class DefaultHttp2Connection$ActiveStreams {
    private final List<Http2Connection$Listener> listeners;
    private final Queue<DefaultHttp2Connection$Event> pendingEvents = new ArrayDeque<DefaultHttp2Connection$Event>(4);
    private final Set<Http2Stream> streams = new LinkedHashSet<Http2Stream>();
    private int pendingIterations;
    final /* synthetic */ DefaultHttp2Connection this$0;

    public DefaultHttp2Connection$ActiveStreams(DefaultHttp2Connection defaultHttp2Connection, List<Http2Connection$Listener> list) {
        this.this$0 = defaultHttp2Connection;
        this.listeners = list;
    }

    public int size() {
        return this.streams.size();
    }

    public void activate(DefaultHttp2Connection$DefaultStream defaultHttp2Connection$DefaultStream) {
        if (this.allowModifications()) {
            this.addToActiveStreams(defaultHttp2Connection$DefaultStream);
        } else {
            this.pendingEvents.add(new DefaultHttp2Connection$ActiveStreams$1(this, defaultHttp2Connection$DefaultStream));
        }
    }

    public void deactivate(DefaultHttp2Connection$DefaultStream defaultHttp2Connection$DefaultStream, Iterator<?> iterator) {
        if (this.allowModifications() || iterator != null) {
            this.removeFromActiveStreams(defaultHttp2Connection$DefaultStream, iterator);
        } else {
            this.pendingEvents.add(new DefaultHttp2Connection$ActiveStreams$2(this, defaultHttp2Connection$DefaultStream, iterator));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Http2Stream forEachActiveStream(Http2StreamVisitor http2StreamVisitor) {
        this.incrementPendingIterations();
        try {
            for (Http2Stream http2Stream : this.streams) {
                if (http2StreamVisitor.visit(http2Stream)) continue;
                Http2Stream http2Stream2 = http2Stream;
                return http2Stream2;
            }
            Iterator<Http2Stream> iterator = null;
            return iterator;
        }
        finally {
            this.decrementPendingIterations();
        }
    }

    void addToActiveStreams(DefaultHttp2Connection$DefaultStream defaultHttp2Connection$DefaultStream) {
        if (this.streams.add(defaultHttp2Connection$DefaultStream)) {
            ++defaultHttp2Connection$DefaultStream.createdBy().numActiveStreams;
            for (int i2 = 0; i2 < this.listeners.size(); ++i2) {
                try {
                    this.listeners.get(i2).onStreamActive(defaultHttp2Connection$DefaultStream);
                    continue;
                }
                catch (Throwable throwable) {
                    DefaultHttp2Connection.access$400().error("Caught Throwable from listener onStreamActive.", throwable);
                }
            }
        }
    }

    void removeFromActiveStreams(DefaultHttp2Connection$DefaultStream defaultHttp2Connection$DefaultStream, Iterator<?> iterator) {
        if (this.streams.remove(defaultHttp2Connection$DefaultStream)) {
            --defaultHttp2Connection$DefaultStream.createdBy().numActiveStreams;
            this.this$0.notifyClosed(defaultHttp2Connection$DefaultStream);
        }
        this.this$0.removeStream(defaultHttp2Connection$DefaultStream, iterator);
    }

    boolean allowModifications() {
        return this.pendingIterations == 0;
    }

    void incrementPendingIterations() {
        ++this.pendingIterations;
    }

    void decrementPendingIterations() {
        --this.pendingIterations;
        if (this.allowModifications()) {
            DefaultHttp2Connection$Event defaultHttp2Connection$Event;
            while ((defaultHttp2Connection$Event = this.pendingEvents.poll()) != null) {
                try {
                    defaultHttp2Connection$Event.process();
                }
                catch (Throwable throwable) {
                    DefaultHttp2Connection.access$400().error("Caught Throwable while processing pending ActiveStreams$Event.", throwable);
                }
            }
        }
    }
}

