/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions.compression;

import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtension;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateServerExtensionHandshaker$PermessageDeflateExtension;
import java.util.Iterator;
import java.util.Map;

public final class PerMessageDeflateServerExtensionHandshaker
implements WebSocketServerExtensionHandshaker {
    public static final int MIN_WINDOW_SIZE = 8;
    public static final int MAX_WINDOW_SIZE = 15;
    static final String PERMESSAGE_DEFLATE_EXTENSION = "permessage-deflate";
    static final String CLIENT_MAX_WINDOW = "client_max_window_bits";
    static final String SERVER_MAX_WINDOW = "server_max_window_bits";
    static final String CLIENT_NO_CONTEXT = "client_no_context_takeover";
    static final String SERVER_NO_CONTEXT = "server_no_context_takeover";
    private final int compressionLevel;
    private final boolean allowServerWindowSize;
    private final int preferredClientWindowSize;
    private final boolean allowServerNoContext;
    private final boolean preferredClientNoContext;

    public PerMessageDeflateServerExtensionHandshaker() {
        this(6, ZlibCodecFactory.isSupportingWindowSizeAndMemLevel(), 15, false, false);
    }

    public PerMessageDeflateServerExtensionHandshaker(int n2, boolean bl2, int n3, boolean bl3, boolean bl4) {
        if (n3 > 15 || n3 < 8) {
            throw new IllegalArgumentException("preferredServerWindowSize: " + n3 + " (expected: 8-15)");
        }
        if (n2 < 0 || n2 > 9) {
            throw new IllegalArgumentException("compressionLevel: " + n2 + " (expected: 0-9)");
        }
        this.compressionLevel = n2;
        this.allowServerWindowSize = bl2;
        this.preferredClientWindowSize = n3;
        this.allowServerNoContext = bl3;
        this.preferredClientNoContext = bl4;
    }

    @Override
    public WebSocketServerExtension handshakeExtension(WebSocketExtensionData webSocketExtensionData) {
        if (!PERMESSAGE_DEFLATE_EXTENSION.equals(webSocketExtensionData.name())) {
            return null;
        }
        boolean bl2 = true;
        int n2 = 15;
        int n3 = 15;
        boolean bl3 = false;
        boolean bl4 = false;
        Iterator<Map.Entry<String, String>> iterator = webSocketExtensionData.parameters().entrySet().iterator();
        while (bl2 && iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            if (CLIENT_MAX_WINDOW.equalsIgnoreCase(entry.getKey())) {
                n2 = this.preferredClientWindowSize;
                continue;
            }
            if (SERVER_MAX_WINDOW.equalsIgnoreCase(entry.getKey())) {
                if (this.allowServerWindowSize) {
                    n3 = Integer.parseInt(entry.getValue());
                    if (n3 <= 15 && n3 >= 8) continue;
                    bl2 = false;
                    continue;
                }
                bl2 = false;
                continue;
            }
            if (CLIENT_NO_CONTEXT.equalsIgnoreCase(entry.getKey())) {
                bl4 = this.preferredClientNoContext;
                continue;
            }
            if (SERVER_NO_CONTEXT.equalsIgnoreCase(entry.getKey())) {
                if (this.allowServerNoContext) {
                    bl3 = true;
                    continue;
                }
                bl2 = false;
                continue;
            }
            bl2 = false;
        }
        if (bl2) {
            return new PerMessageDeflateServerExtensionHandshaker$PermessageDeflateExtension(this.compressionLevel, bl3, n3, bl4, n2);
        }
        return null;
    }
}

