/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions.compression;

import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionDecoder;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionEncoder;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtension;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateDecoder;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateEncoder;
import java.util.HashMap;

class PerMessageDeflateServerExtensionHandshaker$PermessageDeflateExtension
implements WebSocketServerExtension {
    private final int compressionLevel;
    private final boolean serverNoContext;
    private final int serverWindowSize;
    private final boolean clientNoContext;
    private final int clientWindowSize;

    public PerMessageDeflateServerExtensionHandshaker$PermessageDeflateExtension(int n2, boolean bl2, int n3, boolean bl3, int n4) {
        this.compressionLevel = n2;
        this.serverNoContext = bl2;
        this.serverWindowSize = n3;
        this.clientNoContext = bl3;
        this.clientWindowSize = n4;
    }

    @Override
    public int rsv() {
        return 4;
    }

    @Override
    public WebSocketExtensionEncoder newExtensionEncoder() {
        return new PerMessageDeflateEncoder(this.compressionLevel, this.clientWindowSize, this.clientNoContext);
    }

    @Override
    public WebSocketExtensionDecoder newExtensionDecoder() {
        return new PerMessageDeflateDecoder(this.serverNoContext);
    }

    @Override
    public WebSocketExtensionData newReponseData() {
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        if (this.serverNoContext) {
            hashMap.put("server_no_context_takeover", null);
        }
        if (this.clientNoContext) {
            hashMap.put("client_no_context_takeover", null);
        }
        if (this.serverWindowSize != 15) {
            hashMap.put("server_max_window_bits", Integer.toString(this.serverWindowSize));
        }
        if (this.clientWindowSize != 15) {
            hashMap.put("client_max_window_bits", Integer.toString(this.clientWindowSize));
        }
        return new WebSocketExtensionData("permessage-deflate", hashMap);
    }
}

