/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions.compression;

import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtension;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateClientExtensionHandshaker$PermessageDeflateExtension;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class PerMessageDeflateClientExtensionHandshaker
implements WebSocketClientExtensionHandshaker {
    private final int compressionLevel;
    private final boolean allowClientWindowSize;
    private final int requestedServerWindowSize;
    private final boolean allowClientNoContext;
    private final boolean requestedServerNoContext;

    public PerMessageDeflateClientExtensionHandshaker() {
        this(6, ZlibCodecFactory.isSupportingWindowSizeAndMemLevel(), 15, false, false);
    }

    public PerMessageDeflateClientExtensionHandshaker(int n2, boolean bl2, int n3, boolean bl3, boolean bl4) {
        if (n3 > 15 || n3 < 8) {
            throw new IllegalArgumentException("requestedServerWindowSize: " + n3 + " (expected: 8-15)");
        }
        if (n2 < 0 || n2 > 9) {
            throw new IllegalArgumentException("compressionLevel: " + n2 + " (expected: 0-9)");
        }
        this.compressionLevel = n2;
        this.allowClientWindowSize = bl2;
        this.requestedServerWindowSize = n3;
        this.allowClientNoContext = bl3;
        this.requestedServerNoContext = bl4;
    }

    @Override
    public WebSocketExtensionData newRequestData() {
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        if (this.requestedServerWindowSize != 15) {
            hashMap.put("server_no_context_takeover", null);
        }
        if (this.allowClientNoContext) {
            hashMap.put("client_no_context_takeover", null);
        }
        if (this.requestedServerWindowSize != 15) {
            hashMap.put("server_max_window_bits", Integer.toString(this.requestedServerWindowSize));
        }
        if (this.allowClientWindowSize) {
            hashMap.put("client_max_window_bits", null);
        }
        return new WebSocketExtensionData("permessage-deflate", hashMap);
    }

    @Override
    public WebSocketClientExtension handshakeExtension(WebSocketExtensionData webSocketExtensionData) {
        if (!"permessage-deflate".equals(webSocketExtensionData.name())) {
            return null;
        }
        boolean bl2 = true;
        int n2 = 15;
        int n3 = 15;
        boolean bl3 = false;
        boolean bl4 = false;
        Iterator<Map.Entry<String, String>> iterator = webSocketExtensionData.parameters().entrySet().iterator();
        while (bl2 && iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            if ("client_max_window_bits".equalsIgnoreCase(entry.getKey())) {
                if (this.allowClientWindowSize) {
                    n2 = Integer.parseInt(entry.getValue());
                    continue;
                }
                bl2 = false;
                continue;
            }
            if ("server_max_window_bits".equalsIgnoreCase(entry.getKey())) {
                n3 = Integer.parseInt(entry.getValue());
                if (n2 <= 15 && n2 >= 8) continue;
                bl2 = false;
                continue;
            }
            if ("client_no_context_takeover".equalsIgnoreCase(entry.getKey())) {
                if (this.allowClientNoContext) {
                    bl4 = true;
                    continue;
                }
                bl2 = false;
                continue;
            }
            if ("server_no_context_takeover".equalsIgnoreCase(entry.getKey())) {
                if (this.requestedServerNoContext) {
                    bl3 = true;
                    continue;
                }
                bl2 = false;
                continue;
            }
            bl2 = false;
        }
        if (this.requestedServerNoContext && !bl3 || this.requestedServerWindowSize != n3) {
            bl2 = false;
        }
        if (bl2) {
            return new PerMessageDeflateClientExtensionHandshaker$PermessageDeflateExtension(this, bl3, n3, bl4, n2);
        }
        return null;
    }

    static /* synthetic */ int access$000(PerMessageDeflateClientExtensionHandshaker perMessageDeflateClientExtensionHandshaker) {
        return perMessageDeflateClientExtensionHandshaker.compressionLevel;
    }
}

