/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions.compression;

import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtension;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateFrameServerExtensionHandshaker$DeflateFrameServerExtension;

public final class DeflateFrameServerExtensionHandshaker
implements WebSocketServerExtensionHandshaker {
    static final String X_WEBKIT_DEFLATE_FRAME_EXTENSION = "x-webkit-deflate-frame";
    static final String DEFLATE_FRAME_EXTENSION = "deflate-frame";
    private final int compressionLevel;

    public DeflateFrameServerExtensionHandshaker() {
        this(6);
    }

    public DeflateFrameServerExtensionHandshaker(int n2) {
        if (n2 < 0 || n2 > 9) {
            throw new IllegalArgumentException("compressionLevel: " + n2 + " (expected: 0-9)");
        }
        this.compressionLevel = n2;
    }

    @Override
    public WebSocketServerExtension handshakeExtension(WebSocketExtensionData webSocketExtensionData) {
        if (!X_WEBKIT_DEFLATE_FRAME_EXTENSION.equals(webSocketExtensionData.name()) && !DEFLATE_FRAME_EXTENSION.equals(webSocketExtensionData.name())) {
            return null;
        }
        if (webSocketExtensionData.parameters().isEmpty()) {
            return new DeflateFrameServerExtensionHandshaker$DeflateFrameServerExtension(this.compressionLevel, webSocketExtensionData.name());
        }
        return null;
    }
}

