/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.codec.http.websocketx.WebSocketUtil$1;
import io.netty.handler.codec.http.websocketx.WebSocketUtil$2;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.FastThreadLocal;
import java.security.MessageDigest;

final class WebSocketUtil {
    private static final FastThreadLocal<MessageDigest> MD5 = new WebSocketUtil$1();
    private static final FastThreadLocal<MessageDigest> SHA1 = new WebSocketUtil$2();

    static byte[] md5(byte[] byArray) {
        return WebSocketUtil.digest(MD5, byArray);
    }

    static byte[] sha1(byte[] byArray) {
        return WebSocketUtil.digest(SHA1, byArray);
    }

    private static byte[] digest(FastThreadLocal<MessageDigest> fastThreadLocal, byte[] byArray) {
        MessageDigest messageDigest = fastThreadLocal.get();
        messageDigest.reset();
        return messageDigest.digest(byArray);
    }

    static String base64(byte[] byArray) {
        ByteBuf byteBuf = Unpooled.wrappedBuffer(byArray);
        ByteBuf byteBuf2 = Base64.encode(byteBuf);
        String string = byteBuf2.toString(CharsetUtil.UTF_8);
        byteBuf2.release();
        return string;
    }

    static byte[] randomBytes(int n2) {
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = (byte)WebSocketUtil.randomNumber(0, 255);
        }
        return byArray;
    }

    static int randomNumber(int n2, int n3) {
        return (int)(Math.random() * (double)n3 + (double)n2);
    }

    private WebSocketUtil() {
    }
}

