/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.Utf8FrameValidator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandshakeHandler;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.net.URI;
import java.util.List;

public class WebSocketClientProtocolHandler
extends WebSocketProtocolHandler {
    private final WebSocketClientHandshaker handshaker;
    private final boolean handleCloseFrames;

    public WebSocketClientHandshaker handshaker() {
        return this.handshaker;
    }

    public WebSocketClientProtocolHandler(URI uRI, WebSocketVersion webSocketVersion, String string, boolean bl2, HttpHeaders httpHeaders, int n2, boolean bl3, boolean bl4, boolean bl5) {
        this(WebSocketClientHandshakerFactory.newHandshaker(uRI, webSocketVersion, string, bl2, httpHeaders, n2, bl4, bl5), bl3);
    }

    public WebSocketClientProtocolHandler(URI uRI, WebSocketVersion webSocketVersion, String string, boolean bl2, HttpHeaders httpHeaders, int n2, boolean bl3) {
        this(uRI, webSocketVersion, string, bl2, httpHeaders, n2, bl3, true, false);
    }

    public WebSocketClientProtocolHandler(URI uRI, WebSocketVersion webSocketVersion, String string, boolean bl2, HttpHeaders httpHeaders, int n2) {
        this(uRI, webSocketVersion, string, bl2, httpHeaders, n2, true);
    }

    public WebSocketClientProtocolHandler(WebSocketClientHandshaker webSocketClientHandshaker, boolean bl2) {
        this.handshaker = webSocketClientHandshaker;
        this.handleCloseFrames = bl2;
    }

    public WebSocketClientProtocolHandler(WebSocketClientHandshaker webSocketClientHandshaker) {
        this(webSocketClientHandshaker, true);
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, WebSocketFrame webSocketFrame, List<Object> list) {
        if (this.handleCloseFrames && webSocketFrame instanceof CloseWebSocketFrame) {
            channelHandlerContext.close();
            return;
        }
        super.decode(channelHandlerContext, webSocketFrame, list);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        ChannelPipeline channelPipeline = channelHandlerContext.pipeline();
        if (channelPipeline.get(WebSocketClientProtocolHandshakeHandler.class) == null) {
            channelHandlerContext.pipeline().addBefore(channelHandlerContext.name(), WebSocketClientProtocolHandshakeHandler.class.getName(), new WebSocketClientProtocolHandshakeHandler(this.handshaker));
        }
        if (channelPipeline.get(Utf8FrameValidator.class) == null) {
            channelHandlerContext.pipeline().addBefore(channelHandlerContext.name(), Utf8FrameValidator.class.getName(), new Utf8FrameValidator());
        }
    }
}

