/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker$1;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker$2;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker$3;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker$4;
import io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketScheme;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.NetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ThrowableUtil;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.util.Locale;

public abstract class WebSocketClientHandshaker {
    private static final ClosedChannelException CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), WebSocketClientHandshaker.class, "processHandshake(...)");
    private static final String HTTP_SCHEME_PREFIX = HttpScheme.HTTP + "://";
    private static final String HTTPS_SCHEME_PREFIX = HttpScheme.HTTPS + "://";
    private final URI uri;
    private final WebSocketVersion version;
    private volatile boolean handshakeComplete;
    private final String expectedSubprotocol;
    private volatile String actualSubprotocol;
    protected final HttpHeaders customHeaders;
    private final int maxFramePayloadLength;

    protected WebSocketClientHandshaker(URI uRI, WebSocketVersion webSocketVersion, String string, HttpHeaders httpHeaders, int n2) {
        this.uri = uRI;
        this.version = webSocketVersion;
        this.expectedSubprotocol = string;
        this.customHeaders = httpHeaders;
        this.maxFramePayloadLength = n2;
    }

    public URI uri() {
        return this.uri;
    }

    public WebSocketVersion version() {
        return this.version;
    }

    public int maxFramePayloadLength() {
        return this.maxFramePayloadLength;
    }

    public boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    private void setHandshakeComplete() {
        this.handshakeComplete = true;
    }

    public String expectedSubprotocol() {
        return this.expectedSubprotocol;
    }

    public String actualSubprotocol() {
        return this.actualSubprotocol;
    }

    private void setActualSubprotocol(String string) {
        this.actualSubprotocol = string;
    }

    public ChannelFuture handshake(Channel channel) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        return this.handshake(channel, channel.newPromise());
    }

    public final ChannelFuture handshake(Channel channel, ChannelPromise channelPromise) {
        HttpClientCodec httpClientCodec;
        FullHttpRequest fullHttpRequest = this.newHandshakeRequest();
        HttpResponseDecoder httpResponseDecoder = channel.pipeline().get(HttpResponseDecoder.class);
        if (httpResponseDecoder == null && (httpClientCodec = channel.pipeline().get(HttpClientCodec.class)) == null) {
            channelPromise.setFailure(new IllegalStateException("ChannelPipeline does not contain a HttpResponseDecoder or HttpClientCodec"));
            return channelPromise;
        }
        channel.writeAndFlush(fullHttpRequest).addListener(new WebSocketClientHandshaker$1(this, channelPromise));
        return channelPromise;
    }

    protected abstract FullHttpRequest newHandshakeRequest();

    public final void finishHandshake(Channel channel, FullHttpResponse fullHttpResponse) {
        ChannelHandlerContext channelHandlerContext;
        HttpObjectAggregator httpObjectAggregator;
        this.verify(fullHttpResponse);
        String string = fullHttpResponse.headers().get(HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL);
        string = string != null ? string.trim() : null;
        String string2 = this.expectedSubprotocol != null ? this.expectedSubprotocol : "";
        boolean bl2 = false;
        if (string2.isEmpty() && string == null) {
            bl2 = true;
            this.setActualSubprotocol(this.expectedSubprotocol);
        } else if (!string2.isEmpty() && string != null && !string.isEmpty()) {
            for (String object2 : string2.split(",")) {
                if (!object2.trim().equals(string)) continue;
                bl2 = true;
                this.setActualSubprotocol(string);
                break;
            }
        }
        if (!bl2) {
            throw new WebSocketHandshakeException(String.format("Invalid subprotocol. Actual: %s. Expected one of: %s", string, this.expectedSubprotocol));
        }
        this.setHandshakeComplete();
        String[] stringArray = channel.pipeline();
        HttpContentDecompressor httpContentDecompressor = stringArray.get(HttpContentDecompressor.class);
        if (httpContentDecompressor != null) {
            stringArray.remove(httpContentDecompressor);
        }
        if ((httpObjectAggregator = stringArray.get(HttpObjectAggregator.class)) != null) {
            stringArray.remove(httpObjectAggregator);
        }
        if ((channelHandlerContext = stringArray.context(HttpResponseDecoder.class)) == null) {
            ChannelHandlerContext channelHandlerContext2 = stringArray.context(HttpClientCodec.class);
            if (channelHandlerContext2 == null) {
                throw new IllegalStateException("ChannelPipeline does not contain a HttpRequestEncoder or HttpClientCodec");
            }
            HttpClientCodec httpClientCodec = (HttpClientCodec)channelHandlerContext2.handler();
            httpClientCodec.removeOutboundHandler();
            stringArray.addAfter(channelHandlerContext2.name(), "ws-decoder", this.newWebsocketDecoder());
            channel.eventLoop().execute(new WebSocketClientHandshaker$2(this, (ChannelPipeline)stringArray, httpClientCodec));
        } else {
            if (stringArray.get(HttpRequestEncoder.class) != null) {
                stringArray.remove(HttpRequestEncoder.class);
            }
            ChannelHandlerContext channelHandlerContext3 = channelHandlerContext;
            stringArray.addAfter(channelHandlerContext3.name(), "ws-decoder", this.newWebsocketDecoder());
            channel.eventLoop().execute(new WebSocketClientHandshaker$3(this, (ChannelPipeline)stringArray, channelHandlerContext3));
        }
    }

    public final ChannelFuture processHandshake(Channel channel, HttpResponse httpResponse) {
        return this.processHandshake(channel, httpResponse, channel.newPromise());
    }

    public final ChannelFuture processHandshake(Channel channel, HttpResponse httpResponse, ChannelPromise channelPromise) {
        if (httpResponse instanceof FullHttpResponse) {
            try {
                this.finishHandshake(channel, (FullHttpResponse)httpResponse);
                channelPromise.setSuccess();
            }
            catch (Throwable throwable) {
                channelPromise.setFailure(throwable);
            }
        } else {
            ChannelPipeline channelPipeline = channel.pipeline();
            ChannelHandlerContext channelHandlerContext = channelPipeline.context(HttpResponseDecoder.class);
            if (channelHandlerContext == null && (channelHandlerContext = channelPipeline.context(HttpClientCodec.class)) == null) {
                return channelPromise.setFailure(new IllegalStateException("ChannelPipeline does not contain a HttpResponseDecoder or HttpClientCodec"));
            }
            String string = "httpAggregator";
            channelPipeline.addAfter(channelHandlerContext.name(), string, new HttpObjectAggregator(8192));
            channelPipeline.addAfter(string, "handshaker", new WebSocketClientHandshaker$4(this, channel, channelPromise));
            try {
                channelHandlerContext.fireChannelRead(ReferenceCountUtil.retain(httpResponse));
            }
            catch (Throwable throwable) {
                channelPromise.setFailure(throwable);
            }
        }
        return channelPromise;
    }

    protected abstract void verify(FullHttpResponse var1);

    protected abstract WebSocketFrameDecoder newWebsocketDecoder();

    protected abstract WebSocketFrameEncoder newWebSocketEncoder();

    public ChannelFuture close(Channel channel, CloseWebSocketFrame closeWebSocketFrame) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        return this.close(channel, closeWebSocketFrame, channel.newPromise());
    }

    public ChannelFuture close(Channel channel, CloseWebSocketFrame closeWebSocketFrame, ChannelPromise channelPromise) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        return channel.writeAndFlush(closeWebSocketFrame, channelPromise);
    }

    static String rawPath(URI uRI) {
        String string = uRI.getRawPath();
        String string2 = uRI.getRawQuery();
        if (string2 != null && !string2.isEmpty()) {
            string = string + '?' + string2;
        }
        return string == null || string.isEmpty() ? "/" : string;
    }

    static CharSequence websocketHostValue(URI uRI) {
        int n2 = uRI.getPort();
        if (n2 == -1) {
            return uRI.getHost();
        }
        String string = uRI.getHost();
        if (n2 == HttpScheme.HTTP.port()) {
            return HttpScheme.HTTP.name().contentEquals(uRI.getScheme()) || WebSocketScheme.WS.name().contentEquals(uRI.getScheme()) ? string : NetUtil.toSocketAddressString(string, n2);
        }
        if (n2 == HttpScheme.HTTPS.port()) {
            return HttpScheme.HTTPS.name().contentEquals(uRI.getScheme()) || WebSocketScheme.WSS.name().contentEquals(uRI.getScheme()) ? string : NetUtil.toSocketAddressString(string, n2);
        }
        return NetUtil.toSocketAddressString(string, n2);
    }

    static CharSequence websocketOriginValue(URI uRI) {
        int n2;
        String string;
        String string2 = uRI.getScheme();
        int n3 = uRI.getPort();
        if (WebSocketScheme.WSS.name().contentEquals(string2) || HttpScheme.HTTPS.name().contentEquals(string2) || string2 == null && n3 == WebSocketScheme.WSS.port()) {
            string = HTTPS_SCHEME_PREFIX;
            n2 = WebSocketScheme.WSS.port();
        } else {
            string = HTTP_SCHEME_PREFIX;
            n2 = WebSocketScheme.WS.port();
        }
        String string3 = uRI.getHost().toLowerCase(Locale.US);
        if (n3 != n2 && n3 != -1) {
            return string + NetUtil.toSocketAddressString(string3, n3);
        }
        return string + string3;
    }

    static /* synthetic */ ClosedChannelException access$000() {
        return CLOSED_CHANNEL_EXCEPTION;
    }
}

