/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import io.netty.util.ReferenceCounted;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

public class WebSocket08FrameEncoder
extends MessageToMessageEncoder<WebSocketFrame>
implements WebSocketFrameEncoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocket08FrameEncoder.class);
    private static final byte OPCODE_CONT = 0;
    private static final byte OPCODE_TEXT = 1;
    private static final byte OPCODE_BINARY = 2;
    private static final byte OPCODE_CLOSE = 8;
    private static final byte OPCODE_PING = 9;
    private static final byte OPCODE_PONG = 10;
    private static final int GATHERING_WRITE_THRESHOLD = 1024;
    private final boolean maskPayload;

    public WebSocket08FrameEncoder(boolean bl2) {
        this.maskPayload = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, WebSocketFrame webSocketFrame, List<Object> list) {
        int n2;
        ByteBuf byteBuf = webSocketFrame.content();
        if (webSocketFrame instanceof TextWebSocketFrame) {
            n2 = 1;
        } else if (webSocketFrame instanceof PingWebSocketFrame) {
            n2 = 9;
        } else if (webSocketFrame instanceof PongWebSocketFrame) {
            n2 = 10;
        } else if (webSocketFrame instanceof CloseWebSocketFrame) {
            n2 = 8;
        } else if (webSocketFrame instanceof BinaryWebSocketFrame) {
            n2 = 2;
        } else if (webSocketFrame instanceof ContinuationWebSocketFrame) {
            n2 = 0;
        } else {
            throw new UnsupportedOperationException("Cannot encode frame of type: " + webSocketFrame.getClass().getName());
        }
        int n3 = byteBuf.readableBytes();
        if (logger.isDebugEnabled()) {
            logger.debug("Encoding WebSocket Frame opCode=" + n2 + " length=" + n3);
        }
        int n4 = 0;
        if (webSocketFrame.isFinalFragment()) {
            n4 |= 0x80;
        }
        n4 |= webSocketFrame.rsv() % 8 << 4;
        n4 |= n2 % 128;
        if (n2 == 9 && n3 > 125) {
            throw new TooLongFrameException("invalid payload for PING (payload length must be <= 125, was " + n3);
        }
        boolean bl2 = true;
        ReferenceCounted referenceCounted = null;
        try {
            int n5;
            int n6;
            int n7 = n6 = this.maskPayload ? 4 : 0;
            if (n3 <= 125) {
                n5 = 2 + n6;
                if (this.maskPayload || n3 <= 1024) {
                    n5 += n3;
                }
                referenceCounted = channelHandlerContext.alloc().buffer(n5);
                ((ByteBuf)referenceCounted).writeByte(n4);
                byte by2 = this.maskPayload ? (byte)(0x80 | (byte)n3) : (byte)n3;
                ((ByteBuf)referenceCounted).writeByte(by2);
            } else if (n3 <= 65535) {
                n5 = 4 + n6;
                if (this.maskPayload || n3 <= 1024) {
                    n5 += n3;
                }
                referenceCounted = channelHandlerContext.alloc().buffer(n5);
                ((ByteBuf)referenceCounted).writeByte(n4);
                ((ByteBuf)referenceCounted).writeByte(this.maskPayload ? 254 : 126);
                ((ByteBuf)referenceCounted).writeByte(n3 >>> 8 & 0xFF);
                ((ByteBuf)referenceCounted).writeByte(n3 & 0xFF);
            } else {
                n5 = 10 + n6;
                if (this.maskPayload || n3 <= 1024) {
                    n5 += n3;
                }
                referenceCounted = channelHandlerContext.alloc().buffer(n5);
                ((ByteBuf)referenceCounted).writeByte(n4);
                ((ByteBuf)referenceCounted).writeByte(this.maskPayload ? 255 : 127);
                ((ByteBuf)referenceCounted).writeLong(n3);
            }
            if (this.maskPayload) {
                int n8;
                n5 = (int)(Math.random() * 2.147483647E9);
                byte[] byArray = ByteBuffer.allocate(4).putInt(n5).array();
                ((ByteBuf)referenceCounted).writeBytes(byArray);
                ByteOrder byteOrder = byteBuf.order();
                ByteOrder byteOrder2 = ((ByteBuf)referenceCounted).order();
                int n9 = 0;
                int n10 = byteBuf.readerIndex();
                int n11 = byteBuf.writerIndex();
                if (byteOrder == byteOrder2) {
                    n8 = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
                    if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                        n8 = Integer.reverseBytes(n8);
                    }
                    while (n10 + 3 < n11) {
                        int n12 = byteBuf.getInt(n10);
                        ((ByteBuf)referenceCounted).writeInt(n12 ^ n8);
                        n10 += 4;
                    }
                }
                while (n10 < n11) {
                    n8 = byteBuf.getByte(n10);
                    ((ByteBuf)referenceCounted).writeByte(n8 ^ byArray[n9++ % 4]);
                    ++n10;
                }
                list.add(referenceCounted);
            } else if (((ByteBuf)referenceCounted).writableBytes() >= byteBuf.readableBytes()) {
                ((ByteBuf)referenceCounted).writeBytes(byteBuf);
                list.add(referenceCounted);
            } else {
                list.add(referenceCounted);
                list.add(byteBuf.retain());
            }
            bl2 = false;
        }
        finally {
            if (bl2 && referenceCounted != null) {
                referenceCounted.release();
            }
        }
    }
}

