/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.CharsetUtil;

public class CloseWebSocketFrame
extends WebSocketFrame {
    public CloseWebSocketFrame() {
        super(Unpooled.buffer(0));
    }

    public CloseWebSocketFrame(int n2, String string) {
        this(true, 0, n2, string);
    }

    public CloseWebSocketFrame(boolean bl2, int n2) {
        this(bl2, n2, Unpooled.buffer(0));
    }

    public CloseWebSocketFrame(boolean bl2, int n2, int n3, String string) {
        super(bl2, n2, CloseWebSocketFrame.newBinaryData(n3, string));
    }

    private static ByteBuf newBinaryData(int n2, String string) {
        if (string == null) {
            string = "";
        }
        ByteBuf byteBuf = Unpooled.buffer(2 + string.length());
        byteBuf.writeShort(n2);
        if (!string.isEmpty()) {
            byteBuf.writeCharSequence(string, CharsetUtil.UTF_8);
        }
        byteBuf.readerIndex(0);
        return byteBuf;
    }

    public CloseWebSocketFrame(boolean bl2, int n2, ByteBuf byteBuf) {
        super(bl2, n2, byteBuf);
    }

    public int statusCode() {
        ByteBuf byteBuf = this.content();
        if (byteBuf == null || byteBuf.capacity() == 0) {
            return -1;
        }
        byteBuf.readerIndex(0);
        short s2 = byteBuf.readShort();
        byteBuf.readerIndex(0);
        return s2;
    }

    public String reasonText() {
        ByteBuf byteBuf = this.content();
        if (byteBuf == null || byteBuf.capacity() <= 2) {
            return "";
        }
        byteBuf.readerIndex(2);
        String string = byteBuf.toString(CharsetUtil.UTF_8);
        byteBuf.readerIndex(0);
        return string;
    }

    @Override
    public CloseWebSocketFrame copy() {
        return (CloseWebSocketFrame)super.copy();
    }

    @Override
    public CloseWebSocketFrame duplicate() {
        return (CloseWebSocketFrame)super.duplicate();
    }

    @Override
    public CloseWebSocketFrame retainedDuplicate() {
        return (CloseWebSocketFrame)super.retainedDuplicate();
    }

    @Override
    public CloseWebSocketFrame replace(ByteBuf byteBuf) {
        return new CloseWebSocketFrame(this.isFinalFragment(), this.rsv(), byteBuf);
    }

    @Override
    public CloseWebSocketFrame retain() {
        super.retain();
        return this;
    }

    @Override
    public CloseWebSocketFrame retain(int n2) {
        super.retain(n2);
        return this;
    }

    @Override
    public CloseWebSocketFrame touch() {
        super.touch();
        return this;
    }

    @Override
    public CloseWebSocketFrame touch(Object object) {
        super.touch(object);
        return this;
    }
}

