/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelException;
import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.multipart.AbstractMemoryHttpData;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.InterfaceHttpData$HttpDataType;
import java.io.IOException;
import java.nio.charset.Charset;

public class MemoryAttribute
extends AbstractMemoryHttpData
implements Attribute {
    public MemoryAttribute(String string) {
        this(string, HttpConstants.DEFAULT_CHARSET);
    }

    public MemoryAttribute(String string, long l2) {
        this(string, l2, HttpConstants.DEFAULT_CHARSET);
    }

    public MemoryAttribute(String string, Charset charset) {
        super(string, charset, 0L);
    }

    public MemoryAttribute(String string, long l2, Charset charset) {
        super(string, charset, l2);
    }

    public MemoryAttribute(String string, String string2) {
        this(string, string2, HttpConstants.DEFAULT_CHARSET);
    }

    public MemoryAttribute(String string, String string2, Charset charset) {
        super(string, charset, 0L);
        this.setValue(string2);
    }

    @Override
    public InterfaceHttpData$HttpDataType getHttpDataType() {
        return InterfaceHttpData$HttpDataType.Attribute;
    }

    @Override
    public String getValue() {
        return this.getByteBuf().toString(this.getCharset());
    }

    @Override
    public void setValue(String string) {
        if (string == null) {
            throw new NullPointerException("value");
        }
        byte[] byArray = string.getBytes(this.getCharset());
        this.checkSize(byArray.length);
        ByteBuf byteBuf = Unpooled.wrappedBuffer(byArray);
        if (this.definedSize > 0L) {
            this.definedSize = byteBuf.readableBytes();
        }
        this.setContent(byteBuf);
    }

    @Override
    public void addContent(ByteBuf byteBuf, boolean bl2) {
        int n2 = byteBuf.readableBytes();
        this.checkSize(this.size + (long)n2);
        if (this.definedSize > 0L && this.definedSize < this.size + (long)n2) {
            this.definedSize = this.size + (long)n2;
        }
        super.addContent(byteBuf, bl2);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)object;
        return this.getName().equalsIgnoreCase(attribute.getName());
    }

    @Override
    public int compareTo(InterfaceHttpData interfaceHttpData) {
        if (!(interfaceHttpData instanceof Attribute)) {
            throw new ClassCastException("Cannot compare " + (Object)((Object)this.getHttpDataType()) + " with " + (Object)((Object)interfaceHttpData.getHttpDataType()));
        }
        return this.compareTo((Attribute)interfaceHttpData);
    }

    @Override
    public int compareTo(Attribute attribute) {
        return this.getName().compareToIgnoreCase(attribute.getName());
    }

    public String toString() {
        return this.getName() + '=' + this.getValue();
    }

    @Override
    public Attribute copy() {
        ByteBuf byteBuf = this.content();
        return this.replace(byteBuf != null ? byteBuf.copy() : null);
    }

    @Override
    public Attribute duplicate() {
        ByteBuf byteBuf = this.content();
        return this.replace(byteBuf != null ? byteBuf.duplicate() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Attribute retainedDuplicate() {
        ByteBuf byteBuf = this.content();
        if (byteBuf != null) {
            byteBuf = byteBuf.retainedDuplicate();
            boolean bl2 = false;
            try {
                Attribute attribute = this.replace(byteBuf);
                bl2 = true;
                Attribute attribute2 = attribute;
                return attribute2;
            }
            finally {
                if (!bl2) {
                    byteBuf.release();
                }
            }
        }
        return this.replace(null);
    }

    @Override
    public Attribute replace(ByteBuf byteBuf) {
        MemoryAttribute memoryAttribute = new MemoryAttribute(this.getName());
        memoryAttribute.setCharset(this.getCharset());
        if (byteBuf != null) {
            try {
                memoryAttribute.setContent(byteBuf);
            }
            catch (IOException iOException) {
                throw new ChannelException(iOException);
            }
        }
        return memoryAttribute;
    }

    @Override
    public Attribute retain() {
        super.retain();
        return this;
    }

    @Override
    public Attribute retain(int n2) {
        super.retain(n2);
        return this;
    }

    @Override
    public Attribute touch() {
        super.touch();
        return this;
    }

    @Override
    public Attribute touch(Object object) {
        super.touch(object);
        return this;
    }
}

