/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.CaseIgnoringComparator;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostBodyUtil$SeekAheadOptimize;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder$EndOfDataDecoderException;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder$ErrorDataDecoderException;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder$MultiPartStatus;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder$NotEnoughDataDecoderException;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import io.netty.util.internal.ObjectUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class HttpPostStandardRequestDecoder
implements InterfaceHttpPostRequestDecoder {
    private final HttpDataFactory factory;
    private final HttpRequest request;
    private final Charset charset;
    private boolean isLastChunk;
    private final List<InterfaceHttpData> bodyListHttpData = new ArrayList<InterfaceHttpData>();
    private final Map<String, List<InterfaceHttpData>> bodyMapHttpData = new TreeMap<CharSequence, List<InterfaceHttpData>>(CaseIgnoringComparator.INSTANCE);
    private ByteBuf undecodedChunk;
    private int bodyListHttpDataRank;
    private HttpPostRequestDecoder$MultiPartStatus currentStatus = HttpPostRequestDecoder$MultiPartStatus.NOTSTARTED;
    private Attribute currentAttribute;
    private boolean destroyed;
    private int discardThreshold = 0xA00000;

    public HttpPostStandardRequestDecoder(HttpRequest httpRequest) {
        this(new DefaultHttpDataFactory(16384L), httpRequest, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostStandardRequestDecoder(HttpDataFactory httpDataFactory, HttpRequest httpRequest) {
        this(httpDataFactory, httpRequest, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostStandardRequestDecoder(HttpDataFactory httpDataFactory, HttpRequest httpRequest, Charset charset) {
        this.request = ObjectUtil.checkNotNull(httpRequest, "request");
        this.charset = ObjectUtil.checkNotNull(charset, "charset");
        this.factory = ObjectUtil.checkNotNull(httpDataFactory, "factory");
        if (httpRequest instanceof HttpContent) {
            this.offer((HttpContent)((Object)httpRequest));
        } else {
            this.undecodedChunk = Unpooled.buffer();
            this.parseBody();
        }
    }

    private void checkDestroyed() {
        if (this.destroyed) {
            throw new IllegalStateException(HttpPostStandardRequestDecoder.class.getSimpleName() + " was destroyed already");
        }
    }

    @Override
    public boolean isMultipart() {
        this.checkDestroyed();
        return false;
    }

    @Override
    public void setDiscardThreshold(int n2) {
        this.discardThreshold = ObjectUtil.checkPositiveOrZero(n2, "discardThreshold");
    }

    @Override
    public int getDiscardThreshold() {
        return this.discardThreshold;
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas() {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
        }
        return this.bodyListHttpData;
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas(String string) {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
        }
        return this.bodyMapHttpData.get(string);
    }

    @Override
    public InterfaceHttpData getBodyHttpData(String string) {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder$NotEnoughDataDecoderException();
        }
        List<InterfaceHttpData> list = this.bodyMapHttpData.get(string);
        if (list != null) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public HttpPostStandardRequestDecoder offer(HttpContent httpContent) {
        this.checkDestroyed();
        ByteBuf byteBuf = httpContent.content();
        if (this.undecodedChunk == null) {
            this.undecodedChunk = byteBuf.copy();
        } else {
            this.undecodedChunk.writeBytes(byteBuf);
        }
        if (httpContent instanceof LastHttpContent) {
            this.isLastChunk = true;
        }
        this.parseBody();
        if (this.undecodedChunk != null && this.undecodedChunk.writerIndex() > this.discardThreshold) {
            this.undecodedChunk.discardReadBytes();
        }
        return this;
    }

    @Override
    public boolean hasNext() {
        this.checkDestroyed();
        if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.EPILOGUE && this.bodyListHttpDataRank >= this.bodyListHttpData.size()) {
            throw new HttpPostRequestDecoder$EndOfDataDecoderException();
        }
        return !this.bodyListHttpData.isEmpty() && this.bodyListHttpDataRank < this.bodyListHttpData.size();
    }

    @Override
    public InterfaceHttpData next() {
        this.checkDestroyed();
        if (this.hasNext()) {
            return this.bodyListHttpData.get(this.bodyListHttpDataRank++);
        }
        return null;
    }

    @Override
    public InterfaceHttpData currentPartialHttpData() {
        return this.currentAttribute;
    }

    private void parseBody() {
        if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.PREEPILOGUE || this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.EPILOGUE) {
            if (this.isLastChunk) {
                this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.EPILOGUE;
            }
            return;
        }
        this.parseBodyAttributes();
    }

    protected void addHttpData(InterfaceHttpData interfaceHttpData) {
        if (interfaceHttpData == null) {
            return;
        }
        List<InterfaceHttpData> list = this.bodyMapHttpData.get(interfaceHttpData.getName());
        if (list == null) {
            list = new ArrayList<InterfaceHttpData>(1);
            this.bodyMapHttpData.put(interfaceHttpData.getName(), list);
        }
        list.add(interfaceHttpData);
        this.bodyListHttpData.add(interfaceHttpData);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseBodyAttributesStandard() {
        int n2;
        int n3 = n2 = this.undecodedChunk.readerIndex();
        if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.NOTSTARTED) {
            this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.DISPOSITION;
        }
        boolean bl2 = true;
        try {
            int n4;
            block7: while (this.undecodedChunk.isReadable() && bl2) {
                char c2 = (char)this.undecodedChunk.readUnsignedByte();
                ++n3;
                switch (this.currentStatus) {
                    case DISPOSITION: {
                        String string;
                        if (c2 == '=') {
                            this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.FIELD;
                            int n5 = n3 - 1;
                            string = HttpPostStandardRequestDecoder.decodeAttribute(this.undecodedChunk.toString(n2, n5 - n2, this.charset), this.charset);
                            this.currentAttribute = this.factory.createAttribute(this.request, string);
                            n2 = n3;
                            continue block7;
                        }
                        if (c2 != '&') continue block7;
                        this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.DISPOSITION;
                        n4 = n3 - 1;
                        string = HttpPostStandardRequestDecoder.decodeAttribute(this.undecodedChunk.toString(n2, n4 - n2, this.charset), this.charset);
                        this.currentAttribute = this.factory.createAttribute(this.request, string);
                        this.currentAttribute.setValue("");
                        this.addHttpData(this.currentAttribute);
                        this.currentAttribute = null;
                        n2 = n3;
                        bl2 = true;
                        continue block7;
                    }
                    case FIELD: {
                        if (c2 == '&') {
                            this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.DISPOSITION;
                            n4 = n3 - 1;
                            this.setFinalBuffer(this.undecodedChunk.copy(n2, n4 - n2));
                            n2 = n3;
                            bl2 = true;
                            continue block7;
                        }
                        if (c2 == '\r') {
                            if (this.undecodedChunk.isReadable()) {
                                c2 = (char)this.undecodedChunk.readUnsignedByte();
                                if (c2 != '\n') throw new HttpPostRequestDecoder$ErrorDataDecoderException("Bad end of line");
                                this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.PREEPILOGUE;
                                n4 = ++n3 - 2;
                                this.setFinalBuffer(this.undecodedChunk.copy(n2, n4 - n2));
                                n2 = n3;
                                bl2 = false;
                                continue block7;
                            }
                            --n3;
                            continue block7;
                        }
                        if (c2 != '\n') continue block7;
                        this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.PREEPILOGUE;
                        n4 = n3 - 1;
                        this.setFinalBuffer(this.undecodedChunk.copy(n2, n4 - n2));
                        n2 = n3;
                        bl2 = false;
                        continue block7;
                    }
                }
                bl2 = false;
            }
            if (this.isLastChunk && this.currentAttribute != null) {
                n4 = n3;
                if (n4 > n2) {
                    this.setFinalBuffer(this.undecodedChunk.copy(n2, n4 - n2));
                } else if (!this.currentAttribute.isCompleted()) {
                    this.setFinalBuffer(Unpooled.EMPTY_BUFFER);
                }
                n2 = n3;
                this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.EPILOGUE;
            } else if (bl2 && this.currentAttribute != null && this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.FIELD) {
                this.currentAttribute.addContent(this.undecodedChunk.copy(n2, n3 - n2), false);
                n2 = n3;
            }
            this.undecodedChunk.readerIndex(n2);
            return;
        }
        catch (HttpPostRequestDecoder$ErrorDataDecoderException httpPostRequestDecoder$ErrorDataDecoderException) {
            this.undecodedChunk.readerIndex(n2);
            throw httpPostRequestDecoder$ErrorDataDecoderException;
        }
        catch (IOException iOException) {
            this.undecodedChunk.readerIndex(n2);
            throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseBodyAttributes() {
        int n2;
        if (!this.undecodedChunk.hasArray()) {
            this.parseBodyAttributesStandard();
            return;
        }
        HttpPostBodyUtil$SeekAheadOptimize httpPostBodyUtil$SeekAheadOptimize = new HttpPostBodyUtil$SeekAheadOptimize(this.undecodedChunk);
        int n3 = n2 = this.undecodedChunk.readerIndex();
        if (this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.NOTSTARTED) {
            this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.DISPOSITION;
        }
        boolean bl2 = true;
        try {
            int n4;
            block8: while (httpPostBodyUtil$SeekAheadOptimize.pos < httpPostBodyUtil$SeekAheadOptimize.limit) {
                char c2 = (char)(httpPostBodyUtil$SeekAheadOptimize.bytes[httpPostBodyUtil$SeekAheadOptimize.pos++] & 0xFF);
                ++n3;
                switch (this.currentStatus) {
                    case DISPOSITION: {
                        String string;
                        if (c2 == '=') {
                            this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.FIELD;
                            int n5 = n3 - 1;
                            string = HttpPostStandardRequestDecoder.decodeAttribute(this.undecodedChunk.toString(n2, n5 - n2, this.charset), this.charset);
                            this.currentAttribute = this.factory.createAttribute(this.request, string);
                            n2 = n3;
                            continue block8;
                        }
                        if (c2 != '&') continue block8;
                        this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.DISPOSITION;
                        n4 = n3 - 1;
                        string = HttpPostStandardRequestDecoder.decodeAttribute(this.undecodedChunk.toString(n2, n4 - n2, this.charset), this.charset);
                        this.currentAttribute = this.factory.createAttribute(this.request, string);
                        this.currentAttribute.setValue("");
                        this.addHttpData(this.currentAttribute);
                        this.currentAttribute = null;
                        n2 = n3;
                        bl2 = true;
                        continue block8;
                    }
                    case FIELD: {
                        if (c2 == '&') {
                            this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.DISPOSITION;
                            n4 = n3 - 1;
                            this.setFinalBuffer(this.undecodedChunk.copy(n2, n4 - n2));
                            n2 = n3;
                            bl2 = true;
                            continue block8;
                        }
                        if (c2 == '\r') {
                            if (httpPostBodyUtil$SeekAheadOptimize.pos < httpPostBodyUtil$SeekAheadOptimize.limit) {
                                c2 = (char)(httpPostBodyUtil$SeekAheadOptimize.bytes[httpPostBodyUtil$SeekAheadOptimize.pos++] & 0xFF);
                                ++n3;
                                if (c2 != '\n') {
                                    httpPostBodyUtil$SeekAheadOptimize.setReadPosition(0);
                                    throw new HttpPostRequestDecoder$ErrorDataDecoderException("Bad end of line");
                                }
                                this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.PREEPILOGUE;
                                n4 = n3 - 2;
                                httpPostBodyUtil$SeekAheadOptimize.setReadPosition(0);
                                this.setFinalBuffer(this.undecodedChunk.copy(n2, n4 - n2));
                                n2 = n3;
                                bl2 = false;
                                break block8;
                            }
                            if (httpPostBodyUtil$SeekAheadOptimize.limit <= 0) continue block8;
                            --n3;
                            continue block8;
                        }
                        if (c2 != '\n') continue block8;
                        this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.PREEPILOGUE;
                        n4 = n3 - 1;
                        httpPostBodyUtil$SeekAheadOptimize.setReadPosition(0);
                        this.setFinalBuffer(this.undecodedChunk.copy(n2, n4 - n2));
                        n2 = n3;
                        bl2 = false;
                        break block8;
                    }
                }
                httpPostBodyUtil$SeekAheadOptimize.setReadPosition(0);
                bl2 = false;
                break;
            }
            if (this.isLastChunk && this.currentAttribute != null) {
                n4 = n3;
                if (n4 > n2) {
                    this.setFinalBuffer(this.undecodedChunk.copy(n2, n4 - n2));
                } else if (!this.currentAttribute.isCompleted()) {
                    this.setFinalBuffer(Unpooled.EMPTY_BUFFER);
                }
                n2 = n3;
                this.currentStatus = HttpPostRequestDecoder$MultiPartStatus.EPILOGUE;
            } else if (bl2 && this.currentAttribute != null && this.currentStatus == HttpPostRequestDecoder$MultiPartStatus.FIELD) {
                this.currentAttribute.addContent(this.undecodedChunk.copy(n2, n3 - n2), false);
                n2 = n3;
            }
            this.undecodedChunk.readerIndex(n2);
            return;
        }
        catch (HttpPostRequestDecoder$ErrorDataDecoderException httpPostRequestDecoder$ErrorDataDecoderException) {
            this.undecodedChunk.readerIndex(n2);
            throw httpPostRequestDecoder$ErrorDataDecoderException;
        }
        catch (IOException iOException) {
            this.undecodedChunk.readerIndex(n2);
            throw new HttpPostRequestDecoder$ErrorDataDecoderException(iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.undecodedChunk.readerIndex(n2);
            throw new HttpPostRequestDecoder$ErrorDataDecoderException(illegalArgumentException);
        }
    }

    private void setFinalBuffer(ByteBuf byteBuf) {
        this.currentAttribute.addContent(byteBuf, true);
        String string = HttpPostStandardRequestDecoder.decodeAttribute(this.currentAttribute.getByteBuf().toString(this.charset), this.charset);
        this.currentAttribute.setValue(string);
        this.addHttpData(this.currentAttribute);
        this.currentAttribute = null;
    }

    private static String decodeAttribute(String string, Charset charset) {
        try {
            return QueryStringDecoder.decodeComponent(string, charset);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new HttpPostRequestDecoder$ErrorDataDecoderException("Bad string: '" + string + '\'', illegalArgumentException);
        }
    }

    @Override
    public void destroy() {
        this.cleanFiles();
        this.destroyed = true;
        if (this.undecodedChunk != null && this.undecodedChunk.refCnt() > 0) {
            this.undecodedChunk.release();
            this.undecodedChunk = null;
        }
    }

    @Override
    public void cleanFiles() {
        this.checkDestroyed();
        this.factory.cleanRequestHttpData(this.request);
    }

    @Override
    public void removeHttpDataFromClean(InterfaceHttpData interfaceHttpData) {
        this.checkDestroyed();
        this.factory.removeHttpDataFromClean(this.request, interfaceHttpData);
    }
}

